/* SCCS @(#)dissim.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          dissim.callback.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   dissim.callback.c                                   */
/*                                                                      */
/* DESCRIPTION  :   Display_show image interface                        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "dissim.layout.h"
#include "LaboImage.layout.h"
#include "libwidgets/widgetstructure.h"

#include "win4.h"
#include "affiche4.h"

extern Display *gDisplay;
extern Cursor gWatchcursor;
extern Widget  gLabowidget;


/******************************************************
/   activateCallback for Widget  DISPLAY_show_image_CANCEL 
/*****************************************************/

void
DISPLAY_show_image_CANCEL_callb(DISPLAY_show_image_CANCEL, DISPLAY_show_image_widget, callData)
	Widget DISPLAY_show_image_CANCEL;
	Widget DISPLAY_show_image_widget;
	caddr_t callData;
{
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (DISPLAY_show_image_CANCEL))));

    XtUnmanageChild (DISPLAY_show_image_widget);
}


/******************************************************
/   activateCallback for Widget  DISPLAY_show_image_OK 
/*****************************************************/

/*****************************************************************************/
/*									     */
/* nom      : proc_couleur_rgb						     */
/*									     */
/* fonction : declenche l'affichage d'une image couleur RGB		     */
/*                                                                           */
/* entrees  : int mode	        	 : Type de rgb                       */
/*                                                                           */
/* globales : description_memoire dir_desc				     */
/*	      int index_memoire[6]					     */
/*	      char *buf							     */
/*									     */
/* return : neant                                     	   	     	     */
/*									     */
/* routines : fromto							     */
/*	      write_erreur						     */
/*	      write_master						     */
/*									     */
/*****************************************************************************/

void proc_couleur_rgb (mode)
	int mode;

{
    if (mode == 0) sprintf (buf, mastertabs[10]);
    else sprintf (buf, mastertabs[11]);
    write_master (buf);
    sprintf (buf, "Image %d %d %d\n", 
	     index_image[0], index_image[2], index_image[4]);
    write_master (buf);

    if (
	dir_desc[index_image[0]].nligne!=dir_desc[index_image[2]].nligne ||
	dir_desc[index_image[2]].nligne!=dir_desc[index_image[4]].nligne ||
	dir_desc[index_image[4]].nligne!=dir_desc[index_image[0]].nligne ||
	dir_desc[index_image[0]].ncolonne!=dir_desc[index_image[2]].ncolonne ||
	dir_desc[index_image[2]].ncolonne!=dir_desc[index_image[4]].ncolonne ||
	dir_desc[index_image[4]].ncolonne!=dir_desc[index_image[0]].ncolonne) {
      write_erreur(2);
      return;
    }
    if (dir_image[index_image[0]].image == NULL) {
      write_erreur(4);
      return;
    }
    if (dir_image[index_image[2]].image == NULL) {
      write_erreur(5);
      return;
    }
    if (dir_image[index_image[4]].image == NULL) {
      write_erreur(6);
      return;
    }
    if (mode == 0) displayplane (5, 3);
    else displayplane (6, 3);
}



void
DISPLAY_show_image_OK_callb(DISPLAY_show_image_OK, type, callData)
	Widget DISPLAY_show_image_OK;
        int type;
	caddr_t callData;
{
  XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
  XDefineCursor(gDisplay, 
		XtWindow(XtParent(XtParent(DISPLAY_show_image_OK))), 
		gWatchcursor);
  XFlush(gDisplay);

  switch (type) 
  {
    case DIS_THRESHOLD:
      /* anciennement proc_seuil */

      sprintf (buf, mastertabs[13]);
      write_master (buf);
      sprintf (buf, "Image %d\n", index_image[0]);
      write_master (buf);
      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	break;
      }
      displayplane (3, 1);
      break;
    case DIS_FLOYDST:
      /* anciennement proc_report_erreur */
      /* fonction : declenche l'affichage d'une image noir/blanc par   */
      /*	    Floyd-Steinberg				       */

      sprintf (buf, mastertabs[12]);
      write_master (buf);
      sprintf (buf, "Image %d\n", index_image[0]);
      write_master (buf);
      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	break;
      }
      displayplane (4, 1);
      break;
    case DIS_GRAYTONELIN:
      /* anciennement proc_gris_lin */
      /* fonction : declenche l'affichage d'une image par niveaux de  */
      /*            gris lineaire                                     */
    
      sprintf (buf, mastertabs[8]);
      write_master (buf);
      sprintf (buf, "Image %d\n", index_image[0]);
      write_master (buf);
      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	break;
      }
      displayplane (1, 1);
      break;
    case DIS_GRAYTONELOG:
      /* anciennement proc_gris_log */
      /* fonction : declenche l'affichage d'une image par niveaux de  */
      /*            gris logarithmique                                */

      sprintf (buf, mastertabs[9]);
      write_master (buf);
      sprintf (buf, "Image %d\n", index_image[0]);
      write_master (buf);
      if (dir_image[index_image[0]].image == NULL) {
	write_erreur(1);
	break;
      }
      displayplane (2, 1);	
      break;
    case DIS_RGBDIRECT:
	proc_couleur_rgb (0);
	break;
	case DIS_RGBFLOYDST:
	proc_couleur_rgb (1);
	break;
	case AUX_FREE_SINGLE_PLANE:
	proc_libere (1);
	break;
	case AUX_FREE_SINGLE_VECTOR:
	proc_libere (3);
	break;
	case DIS_MORPHO_BIN:
	/* anciennement proc_affiche_morphbin */

	sprintf(buf,mastertabs[98]);
	write_master(buf);

	sprintf (buf, "--> %d", index_image[0]);
	write_master (buf);

	entree_morpho (1);

	sprintf(buf,"\n"); 
	write_master (buf);

	break;
	default: break;
    }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (DISPLAY_show_image_OK))));

    XtUnmanageChild (XtParent (XtParent (DISPLAY_show_image_OK)));
}
