/* SCCS @(#)proedgrri.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      proedgrri.layout.c                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   proedgrri.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Processing Edge detection (ridge riding)            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "proedgrri.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;


/********************************************************
/   Callback Stubs for param_SET
/*******************************************************/

void
PRO_edg_ridge_param_OK_callb (options_OK, Paramprepro, callData)
	Widget options_OK;
	xs_struc_paramprepro *Paramprepro;
	caddr_t callData;
{
        float aval, bval,cval;
	char valdefmin[20], valdefmax[20], valdeflen[20];

	if (dir_image[index_image[0]].image == NULL) 
	{	
	  return;
	}
    
	aval = dir_desc[index_image[0]].mmin ;
	bval = dir_desc[index_image[0]].mmax ;
	cval = dir_desc[index_image[0]].mu ;

	sprintf(valdefmin,"%f", aval + (cval - aval)/2);
	sprintf(valdefmax,"%f", bval - (bval - cval)/2);
	sprintf(valdeflen,"%d", (int)(dir_desc[index_image[0]].nligne/10));

	XmTextSetString (Paramprepro->line, valdefmin);
	XmTextSetString (Paramprepro->colon, valdefmax);
	XmTextSetString (Paramprepro->alpha, valdeflen);
}


/********************************************************
/   Creation Function for PRO_edge_ridge_riding_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PRO_edge_ridge_riding_param_widget(PRO_edges_ridge_riding_param)
	Widget PRO_edges_ridge_riding_param;
{
	Widget PRO_edge_ridge_riding_param_widget;
	Widget minim_threshd_label;
	Widget maximum_threshd_label;
	Widget minim_length_label;
	Widget minim_threshd_text;
	Widget maximum_threshd_text;
	Widget minim_length_text;
	Widget param_SET;
	xs_struc_paramprepro *Paramprepro;
	Widget PRO_ridge_riding_Label_0;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PRO_edge_ridge_riding_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,256); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,185); n++;
	XtSetArg(args[n],XmNx,27); n++;
	XtSetArg(args[n],XmNy,19); n++;

	PRO_edge_ridge_riding_param_widget = 
	       XmCreateForm(PRO_edges_ridge_riding_param,
			    "PRO_edge_ridge_riding_param_widget",args,n);
	XtManageChild(PRO_edge_ridge_riding_param_widget);

	Paramprepro->parent = PRO_edge_ridge_riding_param_widget;

	/* Creating minim_threshd_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[297],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;

	minim_threshd_label = 
	        XmCreateLabel(PRO_edge_ridge_riding_param_widget,
			      "minim_threshd_label",args,n);
	XtManageChild(minim_threshd_label);

	/* Creating maximum_threshd_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[298],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;

	maximum_threshd_label = 
	      XmCreateLabel(PRO_edge_ridge_riding_param_widget,
			    "maximum_threshd_label",args,n);
	XtManageChild(maximum_threshd_label);

	/* Creating minim_length_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[299],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightPosition,40); n++;
	XtSetArg(args[n],XmNrightWidget,NULL); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;

	minim_length_label = 
	    XmCreateLabel(PRO_edge_ridge_riding_param_widget,
			  "minim_length_label",args,n);
	XtManageChild(minim_length_label);

	/* Creating minim_threshd_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,minim_threshd_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,15); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	minim_threshd_text = 
	        XmCreateText(PRO_edge_ridge_riding_param_widget,
			     "minim_threshd_text",args,n);
	XtManageChild(minim_threshd_text);

	Paramprepro->line = minim_threshd_text;

	/* Creating maximum_threshd_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,maximum_threshd_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,35); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	maximum_threshd_text = 
	       XmCreateText(PRO_edge_ridge_riding_param_widget,
			    "maximum_threshd_text",args,n);
	XtManageChild(maximum_threshd_text);

	Paramprepro->colon = maximum_threshd_text;

	/* Creating minim_length_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,minim_length_label); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,55); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	minim_length_text = 
	        XmCreateText(PRO_edge_ridge_riding_param_widget,
			     "minim_length_text",args,n);
	XtManageChild(minim_length_text);

	Paramprepro->alpha = minim_length_text;

	/* Creating PRO_ridge_riding_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[266],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	PRO_ridge_riding_Label_0 = 
	        XmCreateLabel(PRO_edge_ridge_riding_param_widget,
			      "PRO_ridge_riding_Label_0",args,n);
	XtManageChild(PRO_ridge_riding_Label_0);


	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 80); n++;

	param_SET = XmCreatePushButton(PRO_edge_ridge_riding_param_widget, 
				       "param_SET", args, n);

	XtManageChild(param_SET);

	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		      PRO_edg_ridge_param_OK_callb, Paramprepro);


	return(Paramprepro);
}
