/* SCCS @(#)select3planeO.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                        select3planeO.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   select3planeO.layout.c                              */
/*                                                                      */
/* DESCRIPTION  :   3 Output planes                                     */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "select3planeO.layout.h"
#include "widgetstructure.h"

#define MAX_ARGS 100

extern XmFontList gFontlist;
extern Pixel      gorchid, gthistle;

/********************************************************
/   Creation Function for Selection3Planesout 
/*******************************************************/

Widget
build_Selection3Planesout(select3planeoutput, IO_load_image_planeout_OK, message1, message2, message3)
	Widget select3planeoutput;
	Widget IO_load_image_planeout_OK;
        char *message1;
        char *message2;
        char *message3;
{
	Widget Selection3Planesout;
	Widget Select3Planeout0;
	Widget Select3Planeout1;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Selection3Planesout Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,1); n++;

	Selection3Planesout = 
	  XmCreateRowColumn(select3planeoutput,"Selection3Planesout",args,n);
	XtManageChild(Selection3Planesout);

	/* Creating Select3Planeout0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[100],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select3Planeout0 =
	   XmCreateLabel(Selection3Planesout,"Select3Planeout0",args,n);
	XtManageChild(Select3Planeout0);

	/* Creating Select3Planeout1 Widget */ 

	Select3Planeout1 = 
	  build_Select3Planeout1(Selection3Planesout, 
				 IO_load_image_planeout_OK, message1, message2, message3);

	return(Selection3Planesout);
}


/********************************************************
/   Creation Function for Select3Planeout1 
/*******************************************************/

Widget
build_Select3Planeout1(Selection3Planesout, IO_load_image_planeout_OK, message1, message2, message3)
	Widget Selection3Planesout;
	Widget IO_load_image_planeout_OK;
        char *message1;
        char *message2;
        char *message3;
{
	Widget Select3Planeout1;
	Widget Select3PlaneLabelout1;
	Widget SelectPlanesoutR;
	Widget SelectPlanesoutG;
	Widget SelectPlanesoutB;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Select3Planeout1 Widget */ 


	Select3Planeout1 = 
	    XmCreateRowColumn(Selection3Planesout,"Select3Planeout1",NULL,0);
	XtManageChild(Select3Planeout1);

	/* Creating Select3PlaneLabelout1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[102],
			XmSTRING_DEFAULT_CHARSET)); n++;

	Select3PlaneLabelout1 = 
	     XmCreateLabel(Select3Planeout1,"Select3PlaneLabelout1",args,n);
	XtManageChild(Select3PlaneLabelout1);

	/* Creating SelectPlanesoutR Widget */ 
	SelectPlanesoutR = 
	build_SelectPlanesoutR(Select3Planeout1, 
		 IO_load_image_planeout_OK, message1, 1);

	/* Creating SelectPlanesoutG Widget */ 
	SelectPlanesoutG = 
	build_SelectPlanesoutG(Select3Planeout1, 
		 IO_load_image_planeout_OK, message2, 2);

	/* Creating SelectPlanesoutB Widget */ 
	SelectPlanesoutB = 
	build_SelectPlanesoutB(Select3Planeout1, 
		 IO_load_image_planeout_OK, message3, 3);

	return(Select3Planeout1);
}


/********************************************************
/   Creation Function for SelectPlanesoutR 
/*******************************************************/

Widget
build_SelectPlanesoutR(Select3Planeout1, IO_load_image_planeout_OK, message, numplan)
	Widget Select3Planeout1;
	Widget IO_load_image_planeout_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesoutR;
	Widget SelectPlaneRLabel2out;
	Widget PlaneoutRnumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i,n;

	/* Creating SelectPlanesoutR Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesoutR = 
		XmCreateRowColumn(Select3Planeout1,"SelectPlanesoutR",args,n);
	XtManageChild(SelectPlanesoutR);

	/* Creating SelectPlaneRLabel2out Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneRLabel2out = 
		XmCreateLabel(SelectPlanesoutR,"SelectPlaneRLabel2out",args,n);
	XtManageChild(SelectPlaneRLabel2out);

	/* Creating PlaneoutRnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneoutRnumbers = 
		XmCreateForm(SelectPlanesoutR,"PlaneoutRnumbers",args,n);

	XtManageChild(PlaneoutRnumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;

	  Planeout[i] = XmCreateDrawnButton(PlaneoutRnumbers,"Planeout",args,n);
	  XtManageChild(Planeout[i]);
	  
	  Tableau_plans->plan_image[i] = Planeout[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Planeout[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesoutR);
}


/********************************************************
/   Creation Function for SelectPlanesoutG 
/*******************************************************/

Widget
build_SelectPlanesoutG(Select3Planeout1, IO_load_image_planeout_OK, message, numplan)
	Widget Select3Planeout1;
	Widget IO_load_image_planeout_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesoutG;
	Widget SelectPlaneGLabel2out;
	Widget PlaneoutGnumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i, n;

	/* Creating SelectPlanesoutG Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesoutG = 
		XmCreateRowColumn(Select3Planeout1,"SelectPlanesoutG",args,n);
	XtManageChild(SelectPlanesoutG);

	/* Creating SelectPlaneGLabel2out Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneGLabel2out = 
		XmCreateLabel(SelectPlanesoutG,"SelectPlaneGLabel2out",args,n);
	XtManageChild(SelectPlaneGLabel2out);

	/* Creating PlaneoutGnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneoutGnumbers = 
		XmCreateForm(SelectPlanesoutG,"PlaneoutGnumbers",args,n);

	XtManageChild(PlaneoutGnumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;


	  Planeout[i] = XmCreateDrawnButton(PlaneoutGnumbers,"Planeout",args,n);
	  XtManageChild(Planeout[i]);
	  
	  Tableau_plans->plan_image[i] = Planeout[i];
	}

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Planeout[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesoutG);
}


/********************************************************
/   Creation Function for SelectPlanesoutB 
/*******************************************************/

Widget
build_SelectPlanesoutB(Select3Planeout1, IO_load_image_planeout_OK, message, numplan)
	Widget Select3Planeout1;
	Widget IO_load_image_planeout_OK;
        char *message;
	int numplan;
{
	Widget SelectPlanesoutB;
	Widget SelectPlaneBLabel2out;
	Widget PlaneoutBnumbers;
	Widget Planeout[MAX_IMAGE];
	plan_image_select *Tableau_plans;
	char num[4];
	Arg args[MAX_ARGS];
	int i,n;

	/* Creating SelectPlanesoutB Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	SelectPlanesoutB = 
		XmCreateRowColumn(Select3Planeout1,"SelectPlanesoutB",args,n);
	XtManageChild(SelectPlanesoutB);

	/* Creating SelectPlaneBLabel2out Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(message,
			XmSTRING_DEFAULT_CHARSET)); n++;

	SelectPlaneBLabel2out = 
		XmCreateLabel(SelectPlanesoutB,"SelectPlaneBLabel2out",args,n);
	XtManageChild(SelectPlaneBLabel2out);

	/* Creating PlaneoutBnumbers Widget */ 

	n = 0;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	PlaneoutBnumbers = 
		XmCreateForm(SelectPlanesoutB,"PlaneoutBnumbers",args,n);

	XtManageChild(PlaneoutBnumbers);

	/* Creating Planeout[MAX_IMAGE] Widgets */ 
	Tableau_plans = 
	    (plan_image_select *) malloc (sizeof (plan_image_select));

	for (i=0;i < MAX_IMAGE; i++){
	  itoa (i, num);	 
	  n = 0;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  if (i == 0) XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
	  else
	  {
	    XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);n++;
	    XtSetArg(args[n],XmNleftWidget,Planeout[i-1]);
	  }
	  n++;
	  XtSetArg(args[n],XmNwidth, 20); n++;
	  XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(num,
			XmSTRING_DEFAULT_CHARSET)); n++;
	  XtSetArg(args[n],XmNpushButtonEnabled,true); n++;
	  XtSetArg(args[n],XmNrecomputeSize,false); n++;
	  XtSetArg(args[n],XmNhighlightThickness, 0); n++;

	  /* Definition de l'occupation du plan represente par ce bouton!*/
	  if (Occupation_Plan(i) == 1){
	    XtSetArg (args[n],XmNforeground, gorchid); n++;
	  }
	  XtSetArg (args[n],XmNbackground, gthistle);n++;

	  Planeout[i] = XmCreateDrawnButton(PlaneoutBnumbers,"Planeout",args,n);
	  XtManageChild(Planeout[i]);
	  
	  Tableau_plans->plan_image[i] = Planeout[i];
	}	

	Tableau_plans->num_index = numplan;

	  /* Adding Callbacks for Planeout[i] */ 

	for (i=0;i < MAX_IMAGE; i++)
	  XtAddCallback(Planeout[i],
		XmNactivateCallback, planeout_selected,Tableau_plans);

	XtAddCallback(IO_load_image_planeout_OK,XmNactivateCallback,
		      libere_memoire,Tableau_plans);

	return(SelectPlanesoutB);
}
