/*ScianArrays.h
  Eric Pepke
  February 9, 1990
  Externally available stuff for arrays.
*/

#ifndef SCIANARRAYS
#define SCIANARRAYS
/*Array type*/

typedef ObjPtr ArrayPtr;

typedef struct
    {
        Thing thing;		/*The thing part, containing flags*/
	void *elements;		/*Pointer to the elements of the array*/
        int rank;		/*The rank of the array*/
        long *dims;		/*Dimensions start here--rank # of longs*/
    } Array, *APtr;

#define RANK(a) (((APtr) (a)) -> rank)
#define DIMS(a) (((APtr) (a)) -> dims)
#define ELEMENTS(a) (((APtr) (a)) -> elements)
#define ArrayMeat(ar) ((real *) ELEMENTS(ar))

typedef real threeArray[3];

/*Array types*/
#define AT_REAL		1	/*Array of reals*/
#define AT_OBJECT	2	/*Array of objects*/
#define AT_BYTE		3	/*Array of bytes (unsigned chars)*/
#define AT_POINTER	4	/*Array of random pointers*/
#define AT_SHORT	5	/*Array of shorts*/

#ifdef PROTO
real SearchFuzzyReal(ObjPtr array, real value);
real FuzzyRealIndex(ObjPtr array, real value);
ObjPtr NewRealArray(int, ...);
ObjPtr NewMatrix(void);
ObjPtr InterpArray(ObjPtr, ObjPtr, real);
void CArray2Array();
void Array2CArray();
void InitArrays(void);
void KillArrays(void);
ObjPtr NewArray(int arrayType, int rank, long *dimensions);
ObjPtr ListToArray(ObjPtr);
ObjPtr SortArrayByStringVar(ObjPtr, NameTyp);
ObjPtr SortArray(ObjPtr);
ObjPtr Uniq(ObjPtr);
long SearchReal(ObjPtr, real);
ObjPtr InsertInArray(ObjPtr, ObjPtr, long);
ObjPtr MergeRealArrays(ObjPtr, ObjPtr);
ObjPtr RealArrayDeltas(ObjPtr);
ObjPtr GetObjectElement(ObjPtr, long *);
long SearchStringVar(ObjPtr array, NameTyp whichVar, char *value);
#else
real SearchFuzzyReal();
real FuzzyRealIndex();
ObjPtr NewRealArray();
ObjPtr NewMatrix();
ObjPtr InterpArray();
void CArray2Array();
void Array2CArray();
void InitArrays();
void KillArrays();
ObjPtr NewArray();
ObjPtr ListToArray();
ObjPtr SortArrayByStringVar();
ObjPtr SortArray();
ObjPtr Uniq();
long SearchReal();
ObjPtr InsertInArray();
ObjPtr MergeRealArrays();
ObjPtr RealArrayDeltas();
ObjPtr GetObjectElement();
long SearchStringVar(ObjPtr array, NameTyp whichVar, char *value);
#endif

extern ObjPtr arrayClass;
extern ObjPtr objectArrayClass;

#endif

