/*ScianIcons.h
  Eric Pepke
  March 22, 1990
  Public stuff for icons
*/

#define ICONSIZE	32	/*Number of pixels an icon is wide*/
#define ICONSHADOW	8	/*Offset down to shadow of icon*/
#define ICONTEXTOFFSET	19	/*Offset down to an icon's text.*/
#if MACHINE == RS6000
#define ICONINVALEXTRA  50	/*Extra stuff to inval on side of icon*/
#else
#define ICONINVALEXTRA	0
#endif

/*Icon IDs*/
#define ICON3DSCALAR	32	/*3-D scalar field*/
#define ICONPHYSOBJ	33	/*Physical object*/
#define ICONMESH	34	/*Mesh*/
#define ICONVECTORS	35	/*Series of vectors*/
#define ICONBOX		36	/*Box attributes*/
#define ICONISOSURFACE	37	/*Isosurface and level*/
#define ICON2DSCALAR	38	/*2-D scalar field*/
#define ICONMATERIAL	39	/*Material properties*/
#define ICONQUESTION	40	/*Big question mark*/
#define ICONGEOMETRY	41	/*Geometry icon*/
#define ICONSLICE	42	/*Slice through a field*/
#define ICONSTOP	43	/*Stop button*/
#define ICONPLAY	44	/*Play button*/
#define ICONREV		45	/*Reverse play button*/
#define ICONFF		46	/*Fast forward button*/
#define ICONFR		47	/*Fast reverse button*/
#define ICONPARENT      48	/*Parent of a directory*/
#define ICONDIMDIF	49	/*Dim diffuse icon*/
#define ICONBRTDIF	50	/*Bright diffuse icon*/
#define ICONDIMTIGHT	51	/*Dim tight icon*/
#define ICONBRTTIGHT	52	/*Bright tight icon*/
#define ICONCLOCK	53	/*Clock icon*/
#define ICONLIGHTS	54	/*Lights icon*/
#define ICONOBSERVER	55	/*Eyeball icon*/
#define ICONFOLDER      56
#define ICONBINFILE	57
#define ICONDATAFILE	58
#define ICONTEXTFILE	59
#define ICONOBJFILE	60
#define ICONUNKNOWN	61
#define ICON4DSCALAR	62	/*4d + scalar field*/
#define ICONGRID	63	/*GRID icon*/
#define ICONJUSTDATA	64	/*Data for dataset*/
#define ICONCONTOURS	65	/*Contours*/
#define ICONCOLOR	66	/*Color*/
#define ICONTRACE	67	/*Tracer*/
#define ICONRENDERER	68	/*Renderer*/
#define ICON1DSCALAR	69	/*1D Scalar Field*/
#define ICON2DVECTOR	70	/*2D Vector Field*/
#define ICON3DVECTOR	71	/*3D Vector Field*/
#define ICON4DVECTOR	72	/*4 or more D Vector field*/
#define ICONSCIANDOC	73	/*SciAn document icon*/
#define ICONPOINTS	74	/*Points icon*/
#define ICONAXES	75	/*Axes icon*/
#define ICONWALLS	76	/*Walls icon*/
#define ICONCTABLE	77	/*Color table icon*/
#define ICONFREEFORM	78	/*Freeform tool icon*/
#define ICONSINE	79	/*Sine tool icon*/
#define ICONTRIANGLE	80	/*Triangle tool icon*/
#define ICONSAWTOOTH	81	/*Sawtooth tool icon*/
#define ICONTOOTHSAW	82	/*Toothsaw tool icon*/
#define ICONSQUARE	83	/*Square wave tool icon*/
#define ICONARROWS	84	/*Arrows icon*/
#define ICONFILEREADER	85	/*File reader icon*/
#define ICONDEFORM	86	/*Deform icon*/
#define ICONPROCESS	87	/*Running process*/
#define ICONWORKSTATION	88	/*Workstation*/
#define ICONCOMPUTER	89	/*Computer*/
#define ICONNWES	90	/*Arrows tool icon*/
#define ICONANNOTATION	91	/*Annotation icon*/
#define ICONRECTANGLE	92	/*Rectangle icon*/
#define ICONLINE	93	/*Line icon*/
#define ICONFINGER	94	/*Finger icon*/
#define ICONMOVEROTATE  95	/*3-D move/rotate*/
#define ICONLENGTH	96	/*Icon for length*/
#define ICONWIDTH	97	/*Icon for width*/
#define ICONPLANE	98	/*Airplane icon*/
#define ICON3DFINGER	99	/*3-D finger*/
#define ICONBALLS	100	/*Balls*/
#define ICONVISSIZE	101	/*Size*/
#define ICONNOTE	102	/*Note*/
#define ICONMETER	103	/*Meter*/
#define ICONSTICKS	104	/*Sticks visualization object*/
#define ICONLINES	105	/*Lines vis object*/
#define ICONDOTS	106	/*Dots vis object*/
#define ICONRIGHTEXP	107	/*Right control panex expansion icon*/
#define ICONMISSING	108	/*Missing data icon*/
#define ICONRECORDER	109	/*Recorder*/
#define ICONCOMM	110	/*Communications icon*/
#define ICONSTAR	111	/*Little star icon*/
#define ICONFRAME	112	/*Recorder frame icon*/

/*Draw icon flags*/
#define DI_DRAWFORE	1	/*Draw the foreground*/
#define DI_DRAWBACK	2	/*Draw the background*/
#define DI_DRAWSHADOW	4	/*Draw the shadow*/
#define DI_SMALLTEXT	8	/*Draw using smaller text*/
#define DI_GREY		16	/*Draw in grey*/

extern ObjPtr iconClass;	/*Class of all icons*/
extern int iconXOff, iconYOff;	/*Offsets for icons on dragging*/
extern int rainbowColor[];

#ifdef PROTO
void InitIcons(void);
void DrawIcon(int, int, int, char *, char *, int, int);
void DrawIconGhost(ObjPtr, int, int);
ObjPtr NewIcon(int, int, int, char *);
#else
void InitIcons();
void DrawIcon();
ObjPtr NewIcon();
void DrawIconGhost();
#endif
