#ifndef lint
static char sccsid[] = "@(#)tiffcmp.c	1.7 5/15/90";
#endif

/*
 * Copyright (c) 1988, 1990 by Sam Leffler.
 * All rights reserved.
 *
 * This file is provided for unrestricted use provided that this
 * legend is included on all tape media and as a part of the
 * software program in whole or part.  Users may copy, modify or
 * distribute this file at will.
 */

#include <stdio.h>
#include "tiffio.h"

#define	howmany(x, y)	(((x)+((y)-1))/(y))

int	stoponfirstdiff = 1;
u_short	bitspersample;
u_short	samplesperpixel;
u_short	imagewidth;
u_short	imagelength;

usage()
{
	fprintf(stderr, "Usage: tiffcmp [-l] file1 file2\n");
	exit(-3);
}

main(argc, argv)
	char *argv[];
{
	TIFF *tif1, *tif2;
	u_short config1, config2;
	int s, size1, size2, row;
	register u_char *p1, *p2;
	u_char *buf1, *buf2;
	int c;
	extern int optind;

	while ((c = getopt(argc, argv, "l")) != -1)
		switch (c) {
		case 'l':
			stoponfirstdiff = 0;
			break;
		case '?':
			usage();
			/*NOTREACHED*/
		}
	if (argc - optind < 2)
		usage();
	tif1 = TIFFOpen(argv[optind], "r");
	if (tif1 == NULL)
		exit(-1);
	tif2 = TIFFOpen(argv[optind+1], "r");
	if (tif2 == NULL)
		exit(-2);
	if (!CheckTag(tif1, tif2, TIFFTAG_BITSPERSAMPLE, "BitsPerSample"))
		exit(1);
	if (!CheckTag(tif1, tif2, TIFFTAG_SAMPLESPERPIXEL, "SamplesPerPixel"))
		exit(1);
	if (!CheckTag(tif1, tif2, TIFFTAG_IMAGEWIDTH, "ImageWidth"))
		exit(1);
	(void) TIFFGetField(tif1, TIFFTAG_BITSPERSAMPLE, &bitspersample);
	(void) TIFFGetField(tif1, TIFFTAG_IMAGEWIDTH, &imagewidth);
	(void) TIFFGetField(tif1, TIFFTAG_IMAGELENGTH, &imagelength);
	(void) TIFFGetField(tif1, TIFFTAG_SAMPLESPERPIXEL, &samplesperpixel);
	(void) TIFFGetField(tif1, TIFFTAG_PLANARCONFIG, &config1);
	(void) TIFFGetField(tif2, TIFFTAG_PLANARCONFIG, &config2);
	buf1 = (u_char *)malloc(size1 = TIFFScanlineSize(tif1));
	buf2 = (u_char *)malloc(size2 = TIFFScanlineSize(tif2));
	if (buf1 == NULL || buf2 == NULL) {
		fprintf(stderr, "No space for scanline buffers\n");
		exit(-1);
	}
	if (config1 != config2 && bitspersample != 8 && samplesperpixel > 1) {
		fprintf(stderr,
"Can't handle different planar configuration w/ different bits/sample\n");
		exit(-1);
	}
#define	pack(a,b)	((a)<<8)|(b)
	switch (pack(config1, config2)) {
	case pack(PLANARCONFIG_SEPARATE, PLANARCONFIG_CONTIG):
		for (row = 0; row < imagelength; row++) {
			if (TIFFReadScanline(tif2, buf2, row, 0) < 0)
				eof(tif2->tif_name, row, -1);
			for (s = 0; s < samplesperpixel; s++) {
				if (TIFFReadScanline(tif1, buf1, row, s) < 0)
					eof(tif1->tif_name, row, s);
				SeparateCompare(1, s, row, buf2, buf1);
			}
		}
		break;
	case pack(PLANARCONFIG_CONTIG, PLANARCONFIG_SEPARATE):
		for (row = 0; row < imagelength; row++) {
			if (TIFFReadScanline(tif1, buf1, row, 0) < 0)
				eof(tif1->tif_name, row, -1);
			for (s = 0; s < samplesperpixel; s++) {
				if (TIFFReadScanline(tif2, buf2, row, s) < 0)
					eof(tif2->tif_name, row, s);
				SeparateCompare(0, s, row, buf1, buf2);
			}
		}
		break;
	case pack(PLANARCONFIG_SEPARATE, PLANARCONFIG_SEPARATE):
		for (s = 0; s < samplesperpixel; s++)
			for (row = 0; row < imagelength; row++) {
				if (TIFFReadScanline(tif1, buf1, row, s) < 0)
					eof(tif1->tif_name, row, s);
				if (TIFFReadScanline(tif2, buf2, row, s) < 0)
					eof(tif2->tif_name, row, s);
				ContigCompare(s, row, buf1, buf2, size1);
			}
		break;
	case pack(PLANARCONFIG_CONTIG, PLANARCONFIG_CONTIG):
		for (row = 0; row < imagelength; row++) {
			if (TIFFReadScanline(tif1, buf1, row, 0) < 0)
				eof(tif1->tif_name, row, -1);
			if (TIFFReadScanline(tif2, buf2, row, 0) < 0)
				eof(tif2->tif_name, row, -1);
			ContigCompare(-1, row, buf1, buf2, size1);
		}
		break;
	}
	exit(0);
}

ContigCompare(sample, row, p1, p2, size)
	int sample, row;
	u_char *p1, *p2;
	int size;
{
	register int pix, ppb = 8/bitspersample;

	if (bcmp(p1, p2, size) == 0)
		return;
	switch (bitspersample) {
	case 1: case 2: case 4: case 8: {
		register u_char *pix1 = p1, *pix2 = p2;

		for (pix = 0; pix < imagewidth; pix1++, pix2++, pix += ppb)
			if (*pix1 != *pix2)
				PrintDiff(row, sample, pix,
				    *pix1, *pix2);
		break;
	}
	case 16: {
		register u_short *pix1 = (u_short *)p1, *pix2 = (u_short *)p2;

		for (pix = 0; pix < imagewidth; pix1++, pix2++, pix++)
			if (*pix1 != *pix2)
				PrintDiff(row, sample, pix,
				    *pix1, *pix2);
		break;
	}
	}
}

PrintDiff(row, sample, pix, w1, w2)
	register int w1, w2;
{
	register int mask, s;

	switch (bitspersample) {
	case 1:
		mask = 1<<8;
		for (s = 0; s < 8; mask >>= 1, s++)
			if ((w1 & mask) ^ (w2 & mask)) {
				w1 = (w1 >> s) & 1;
				w2 = (w2 >> s) & 1;
				break;
			}
		break;
	case 2:
		mask = 3<<6;
		for (s = 0; s < 4; mask >>= 2, s++)
			if ((w1 & mask) ^ (w2 & mask)) {
				w1 = (w1 >> 2*s) & 3;
				w2 = (w2 >> 2*s) & 3;
				break;
			}
		break;
	case 4:
		if ((w1 & 0xf0) ^ (w2 & 0xf0)) {
			s = 0;
			w1 >>= 4;
			w2 >>= 4;
		} else {
			s = 1;
			w1 &= 0xf;
			w2 &= 0xf;
		}
		break;
	case 8:
		s = 0;
	}
	if (sample < 0)
		sample = s;
	printf("Scanline %d, pixel %d, sample %d: %02x %02x\n",
	    row, pix, sample, w1, w2);
	if (stoponfirstdiff)
		exit(1);
}

SeparateCompare(reversed, sample, row, cp1, p2)
	int reversed, sample, row;
	register u_char *cp1, *p2;
{
	int npixels = imagewidth;
	register int pixel;

	cp1 += sample;
	for (pixel = 0; npixels-- > 0; pixel++, cp1 += samplesperpixel, p2++)
		if (*cp1 != *p2) {
			printf("Scanline %d, pixel %d, sample %d: ",
			    row, pixel, sample);
			if (reversed)
				printf("%02x %02x\n", *p2, *cp1);
			else
				printf("%02x %02x\n", *cp1, *p2);
			if (stoponfirstdiff)
				exit(1);
		}
}

CheckTag(tif1, tif2, tag, name)
	TIFF *tif1, *tif2;
	int tag;
	char *name;
{
	short v1, v2;

	if (TIFFGetField(tif1, tag, &v1)) {
		if (!TIFFGetField(tif2, tag, &v2)) {
			printf("Tag \"%s\" appears only in %s\n",
			    name, tif1->tif_name);
			return (0);
		}
	} else if (TIFFGetField(tif2, tag, &v2)) {
		printf("Tag \"%s\" appears only in %s\n",
		    name, tif2->tif_name);
		return (0);
	}
	if (v1 != v2) {
		printf("Difference for tag \"%s\" (%d != %d)\n", name, v1, v2);
		return (0);
	}
	return (1);
}

eof(name, row, s)
	char *name;
	int row, s;
{

	printf("%s: EOF at scanline %d", name, row);
	if (s >= 0)
		printf(", sample %d", s);
	printf("\n");
	exit(1);
}
