/* Name: echoascii - Echo binary format to ascii filter */

static char SccsId[] = "@(#)cytoacad.c	1.2";

/* NOT VERY GOOD CODE, ONLY -t OPTION WORKS WELL */

#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include "cyfile.h"

#define real float

#define TRUE	1
#define FALSE	0

extern int errno;
extern void perror();


main(argc, argv)

int argc;
char *argv[];
{
	int fd;				/* image file descriptor */
	GSPEC *gs;			/* file header buffer base pointer */
	int lt, lg;			/* data array subscripts */
	long int theta, y, radius;	/* coordinates, cylindrical */
	long z;
	float fx, fy, fz;			/* coordinates, cartesian */
	float sin_theta, cos_theta;	/* time savers */
	char *image_pathname = 0;	/* pathname of target image */
	int do_latitudes = FALSE;
	int do_longitudes = FALSE;
	int do_mesh = FALSE;
	int close_latitudes = FALSE;
	int verticies;

	if (argc > 1) {
		if (*argv[1] == '-') {
			for (++argv[1]; *argv[1] != '\0'; ++argv[1]) {
				switch (*argv[1]) {
				default:
					break;
				case 't':
					do_latitudes = TRUE;
					break;
				case 'g':
					do_longitudes = TRUE;
					break;
				case 'm':
					do_mesh = TRUE;
					break;
				}
			}
		}
	}
	
	if ((gs = cyread(NULL, 0)) == NULL) {
		fprintf(stderr, "Cytoacad: problem reading file\n");
		exit(-1);
	}

	if (do_longitudes) {
		/* output each point as an ascii cartesian point */
		theta = gs->lgmin * gs->lgincr;
		for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
			y = gs->ltmin * gs->ltincr;
			cos_theta = cos(URTOR(-theta));
			sin_theta = sin(URTOR(theta));
			puts("3DPOLY");
			for (lt = gs->ltmin; lt <= gs->ltmax; ++lt) {
				radius = GETR(gs, lt, lg);
				if (radius != VOID) {
					fx = sin_theta * (float)radius * 1e-6;
					fz = cos_theta * (float)radius * 1e-6;
				} else {
					fx = 0.;
					fz = 0.;
				}
				fy = y * 1e-6;
				printf("%f,%f,%f\n", fx, fy, fz);
				y += gs->ltincr;
			}
			puts("");
			theta += gs->lgincr;
		}
	}

	if (do_mesh) {
		/* output each point as an ascii cartesian point */
		theta = gs->lgmin * gs->lgincr;
		printf("3DMESH\n%d\n%d\n",
			gs->lgmax - gs->lgmin + 1,
			gs->ltmax - gs->ltmin + 1
		);
		for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
			y = gs->ltmin * gs->ltincr;
			cos_theta = cos(URTOR(-theta));
			sin_theta = sin(URTOR(theta));
			for (lt = gs->ltmin; lt <= gs->ltmax; ++lt) {
				radius = GETR(gs, lt, lg);
				if (radius != VOID) {
					fx = sin_theta * (float)radius * 1e-6;
					fz = cos_theta * (float)radius * 1e-6;
				} else {
					fx = 0.;
					fz = 0.;
				}
				fy = y * 1e-6;
				printf("%f,%f,%f\n", fx, fy, fz);
				y += gs->ltincr;
			}
			theta += gs->lgincr;
		}
	}

	if (do_latitudes) {
		if (!(gs->flags & FLAG_CARTESIAN)) {
			if (abs((gs->lgmax-gs->lgmin+1)*gs->lgincr-6283185) < 12271) {
				close_latitudes = TRUE;
			} else {
				close_latitudes = FALSE;
			}
		}
		/* output each point as an ascii cartesian point */
		z = gs->ltmin * gs->ltincr;
		for (lt = gs->ltmin; lt <= gs->ltmax; ++lt) {
			verticies = 0;
			fz = z * 1e-6;
			theta = gs->lgmin * gs->lgincr;
			for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
				if (gs->flags & FLAG_CARTESIAN) {
					;
				} else {
					cos_theta = cos(URTOR(-theta));
					sin_theta = sin(URTOR(theta));
				}
				radius = GETR(gs, lt, lg);
				if (radius != VOID) {
					if (verticies == 0) {
						puts("3DPOLY");		/* start polyline */
					}
					/* add a vertex to polyline */
					if (gs->flags & FLAG_CARTESIAN) {
						fx = (float)theta * 1e-6;
						fy = (float)radius * 1e-6;
					} else {
						fx = sin_theta * (float)radius * 1e-6;
						fy = cos_theta * (float)radius * 1e-6;
					}
					printf("%f,%f,%f\n", fx, fy, fz);
					++verticies;
				} else {
					/* data is void, if unit 'line' fake it */
					if (verticies == 1) {		/* special case */
						printf("%f,%f,%f\n", fx, fy, fz);
						puts("");
						verticies = 0;
					} else if (verticies > 1) { /* if drawing a line, end it */
						puts("");
						verticies = 0;
					}
				}
				theta += gs->lgincr;
			}
			if (close_latitudes && getr(gs, lt, gs->lgmin) != VOID) {
				if (verticies == 1) {
					printf("%f,%f,%f\n", fx, fy, fz);
				}
			}
			puts("");
			z += gs->ltincr;
		}
	}
}
