/* module:	4dd_echo.c			echo system main module */

static char SccsId[] = "@(#)4dd_echo.c	1.1";

#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <malloc.h>
#include <gl.h>

#include "4dd_echo.h"
#include "4dd_cyfile.h"

/* define globals */

short termflag = 0;		/* terminate flag, set by terminate() */
short interrupt = 0;	/* interrupt flag, set to signal */

extern int errno;



main(argc, argv, envp)

int argc;
char **argv;
char **envp;
{
	GSPEC *gs;			/* pointer to current gspec table */
	char *cp;
	char *prompt;
	int exit_value;

	environment();

	prompt = "Echo Demo> ";

	/* allocate a dummy image header buffer */
	if ((gs = gsallo()) == NULL) {
		exit(-1);
	}
	gs->saved = 0;
	gs->valid = 0;

	/* Operates in one of two modes:
	 * 		Single command mode where the command in argv is executed,
	 *		Normal command mode where a prompt is issued.
	 */

	if (argc > 1) {
		exit_value = singlecmd(gs, argc, argv);
	} else {
		command_mode_init();
		exit_value = commandloop(gs, prompt);
		command_mode_free();
	}
	cyfree(gs);

	/* return to shell */
	exit(exit_value);
}



command_mode_init()
{
	putchar('\n');
	puts("Echo Demo Image Viewer");
	putchar('\n');

	echoset();				/* set to catch signals */
}


command_mode_free()
{
}



commandloop(gs, prompt)

GSPEC *gs;
char *prompt;
{
	while (termflag == 0) {
		interrupt = 0;				/* clear interrupts */
		fputs(prompt, stdout);		/* prompt */
		command(gs);				/* accept and execute a command */
	}
}



singlecmd(gs, argc, argv)

GSPEC *gs;
int argc;
char *argv[];
{
	char *string[512];

	*string = '\0';
	/* concatenate args into a string */
	while (--argc > 0) {
		strcat(string, *++argv);
		strcat(string, " ");
	}
	if ((gs = cyread(gs, -1)) == NULL) {
		return(-1);
	}
	return(executecmd(gs, string));
}



command(gs)		/* accept and execute a command */

GSPEC *gs;
{
	char cmdbuf[80], c;
	short n;
	short length;
	extern char *gets();

	fflush(stdout);

	fgets(cmdbuf, 80, stdin);
	return(executecmd(gs, cmdbuf));
}



executecmd(gs, cmd)

GSPEC *gs;
char *cmd;
{
	char command[128];
	char *token;
	struct CMDTAB *ct;
	short length;

	strcpy(command, cmd);

	if ((token = strtok(cmd, " \t\n")) == 0) {	/* break string into tokens */
		return(0);
	}
	length = strlen(token);				/* command string length for abbr. */

	/* find command in command table, execute it */
	for (ct = cmdtab; ct->unique != 0; ++ct) {
		if (strncmp(token, ct->keyword, length) == 0 && length >= ct->unique) {
			/* found command, pass parsed command line, execute */
			if (ct->function(gs, token) == -1) {
				/* command returned error */
				puts("Command failed");
				return(-1);
			} else {
				/* command successful */
				return(0);
			}
		}
	}
	
	/* command not found */
	printf("%s: %s\n", "Unrecognized command", token);
	return(-1);
}



echosig(sig)

int sig;
{
	switch (sig) {

	case SIGHUP:
		puts("SIGHUP, exiting");
		exit(-1);
	case SIGINT:
		signal(SIGINT, echosig);
		break;
	case SIGQUIT:
		signal(SIGQUIT, echosig);
		break;
	case SIGPIPE:
		signal(SIGPIPE, echosig);
		break;
	case SIGALRM:
		signal(SIGALRM, SIG_IGN);
		break;
	case SIGFPE:
		signal(SIGFPE, echosig);
		puts("SIGFPE trap");
		break;
#ifdef IRIS4
	case SIGTERM:
		signal(SIGALRM, SIG_IGN);
		break;
	case SIGCLD:
		signal(SIGALRM, SIG_IGN);
		break;
#endif
	default:
		return;
	}
	interrupt = sig;
}



echoset()
{
	signal(SIGHUP, echosig);
	signal(SIGINT, echosig);
	signal(SIGQUIT, echosig);
	signal(SIGALRM, echosig);
	signal(SIGFPE, echosig);
	signal(SIGPIPE, echosig);
#ifdef IRIS
	signal(SIGCLD, SIG_IGN);
#endif
#ifdef SUN
	signal(SIGCHLD, SIG_IGN);
#endif
	signal(SIGTERM, SIG_IGN);
	signal(SIGUSR1, SIG_IGN);
	signal(SIGUSR2, SIG_IGN);
}



environment()
{
	/* initialize the environment, depending on version */
	edit_config();
}



echo_scale(gs, cmd)

GSPEC *gs;
char *cmd;
{
	register int lg, lt;
	register int factor, r;

	if (gs->valid == 0) {
		return(-1);
	}

	if ((factor = atoi(nextword(cmd))) < 1 || factor > 200) {
		puts("Scale percentage out of range (1...200)");
		return(-1);
	}

	for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
		for (lt = gs->ltmin; lt <= gs->ltmax; ++lt) {
			if ((r = GETR(gs, lt, lg)) != VOID)
				PUTR(gs, lt, lg, SCALE(r, factor));
		}
	}
	gs->ltincr = SCALE(gs->ltincr, factor);
	gs->ltsize = gs->nlt * gs->ltincr;
	gs->scale = (gs->scale * factor) / 100.;
	gs->rmin = SCALE(gs->rmin, factor);
	gs->rmax = SCALE(gs->rmax, factor);
	gs->saved = 0;
	return(0);
}
