/* module: 4dd_misc.c misc commands */

static char SccsId[] = "@(#)4dd_misc.c	1.1";

#include <stdio.h>
#include <math.h>
#include <ctype.h>

#include "4dd_echo.h"
#include "4dd_cyfile.h"

extern int errno;



status_short(gs, cmd)

GSPEC *gs;
char *cmd;
{
	if (gs->valid == 0) {
		return(-1);
	}

	statprint(gs, FALSE);
	return(0);
}


status_long(gs, cmd)

GSPEC *gs;
char *cmd;
{
	if (gs->valid == 0) {
		return(-1);
	}

	statprint(gs, TRUE);
	return(0);
}



rminmax(gs)

GSPEC *gs;
{
	register int r, min, max;
	register int lg, lt;
	register int nvoid = 0;

	min = MAXR;
	max = MINR;
	for (lg = gs->lgmin; lg <= gs->lgmax; ++lg) {
		for (lt = gs->ltmin; lt <= gs->ltmax; ++lt) {
			r = GETR(gs, lt, lg);
			if (r != VOID) {
				min = MIN(r, min);
				max = MAX(r, max);
			} else {
				++nvoid;
			}
		}
	}
	gs->rmin = min;
	gs->rmax = max;
	if (nvoid > 0) gs->filled = 0;
}



statprint(gs, long_flag)

GSPEC *gs;
{
	if (gs->name[0] == '\000') {
		printf("UNNAMED\n");
	} else {
		printf("%s\n", gs->name);
	}

	if (long_flag) {
		printf("camera=%d format=%d\n", gs->camera, gs->setup);
		printf("nlt=%d ltincr=%dum ltsize=%dum\n",
			gs->nlt, gs->ltincr, gs->ltsize);
		printf("nlg=%d lgincr=%dur lgsize=%dur\n",
			gs->nlg, gs->lgincr, gs->lgsize);
		printf("latr=%d/%d longr=%d/%d rrange=%d/%d\n", gs->ltmin, gs->ltmax,
		   gs->lgmin, gs->lgmax, gs->rmin, gs->rmax);
		printf("rshift=%d\n", gs->rshift);
		printf("scale=%.2f%% rprop=%.2f%%\n",
		   (float)gs->scale, (float)gs->rprop);
		printf("smoothed=%d %s %s %s\n",
		   gs->smoothed, (gs->filled) ? "filled" : "\0",
		   (gs->flags & FLAG_CARTESIAN)?"Cartesian":"Cylindrical",
		   (gs->flags & FLAG_BILATERAL)?"Bilateral":""
		);
	}
	printf("%svalid, %ssaved\n",(gs->valid ? "":"not "),(gs->saved ?"":"not "));
}



exit_(gs, cmd)

GSPEC *gs;
char *cmd;
{
	termflag = 1;
	return(0);
}



echoclear(gs, cmd)

GSPEC *gs;
char *cmd;
{
	if (gs != NULL) {
		gs->valid = 0;
	}
	return(0);
}



name(gs, cmd)					/* display or change name */

GSPEC *gs;
char *cmd;
{
	int i = NAMELEN-1;

	if (gs->valid == 0) {
		return(-1);
	}

	if ((cmd = nextword(cmd)) == 0) {
		puts(gs->name);
	} else {
		*gs->name = 0;
		strncat(gs->name, cmd, i);
		i -= strlen(cmd);
		while (i > 0 && (cmd = nextword(cmd)) != 0) {
			strcat(gs->name, " ");
			if (--i > 0) {
				strncat(gs->name, cmd, i);
				i -= strlen(cmd);
			}
		}
	}
	return(0);
}



dlong(gs, cmd)

GSPEC *gs;
char *cmd;
{
	int lt, lg;
	int r;
	short int i;

	if (gs->valid == 0) {
		return(-1);
	}

	if ((cmd = nextword(cmd)) != 0) {
		if ((lg = atoi(cmd)) < gs->lgmin || lg > gs->lgmax) {
			return(-1);
		}
	} else {
		lg = gs->lgmin;
	}

	for (lt = 0; lt < (gs->nlt+15)/16; ++lt) {
		if (interrupt) break;
		for (i = 0; i < 16; ++i) {
			if (lt < gs->nlt) {
				if ((lt+(i*16) <= gs->ltmax) && (lt+(i*16) >= gs->ltmin)) {
					if ((r = GETR(gs, lt+(i*16), lg)) >= 0) {
						printf("%4.4d", r/100);
					} else {
						if (r == VOID) {
							printf(" -- ");
						} else {
							printf(" ?? ");
						}
					}
				} else {
					printf(" xx ");
				}
				putchar((i==15) ? '\n' : ' ');
			}
		}
	}
	return(0);
}



dlat(gs, cmd)

GSPEC *gs;
char *cmd;
{
	int lt, lg, lgmid;
	int r;
	short int i;

	if (gs->valid == 0) {
		return(-1);
	}

	if ((cmd = nextword(cmd)) != 0) {
		if ((lt = atoi(cmd)) < gs->ltmin || lt > gs->ltmax) {
			return(-1);
		}
	} else {
		lt = gs->ltmin;
	}

	for (lg = 0; lg < (gs->nlg + 15)/16; ++lg) {
		if (interrupt) break;
		for (i = 0; i < 16; ++i) {
			if (lg < gs->nlg) {
				if ((lg+(i*32) <= gs->lgmax) && (lg+(i*32) >= gs->lgmin)) {
					if ((r = GETR(gs, lt, lg+(i*32))) >= 0) {
						printf("%4.4d", r/100);
					} else {
						if (r == VOID) {
							printf(" -- ");
						} else {
							printf(" ?? ");
						}
					}
				} else {
					printf(" xx ");
				}
				putchar((i==15) ? '\n' : ' ');
			}
		}
		putchar((lg==15) ? '\n' : '\0');
		
	}
	return(0);
}


flagset(gs, cmd)

GSPEC *gs;
char *cmd;
{
	if ((cmd = nextword(cmd)) != 0) {
		if (*cmd == '-') {
			while (*++cmd != 0) {
				switch (*cmd) {
				default:
					return(-1);
				case 'r':
					gs->flags |= FLAG_CARTESIAN;
					break;
				case 'c':
					gs->flags &= ~FLAG_CARTESIAN;
					break;
				case 'b':
					gs->flags |= FLAG_BILATERAL;
					break;
				case 'u':
					gs->flags &= ~FLAG_BILATERAL;
					break;
				}
			}
		} else {
			return(-1);
		}
	} else {
		return(-1);
	}
	return(0);
}


shell(gs, cmd)

GSPEC *gs;
char *cmd;
{
	char command[256];			/* the command to be repeatedly executed */

	if ((cmd = nextword(cmd)) == 0) {
		return(-1);
	}

	/* reassemble command string from tokens */
	*command = 0;
	do {
		strcat(command, cmd);
		strcat(command, " ");
	} while (cmd = nextword(cmd));

	/* execute the command */
	system(command);
	return(0);
}
