#include	<stdio.h>
#include	"cmap.h"
#include	<X11/AsciiText.h>
#include	<X11/Box.h>

typedef	char	PALETTE[256][3];	/* Determines ".lut" file format */

char	curfname[128];

char *schemename[] = { "rgb", "hsv", "yiq", NULL };

extern char	*malloc(), *strcpy();

int
clean_name(name)
	char name[];
{
	register int len;

	len = strlen(name);
	/* Strip trailing known suffixes */
	if(len >= 4 && (memcmp(name+len-4, ".lut", 4) == 0
				 || memcmp(name+len-4, ".Cbx", 4) == 0))
		len -= 4;
	else if(len >= 6 && memcmp(name+len-6, ".table", 6) == 0)
		len -= 6;
	name[len] = '\0';
	panelMessage("%s", name);
	return(len);
}

void
file_save(namebuf, dotable)
	char namebuf[];
	int dotable;
{
    int		i, which;
    int		len;
    int		nfd;
    FILE	*f;
    Arg		arg;
    PALETTE	pal;
    XPoint	p[256];

    if(namebuf[0] != '\0')
	strcpy(curfname, namebuf);
    len = clean_name(curfname);
    if(len == 0) {
	panelMessage("Type file name here first");
	return;
    }
    strcpy(curfname+len, ".lut");

    if( (nfd = creat(curfname, 0644) ) <= 0) {
	perror(curfname);
	return;
    }
    for(i=0; i < 256; i++) {
	pal[i][0] = lut[i].red >> 8;
	pal[i][1] = lut[i].green >> 8;
	pal[i][2] = lut[i].blue >> 8;
    }
    write(nfd, (char *)pal, sizeof(pal));
    close(nfd);

    /*
     *	write out the boxes
     */
    strcpy (curfname+len, ".Cbx");
    if((f = fopen (curfname, "w")) == NULL) {
	perror(curfname);
	return;
    }

    fprintf (f, "%d %d %d %d %s %s %d %d\n",
	cbox[0].count, cbox[1].count, cbox[2].count, cbox[3].count,
	schemename[(int)colorscheme],
	spline ? "cubic" : "linear",
	XSCALE, YSCALE);

    for (which = 0; which < NBOX; which++) {
	register struct cval *c = &cbox[which].cval[0];
	for (i = cbox[which].count; --i >= 0; c++)
	    fprintf (f, "%d %d %d %d\n", c->x, c->y, c->pump, c->flags);
    }

    fclose (f);

    strcpy (curfname+len, ".table");
    if(dotable || access(curfname, 1) >= 0) {
	    struct tuple t;
	    /*
	     *	write out the table if asked or if .table file already exists
	     */
	    if((f = fopen (curfname, "w")) == NULL) {
		perror(curfname);
		return;
	    }
	    for (i = 0; i <= 2049; i++) {
		map_to_tuple(i * XSCALE / 2048, &t);
		fprintf (f, "%d %d %d %d\n",
			 t.v[0] * 2048 / YSCALE,
			 t.v[1] * 2048 / YSCALE,
			 t.v[2] * 2048 / YSCALE,
			 t.v[3] * 2048 / YSCALE);
	    }
	    fclose (f);
    }
}

void
file_load(namebuf)
	char namebuf[];
{
    int  which, box, i, n;
    int  len;
    FILE *f;
    Arg  arg;
    char buf[128];
    char hsv[20], spl[20];
    int  oldfmt, ishls;
    int  oxscale, oyscale;
    enum colorscheme cscheme;
    register struct cval *c;

    if(namebuf[0] != '\0')
	strcpy(curfname, namebuf);
    len = clean_name(curfname);
    if(len == 0) {
	panelMessage("Type file name here first");
	return;
    }
    strcpy(curfname+len, ".Cbx");

    if((f = fopen (curfname, "r")) == NULL) {
	panelMessage("%s: cannot open", buf);
	return;
    }

    
    hsv[0] = '\0';
    spl[0] = '\0';
    (void) fgets(buf, sizeof(buf), f);
    oxscale = XSCALE;
    oyscale = YSCALE;
    if(sscanf(buf, "%d %d %d %d %19s %19s %d %d",
		&cbox[0].count, &cbox[1].count, &cbox[2].count, &cbox[3].count,
		hsv, spl, &oxscale, &oyscale) < 4) {
	fclose(f);
	panelMessage("%s: not a .Cbx file\n", curfname);
	return;
    }
    oldfmt = (hsv[0] == '\0');

    for(i = 0; schemename[i] != NULL; i++)
	if(strcmp(hsv, schemename[i]) == 0)
		break;
    cscheme = (schemename[i] == NULL) ? RGB : (enum colorscheme) i;

    for (box = 0; box < NBOX; box++) {
	c = &cbox[box].cval[0];
	n = cbox[box].count;
	if(n > MAXVALS)
		cbox[box].count = n = MAXVALS;
	for(i = 0; i < n; i++, c++) {
	    int x, y, pump, flags;
	    if(oldfmt) {
		if(fscanf(f, "%d", &y) <= 0)
			goto fail;
		c->y = (128 - y) * YSCALE / 128;	
		c->x = i * XSCALE / n;
		c->pump = 0;
		c->flags = (i == 0 || i == n-1) ? LOCK_X : 0;
	    } else {
		if(fscanf(f, "%d %d %d %d", &x, &y, &pump, &flags) < 4)
			goto fail;
		c->x = x * XSCALE / oxscale;
		c->y = y * YSCALE / oyscale;
		c->pump = pump;
		c->flags = flags;
	    }
	    /* Clamp to prevent garbage */
	    if(i > 0 && c->x <= (c-1)->x)
		c->x = (c-1)->x + 1;
	    if(c->x < 0) c->x = 0;
	    else if(c->x >= XSCALE) c->x = XSCALE-1;
	    if(c->y < 0) c->y = 0;
	    else if(c->y >= YSCALE) c->y = YSCALE-1;
	    boxClear(box, 0, XSCALE-1);
	}
    }

    setSpline(NULL, (caddr_t)(strcmp(spl, "cubic") ? 0 : 1), NULL);
    setScheme(NULL, (caddr_t)cscheme, NULL);

    fclose (f);
    return;

  fail:
	panelMessage("%s: %s box %d point %d", curfname,
		feof(f) ? "premature EOF" : "format error",
		box, i);
	reset_boxes();
	fclose(f);
	return;
}
