#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xw/Xw.h>

#ifdef NOPIXAR

turnPixar(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
    if((int) client_data)
	fprintf(stderr, "No pixar here.\n");
}
#else

#include <pixar/pixar.h>

#include "cmap.h"

void luttopixar();

void
turnPixar(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
    pixar = (int) client_data;

    if(pixar)
	loadPixar();
}

void
loadPixar()
{
    unsigned char pal[257][3];
    int i;	

    for(i=0; i < 256; i++) {
	pal[i][0] = lut[i].red >> 8;
	pal[i][1] = lut[i].green >> 8;
	pal[i][2] = lut[i].blue >> 8;
    }

    luttopixar((unsigned char *)pal);
}

void
luttopixar(array)
unsigned char *array;
{

    int i,j;
    VIDEO *V;
    short red[1024], green[1024], blue[1024];
    double frj, fj;

    array[768] = array[765];
    array[769] = array[766];
    array[770] = array[767];
    V = VideoOpen("/dev/video0",1024,768,1);

    if (!V)
	return;

    for(i = 0; i < 256; i++) {
	red[2*i] =	16*array[3*i+0];
	red[2*i+1] =	8*(array[3*i+0] + array[3*i+3]);
	green[2*i] =	16*array[3*i+1];
	green[2*i+1] =	8*(array[3*i+1] + array[3*i+4]);
	blue[2*i] =	16*array[3*i+2];
	blue[2*i+1] =	8*(array[3*i+2] + array[3*i+5]);
    }
    for (i=512; i<768; ++i) {
	red[i] = 16*red[511];
	green[i] = 16*green[511];
	blue[i] = 16*blue[511];
    }
    for (i=768; i<1023; ++i) {
	red[i] = 16*red[0];
	green[i] = 16*green[0];
	blue[i] = 16*blue[0];
    }

    VideoSetColormap(V, red, green, blue);
    VideoClose(V);
}

#endif /*has PIXAR*/
