/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef GEOMDEF
#define GEOMDEF

/*
  This ugly hack is added since we want shared memory to be the default.
  */
#ifndef GEOM_NOSM
#ifndef	GEOM_SM
#define	GEOM_SM
#endif /* GEOM_SM */
#else
#ifdef	GEOM_SM
#undef	GEOM_SM
#endif	/* GEOM_SM */
#endif /* GEOM_NOSM */

#include <stdio.h>
#include "geometry/transform.h"			/* Transform type */
#include "geometry/point.h"
#include "geometry/point3.h"
#include "geometry/plane.h"
#include "geometry/line.h"
#include "oogl/context.h"

		/*
		 * Opaque forward typedefs.
		 * Defined in geomclass.h, not needed outside the library.
		 */
		
typedef struct Geom		Geom;		/* Complete OOGL object */
typedef struct GeomClass	GeomClass;	/* Virtual func tbl for Geom */
typedef struct GeomReference	GeomReference;	/* Opaque forward typedef */
typedef struct GeomPool		GeomPool;	/* Opaque forward typedef */
typedef struct GeomAttr		GeomAttr;	/* Generic attribute */

typedef char *GeomRef;

#ifdef GEOM_SM
#include "oogl/geom_sm.h"			/* Shared memory defs */
#endif

extern char    *GeomName( Geom *obj );
extern GeomClass *GeomMethods();
extern Geom    *GeomMessage( Geom *obj, int ac, char *av[] );
extern Geom    *GeomPrint( Geom *obj );
extern Geom    *GeomCopy( Geom *obj );
extern Geom    *GeomCreate();
extern Geom    *GeomDelete( Geom *obj );
extern Geom    *GeomLoad( char *name );
extern Geom    *GeomFLoad( Geom *obj, FILE *inf );	/* obj gives class */
extern Geom    *GeomFLoadRef( Geom *obj, GeomReference **refp, FILE *inf );
extern Geom    *GeomSave( Geom *obj, char *name );
extern Geom    *GeomFSave( Geom *obj, FILE *outf );
extern Geom    *GeomFSaveRef( Geom *obj, GeomReference *ref, FILE *inf );
extern Geom    *GeomReplace( Geom *parent, Geom *newchild );
extern Geom    *GeomEvert( Geom *obj );
extern Geom    *GeomBound( Geom *obj, Transform T );
extern Geom    *GeomEval();
extern Geom    *GeomDice();
extern Geom    *GeomSubdivide();
extern Geom    *GeomPosition( Geom *obj, Transform T );
extern Geom    *GeomTransform( Geom *obj, Transform T );
extern Geom    *GeomTransformTo( Geom *obj, Transform T );
extern Geom    *GeomTranslate( Geom *obj, float tx, float ty, float tz );
extern Geom    *GeomRotate( Geom *obj, float angle, Point *axis );
extern Geom    *GeomScale( Geom *obj, float sx, float sy, float sz );
extern Geom    *GeomPick( Geom *obj, Transform T, float x, float y, float *z );
extern Geom    *GeomPickGeom( Geom *obj, Transform T,float x,float y,float *z);
extern Geom    *GeomPickPoint( Geom *obj,Transform T,float x,float y,float *z,Point *pt);
extern Geom    *GeomPickPlane( Geom *obj,Transform T,float x,float y,float *z,Plane *pl);
extern Geom    *GeomPickLine( Geom *obj,Transform T,float x,float y,float *z,Line *ln);
extern Geom    *GeomFacing();
extern Geom    *GeomDraw( Geom *obj, ContextObject *object_context );
extern Geom    *GeomPoll( Geom *obj, GeomReference *ref, int *changed );

extern GeomReference *GeomMakeRef( GeomPool *pool, char *name );
extern  Geom   *GeomAttachTo( Geom *geom, GeomReference *ref );

#ifdef GEOM_SM
extern GeomSMSym *GeomShare( Geom *obj, GeomSMRegion *sm, char *symname );
extern GeomSMSym *GeomSShare( Geom *obj, GeomSMRegion *sm, GeomSMSym *sharesym );
extern Geom    *GeomPrivate( GeomSMRegion *sm,  char *symname );
extern Geom    *GeomSPrivate( GeomSMRegion *sm, GeomSMSym *sharesym );

extern SharedGeom    *GeomRawShare( Geom *obj, GeomSMRegion *sm, SharedGeom *sg );
extern Geom    *GeomRawPrivate( GeomSMRegion *sm, SharedGeom *sg );
#else
#define GeomCurSM NULL
#endif

struct Geom {			/* Should this be in geomclass.h instead? */
    GeomClass	*class;
    GeomRef	 object;
    GeomAttr	*attr;		/* misc attributes, incl origin and name */
    char	*owner;		/* Might indicate who allocated this geom */
};

#endif GEOMDEF
