/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bstdialogs.h"
#include	<stdarg.h>

/* --- defines --- */
#define	DFL_BORDER_WIDTH	(5)



/* --- functions --- */
GtkWidget*
bst_new_hseperator (GtkWidget   *parent)
{
  GtkWidget *child;

  child =
    gtk_widget_new (gtk_hseparator_get_type (),
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}

GtkWidget*
bst_new_vseperator (GtkWidget   *parent)
{
  GtkWidget *child;

  child =
    gtk_widget_new (gtk_vseparator_get_type (),
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}

GtkWidget*
bst_new_label (GtkWidget   *parent,
	       const gchar *label)
{
  GtkWidget *child;

  child =
    gtk_widget_new (gtk_label_get_type (),
		    "GtkLabel::label", label,
		    "GtkMisc::xalign", 0.0,
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}


GtkWidget*
bst_new_toggle (GtkWidget      *parent,
		const gchar    *label,
		gboolean        active)
{
  return bst_new_toggle_os (parent, label, active, NULL, NULL);
}

GtkWidget*
bst_new_toggle_os (GtkWidget      *parent,
		   const gchar    *label,
		   gboolean        active,
		   gpointer        clicked_cb,
		   gpointer        cb_data)
{
  GtkWidget *child;

  child =
    gtk_widget_new (gtk_check_button_get_type (),
		    "GtkButton::label", label,
		    "GtkWidget::visible", TRUE,
		    NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (child), active != FALSE);
  gtk_misc_set_alignment (GTK_MISC (GTK_BUTTON (child)->child), 0, 0.5);

  if (clicked_cb)
    gtk_signal_connect_object (GTK_OBJECT (child),
			       "clicked",
			       GTK_SIGNAL_FUNC (clicked_cb),
			       cb_data);

  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}

GtkWidget*
bst_new_entry (GtkWidget   *parent,
	       GtkWidget   *activate_window)
{
  GtkWidget *child;

  child =
    gtk_widget_new (gtk_entry_get_type (),
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  if (activate_window)
    gtk_widget_set (child,
		    "GtkObject::object_signal::activate", gtk_window_activate_default, activate_window,
		    NULL);

  return child;
}

GtkWidget*
bst_new_spinner (GtkWidget     *parent,
		 GtkAdjustment **adj,
		 gint          init_value,
		 gint          lower,
		 gint          upper,
		 gint          page_increment)
{
  return bst_new_spinner_os (parent, adj, init_value, lower, upper, page_increment, NULL, NULL);
}

GtkWidget*
bst_new_spinner_os (GtkWidget      *parent,
		    GtkAdjustment  **adj,
		    gint            init_value,
		    gint            lower,
		    gint            upper,
		    gint            page_increment,
		    gpointer        value_changed_cb,
		    gpointer        cb_data)
{
  GtkWidget *child;
  GtkObject *adjustment;

  adjustment =
    gtk_adjustment_new (init_value, lower, upper, 1, page_increment, 0);
  child =
    gtk_widget_new (gtk_spin_button_get_type (),
		    "GtkWidget::visible", TRUE,
		    NULL);
  gtk_spin_button_construct (GTK_SPIN_BUTTON (child),
			     GTK_ADJUSTMENT (adjustment),
			     0, 0);

  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  if (value_changed_cb)
    gtk_signal_connect_object (adjustment,
			       "value_changed",
			       GTK_SIGNAL_FUNC (value_changed_cb),
			       cb_data);

  if (adj)
    *adj = GTK_ADJUSTMENT (adjustment);

  return child;
}

static GtkWidget*
bst_new_box (GtkType	     box_type,
	     gboolean        homogenous,
	     guint           spacing,
	     guint           border_width,
	     guint           expand_index,
	     va_list	    *args)
{
  GtkWidget *box;
  GtkWidget *child;
  guint i;

  
  box =
    gtk_widget_new (box_type,
		    "GtkBox::homogeneous", homogenous != FALSE,
		    "GtkBox::spacing", spacing,
		    "GtkContainer::border_width", border_width,
		    "GtkWidget::visible", TRUE,
		    NULL);

  i = 0;
  child = va_arg (*args, GtkWidget*);
  while (child)
    {
      i++;
      gtk_box_pack_start (GTK_BOX (box), child, i == expand_index, TRUE, 0);
      child = va_arg (*args, GtkWidget*);
    }

  return box;
}

GtkWidget*
bst_new_hbox (GtkWidget      *parent,
	      gboolean        homogenous,
	      guint           spacing,
	      guint           border_width,
	      gboolean        self_expand,
	      guint           expand_index,
	      ...)
{
  GtkWidget *child;
  va_list    args;

  va_start (args, expand_index);
  child = bst_new_box (gtk_hbox_get_type (),
		       homogenous,
		       spacing,
		       border_width,
		       expand_index,
		       &args);
  va_end (args);

  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, self_expand != FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}

GtkWidget*
bst_new_vbox (GtkWidget      *parent,
	      gboolean        homogenous,
	      guint           spacing,
	      guint           border_width,
	      gboolean        self_expand,
	      guint           expand_index,
	      ...)
{
  GtkWidget *child;
  va_list    args;

  va_start (args, expand_index);
  child = bst_new_box (gtk_vbox_get_type (),
		       homogenous,
		       spacing,
		       border_width,
		       expand_index,
		       &args);
  va_end (args);

  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, self_expand != FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}

static GtkWidget*
bst_new_frame (GtkWidget      *parent,
	       GtkType	       box_type,
	       const gchar    *label,
	       gboolean	       self_expand,
	       guint           expand_index,
	       va_list	      *args)
{
  GtkWidget *frame;
  GtkWidget *box;
  
  frame =
    gtk_widget_new (gtk_frame_get_type (),
		    "GtkFrame::label", label,
		    "GtkFrame::label_xalign", 0.5,
		    "GtkWidget::visible", TRUE,
		    NULL);
  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), frame, self_expand != FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), frame);
    }
  
  box = bst_new_box (box_type, FALSE, 0, 0, expand_index, args);
  gtk_container_add (GTK_CONTAINER (frame), box);

  return frame;
}

GtkWidget*
bst_new_hframe (GtkWidget      *parent,
		const gchar    *label,
		gboolean        self_expand,
		guint           expand_index,
		...)
{
  GtkWidget *child;
  va_list    args;

  va_start (args, expand_index);
  child = bst_new_frame (parent,
			 gtk_hbox_get_type (),
			 label,
			 self_expand,
			 expand_index,
			 &args);
  va_end (args);

  return child;
}

GtkWidget*
bst_new_vframe (GtkWidget      *parent,
		const gchar    *label,
		gboolean        self_expand,
		guint           expand_index,
		...)
{
  GtkWidget *child;
  va_list    args;

  va_start (args, expand_index);
  child = bst_new_frame (parent,
			 gtk_vbox_get_type (),
			 label,
			 self_expand,
			 expand_index,
			 &args);
  va_end (args);

  return child;
}

static void
darea_realized (GtkWidget *darea)
{
  GdkEventMask event_mask;
  
  event_mask = gdk_window_get_events (darea->window);
  gdk_window_set_events (darea->window, event_mask | GDK_EXPOSURE_MASK);
}

GtkWidget*
bst_new_darea (GtkWidget    *parent,
	       gboolean      expand,
	       gint	     uwidth,
	       gint	     uheight,
	       gpointer      draw_data)
{
  return bst_new_darea_s (parent, expand, uwidth, uheight, draw_data, NULL, NULL);
}

GtkWidget*
bst_new_darea_s (GtkWidget    *parent,
		 gboolean      expand,
		 gint	       uwidth,
		 gint	       uheight,
		 gpointer      draw_data,
		 gpointer      expose_cb,
		 gpointer      cb_data)
{
  GtkWidget *child;
  
  child = gtk_drawing_area_new ();
  gtk_widget_set_usize (child, uwidth, uheight);
  
  GTK_DRAWING_AREA (child)->draw_data = draw_data;
  
  gtk_signal_connect_after (GTK_OBJECT (child),
			    "realize",
			    GTK_SIGNAL_FUNC (darea_realized),
			    NULL);
  
  if (expose_cb)
    gtk_signal_connect (GTK_OBJECT (child),
			"expose_event",
			GTK_SIGNAL_FUNC (expose_cb),
			cb_data);
  gtk_widget_show (child);

  if (parent)
    {
      if (GTK_IS_BOX (parent))
	gtk_box_pack_start (GTK_BOX (parent), child, expand != FALSE, TRUE, 0);
      else
	gtk_container_add (GTK_CONTAINER (parent), child);
    }

  return child;
}
