/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_MESSAGE_H__
#define __BST_MESSAGE_H__

#include        <bse/bse.h>
#include        <gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define BST_MESSAGE_BOX(object)		(GTK_CHECK_CAST (object, bst_message_box_get_type (), BstMessageBox))
#define BST_MESSAGE_BOX_CLASS(klass)	(GTK_CHECK_CLASS_CAST (klass, bst_message_box_get_type (), BstMessageBoxClass))
#define BST_IS_MESSAGE_BOX(object)	(GTK_CHECK_TYPE (object, bst_message_box_get_type ()))



typedef struct  _BstMessageBox		BstMessageBox;
typedef struct  _BstMessageBoxClass	BstMessageBoxClass;


struct  _BstMessageBox
{
  GtkWindow     window;

  GtkWidget	*text_label;
};

struct  _BstMessageBoxClass
{
  GtkWindowClass        parent_class;
};


GtkType         bst_message_box_get_type	(void);
GtkWidget*      bst_message_box_new		(const gchar	*message);
void		bst_message_box_set_text	(BstMessageBox	*mb,
						 const gchar	*message);
void		bst_message_box_set_textf	(BstMessageBox	*mb,
						 const gchar	*message_format,
						 ...) G_GNUC_PRINTF (2, 3);
GtkWidget*	bst_message_box_popup		(GtkObject      *alive_object,
						 const gchar    *message_format,
						 ...) G_GNUC_PRINTF (2, 3);



#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */
								   
#endif /* __BST_MESSAGE_H__ */
