
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsejanitor.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsejanitor.h>
#include <bse/bseserver.h>
#include <string.h>


#line 27 "bsejanitor.proc"


/* --- trigger-action --- */
static GType type_id_trigger_action = 0;
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsejanitor.proc"
 {
#line 31 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 30 "bsejanitor.proc"
  proc->help = "Trigger an installed user action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 36 "bsejanitor.proc"
 }
static BseErrorType
#line 36 "bsejanitor.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 39 "bsejanitor.proc"
{
#line 40 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 44 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 48 "bsejanitor.proc"
  
  bse_janitor_trigger_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- get-script-name --- */
static GType type_id_get_script_name = 0;
static void
get_script_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bsejanitor.proc"
 {
#line 56 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)    = sfi_pspec_string ("script_name", "Script Name", NULL,
			     NULL, SFI_PARAM_DEFAULT);
}
#line 55 "bsejanitor.proc"
  proc->help = "Retrieve the script name of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 61 "bsejanitor.proc"
 }
static BseErrorType
#line 61 "bsejanitor.proc"
get_script_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 64 "bsejanitor.proc"
{
#line 65 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 68 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 72 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, bse_janitor_get_script (self));
  
  return BSE_ERROR_NONE;
}

/* --- get-proc-name --- */
static GType type_id_get_proc_name = 0;
static void
get_proc_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 78 "bsejanitor.proc"
 {
#line 80 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)    = sfi_pspec_string ("proc_name", "Proc Name", NULL,
			     NULL, SFI_PARAM_DEFAULT);
}
#line 79 "bsejanitor.proc"
  proc->help = "Retrieve the procedure name of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 85 "bsejanitor.proc"
 }
static BseErrorType
#line 85 "bsejanitor.proc"
get_proc_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 88 "bsejanitor.proc"
{
#line 89 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 92 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 96 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->proc_name);
  
  return BSE_ERROR_NONE;
}

/* --- n-actions --- */
static GType type_id_n_actions = 0;
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsejanitor.proc"
 {
#line 104 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_actions", "N Actions", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 103 "bsejanitor.proc"
  proc->help = "Retrieve number of user actions of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 109 "bsejanitor.proc"
 }
static BseErrorType
#line 109 "bsejanitor.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 112 "bsejanitor.proc"
{
#line 113 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 116 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 120 "bsejanitor.proc"
  
  sfi_value_set_int (out_values++, g_slist_length (self->actions));
  
  return BSE_ERROR_NONE;
}

/* --- get-action --- */
static GType type_id_get_action = 0;
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bsejanitor.proc"
 {
#line 128 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 127 "bsejanitor.proc"
  proc->help = "Retrieve an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 135 "bsejanitor.proc"
 }
static BseErrorType
#line 135 "bsejanitor.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 138 "bsejanitor.proc"
{
#line 139 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 144 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 150 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-name --- */
static GType type_id_get_action_name = 0;
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bsejanitor.proc"
 {
#line 158 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action-name", "Action Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 157 "bsejanitor.proc"
  proc->help = "Retrieve the name of an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 165 "bsejanitor.proc"
 }
static BseErrorType
#line 165 "bsejanitor.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 168 "bsejanitor.proc"
{
#line 169 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 174 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 180 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->name : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-blurb --- */
static GType type_id_get_action_blurb = 0;
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 186 "bsejanitor.proc"
 {
#line 188 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action-blurb", "Action Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 187 "bsejanitor.proc"
  proc->help = "Retrieve the help string of an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 195 "bsejanitor.proc"
 }
static BseErrorType
#line 195 "bsejanitor.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 198 "bsejanitor.proc"
{
#line 199 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 204 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 210 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->blurb : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- kill --- */
static GType type_id_kill = 0;
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 216 "bsejanitor.proc"
 {
#line 218 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
}
#line 217 "bsejanitor.proc"
  proc->help = "Kill a currently running janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 221 "bsejanitor.proc"
 }
static BseErrorType
#line 221 "bsejanitor.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 224 "bsejanitor.proc"
{
#line 225 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 228 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 232 "bsejanitor.proc"
  
  if (!self->kill_pending)
    bse_janitor_queue_kill (self);
  
  return BSE_ERROR_NONE;
}

/* --- add-action --- */
static GType type_id_add_action = 0;
static void
add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 239 "bsejanitor.proc"
 {
#line 241 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("blurb", "Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 240 "bsejanitor.proc"
  proc->help = "Install a user action for script control.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 250 "bsejanitor.proc"
 }
static BseErrorType
#line 250 "bsejanitor.proc"
add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 253 "bsejanitor.proc"
{
#line 254 "bsejanitor.proc"
  
  BseJanitor       *self   = bse_value_get_object (in_values++);
  const gchar      *action = sfi_value_get_string (in_values++);
  const gchar      *name   = sfi_value_get_string (in_values++);
  const gchar      *blurb  = sfi_value_get_string (in_values++);
  
#line 260 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 264 "bsejanitor.proc"
  
  if (!self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 268 "bsejanitor.proc"
  
  bse_janitor_add_action (self, action, name, blurb);
  
  return BSE_ERROR_NONE;
}

/* --- remove-action --- */
static GType type_id_remove_action = 0;
static void
remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 274 "bsejanitor.proc"
 {
#line 276 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 275 "bsejanitor.proc"
  proc->help = "Remove a previously installed user action from script control.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 281 "bsejanitor.proc"
 }
static BseErrorType
#line 281 "bsejanitor.proc"
remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 284 "bsejanitor.proc"
{
#line 285 "bsejanitor.proc"
  
  BseJanitor  *self = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 289 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 293 "bsejanitor.proc"
  
  if (!self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 297 "bsejanitor.proc"
  
  bse_janitor_remove_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- bse-janitor-get-specific --- */
static GType type_id_bse_janitor_get_specific = 0;
static void
bse_janitor_get_specific_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 303 "bsejanitor.proc"
 {
#line 305 "bsejanitor.proc"
  *(out_pspecs++)   = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
}
#line 304 "bsejanitor.proc"
  proc->help = "Retrieve the connection dependant janitor object.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 308 "bsejanitor.proc"
 }
static BseErrorType
#line 308 "bsejanitor.proc"
bse_janitor_get_specific_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 311 "bsejanitor.proc"
{
  BseJanitor *self = bse_janitor_get_current ();
  
#line 314 "bsejanitor.proc"
  
  if (!self || !self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;

#line 318 "bsejanitor.proc"
  
  bse_value_set_object (out_values++, self);
  
  return BSE_ERROR_NONE;
}

/* --- set-msg --- */
static GType type_id_set_msg = 0;
static void
set_msg_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 324 "bsejanitor.proc"
 {
#line 326 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("msg_type", "Message Type", NULL,
				BSE_TYPE_USER_MSG_TYPE, BSE_USER_MSG_INFO,
				SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 325 "bsejanitor.proc"
  proc->help = "Alter script status message.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 333 "bsejanitor.proc"
}  }
static BseErrorType
#line 333 "bsejanitor.proc"
set_msg_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 336 "bsejanitor.proc"
{
#line 337 "bsejanitor.proc"
  
  BseJanitor    *self = bse_value_get_object (in_values++);
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 342 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 346 "bsejanitor.proc"
  
  if (!self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    {
      message = bse_janitor_get_ident (self);
      mtype = BSE_USER_MSG_INFO;
    }
  
#line 355 "bsejanitor.proc"
  
  bse_item_set (self,
		"user_msg_type", mtype,
		"user_msg", message,
		NULL);
  
  return BSE_ERROR_NONE;
}

/* --- progress --- */
static GType type_id_progress = 0;
static void
progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 364 "bsejanitor.proc"
 {
#line 366 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("progress", "Progress", NULL,
			  -1, -1, 1.0, 0.1,
			  SFI_PARAM_DEFAULT);
#line 365 "bsejanitor.proc"
  proc->help = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 371 "bsejanitor.proc"
}  }
static BseErrorType
#line 371 "bsejanitor.proc"
progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 374 "bsejanitor.proc"
{
#line 375 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  gfloat progress  = sfi_value_get_real (in_values++);
  
#line 379 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 383 "bsejanitor.proc"
  
  if (!self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 387 "bsejanitor.proc"
  
  bse_janitor_progress (self, progress);
  
  return BSE_ERROR_NONE;
}

/* --- exit --- */
static GType type_id_exit = 0;
static void
exit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 393 "bsejanitor.proc"
 {
#line 395 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("msg_type", "Message Type", NULL,
				BSE_TYPE_USER_MSG_TYPE, BSE_USER_MSG_INFO,
				SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 394 "bsejanitor.proc"
  proc->help = "Exit a script, leaving a message.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 402 "bsejanitor.proc"
}  }
static BseErrorType
#line 402 "bsejanitor.proc"
exit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 405 "bsejanitor.proc"
{
#line 406 "bsejanitor.proc"
  
  BseJanitor *self       = bse_value_get_object (in_values++);
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 411 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !message)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 415 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !self->port || self->kill_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 419 "bsejanitor.proc"
  
  bse_server_user_message (bse_server_get (), mtype, message);
  bse_janitor_queue_kill (self);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_trigger_action, "BseJanitor+trigger-action", NULL, 0, trigger_action_setup, trigger_action_exec, NULL, "/Method/BseJanitor/General/Trigger Action", { 0, }, },
  { &type_id_get_script_name, "BseJanitor+get-script-name", NULL, 0, get_script_name_setup, get_script_name_exec, NULL, "/Method/BseJanitor/General/Get Script Name", { 0, }, },
  { &type_id_get_proc_name, "BseJanitor+get-proc-name", NULL, 0, get_proc_name_setup, get_proc_name_exec, NULL, "/Method/BseJanitor/General/Get Proc Name", { 0, }, },
  { &type_id_n_actions, "BseJanitor+n-actions", NULL, 0, n_actions_setup, n_actions_exec, NULL, "/Method/BseJanitor/General/N Actions", { 0, }, },
  { &type_id_get_action, "BseJanitor+get-action", NULL, 0, get_action_setup, get_action_exec, NULL, "/Method/BseJanitor/General/Get Action", { 0, }, },
  { &type_id_get_action_name, "BseJanitor+get-action-name", NULL, 0, get_action_name_setup, get_action_name_exec, NULL, "/Method/BseJanitor/General/Get Action Name", { 0, }, },
  { &type_id_get_action_blurb, "BseJanitor+get-action-blurb", NULL, 0, get_action_blurb_setup, get_action_blurb_exec, NULL, "/Method/BseJanitor/General/Get Action Blurb", { 0, }, },
  { &type_id_kill, "BseJanitor+kill", NULL, 0, kill_setup, kill_exec, NULL, "/Method/BseJanitor/General/Kill", { 0, }, },
  { &type_id_add_action, "BseJanitor+add-action", NULL, 0, add_action_setup, add_action_exec, NULL, "/Method/BseJanitor/General/Add Action", { 0, }, },
  { &type_id_remove_action, "BseJanitor+remove-action", NULL, 0, remove_action_setup, remove_action_exec, NULL, "/Method/BseJanitor/General/Remove Action", { 0, }, },
  { &type_id_bse_janitor_get_specific, "bse-janitor-get-specific", NULL, 0, bse_janitor_get_specific_setup, bse_janitor_get_specific_exec, NULL, "/Proc/Script Utils/Specific Janitor", { 0, }, },
  { &type_id_set_msg, "BseJanitor+set-msg", NULL, 0, set_msg_setup, set_msg_exec, NULL, "/Method/BseJanitor/General/Set Msg", { 0, }, },
  { &type_id_progress, "BseJanitor+progress", NULL, 0, progress_setup, progress_exec, NULL, "/Method/BseJanitor/General/Progress", { 0, }, },
  { &type_id_exit, "BseJanitor+exit", NULL, 0, exit_setup, exit_exec, NULL, "/Method/BseJanitor/General/Exit", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
