
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsetrack.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsetrack.h>
#include <bse/bsepart.h>
#include <bse/bsesong.h>
#include <bse/bsebus.h>
#include <bse/bseundostack.h>


#line 29 "bsetrack.proc"


/* --- insert-part --- */
static void
insert_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bsetrack.proc"
 {
#line 33 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("id", "Link ID", NULL,
                         0, 0, SFI_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 42 "bsetrack.proc"
 }
static BseErrorType
#line 42 "bsetrack.proc"
insert_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 45 "bsetrack.proc"
{
#line 46 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BsePart  *part = bse_value_get_object (in_values++);
  guint id;

#line 52 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self) || !BSE_IS_PART (part) ||
      !BSE_ITEM (self)->parent ||
      BSE_ITEM (self)->parent != BSE_ITEM (part)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 58 "bsetrack.proc"
  
  id = bse_track_insert_part (self, tick, part);
  if (id)
    {
#line 62 "bsetrack.proc"
      
      bse_item_push_undo_proc (self, "remove-tick", tick);
    }

#line 66 "bsetrack.proc"
  
  g_value_set_int (out_values++, id);

  return BSE_ERROR_NONE;
}

/* --- remove-tick --- */
static void
remove_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 72 "bsetrack.proc"
 {
#line 74 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
}
#line 79 "bsetrack.proc"
 }
static BseErrorType
#line 79 "bsetrack.proc"
remove_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 82 "bsetrack.proc"
{
#line 83 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 88 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 92 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  if (entry)
    {
      bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
      bse_track_remove_tick (self, tick);
    }

  return BSE_ERROR_NONE;
}

/* --- remove-link --- */
static void
remove_link_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 103 "bsetrack.proc"
 {
#line 105 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("id", "Link ID", NULL,
			 0, 0, SFI_MAXINT, 384, SFI_PARAM_STANDARD);
}
#line 110 "bsetrack.proc"
 }
static BseErrorType
#line 110 "bsetrack.proc"
remove_link_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 113 "bsetrack.proc"
{
#line 114 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     id   = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 119 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  entry = bse_track_find_link (self, id);
  if (!entry)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 126 "bsetrack.proc"
  
  bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
  bse_track_remove_tick (self, entry->tick);
  
  return BSE_ERROR_NONE;
}

/* --- list-parts --- */
static void
list_parts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 133 "bsetrack.proc"
 {
#line 135 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("part_list", "Part List", NULL,
				BSE_TYPE_TRACK_PART_SEQ, SFI_PARAM_STANDARD);
}
#line 140 "bsetrack.proc"
 }
static BseErrorType
#line 140 "bsetrack.proc"
list_parts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 143 "bsetrack.proc"
{
#line 144 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 147 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 151 "bsetrack.proc"
  
  bse_value_take_boxed (out_values++, bse_track_list_parts (self));

  return BSE_ERROR_NONE;
}

/* --- list-parts-uniq --- */
static void
list_parts_uniq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 157 "bsetrack.proc"
 {
#line 159 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("part_list", "Part List", NULL,
				BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD); // FIXME: should use BsePartSeq here
}
#line 164 "bsetrack.proc"
 }
static BseErrorType
#line 164 "bsetrack.proc"
list_parts_uniq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 167 "bsetrack.proc"
{
#line 168 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 171 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 175 "bsetrack.proc"
  
  BseTrackPartSeq *tpseq = bse_track_list_parts (self);
  SfiRing *ring = NULL;
  guint i;
  for (i = 0; i < tpseq->n_tparts; i++)
    ring = sfi_ring_append (ring, tpseq->tparts[i]->part);
  bse_track_part_seq_free (tpseq);
  ring = sfi_ring_sort (ring, sfi_pointer_cmp, NULL);
  ring = sfi_ring_uniq (ring, sfi_pointer_cmp, NULL);
  bse_value_take_boxed (out_values++, bse_item_seq_from_ring (ring));
  sfi_ring_free (ring);

  return BSE_ERROR_NONE;
}

/* --- get-part --- */
static void
get_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 190 "bsetrack.proc"
 {
#line 192 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
}
#line 199 "bsetrack.proc"
 }
static BseErrorType
#line 199 "bsetrack.proc"
get_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 202 "bsetrack.proc"
{
#line 203 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;
  
#line 208 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 212 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  bse_value_set_object (out_values++, entry ? entry->part : NULL);

  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 219 "bsetrack.proc"
 {
#line 221 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 224 "bsetrack.proc"
}  }
static BseErrorType
#line 224 "bsetrack.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 227 "bsetrack.proc"
{
#line 228 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  SfiInt    tick = sfi_value_get_int (in_values++);
  BseItem  *parent;
  BseSongTiming timing = { 0, };

#line 234 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 238 "bsetrack.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 245 "bsetrack.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- get-output-source --- */
static void
get_output_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 251 "bsetrack.proc"
 {
#line 254 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", NULL, NULL,
                                 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("source", NULL, NULL,
                                 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
#line 258 "bsetrack.proc"
}  }
static BseErrorType
#line 258 "bsetrack.proc"
get_output_source_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 261 "bsetrack.proc"
{
#line 262 "bsetrack.proc"
  
  BseTrack *track = bse_value_get_object (in_values++);
  BseSource *child = NULL;

#line 266 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 270 "bsetrack.proc"
  
  child = bse_track_get_output (track);

#line 273 "bsetrack.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-last-tick --- */
static void
get_last_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 279 "bsetrack.proc"
 {
#line 281 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
                                 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("last_tick", "Last Tick", NULL,
                         0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
#line 285 "bsetrack.proc"
}  }
static BseErrorType
#line 285 "bsetrack.proc"
get_last_tick_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 288 "bsetrack.proc"
{
#line 289 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 292 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 296 "bsetrack.proc"
  
  sfi_value_set_int (out_values++, bse_track_get_last_tick (self));

  return BSE_ERROR_NONE;
}

/* --- ensure-output --- */
static void
ensure_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 302 "bsetrack.proc"
 {
#line 304 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
                                 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
#line 308 "bsetrack.proc"
}  }
static BseErrorType
#line 308 "bsetrack.proc"
ensure_output_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 311 "bsetrack.proc"
{
#line 312 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 316 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 320 "bsetrack.proc"
  
  BseItem *parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent) && !self->bus_outputs)
    {
      BseSong *song = BSE_SONG (parent);
      BseBus *master = bse_song_find_master (song);
      if (master)
        {
          error = bse_bus_connect (master, BSE_ITEM (self));
          if (!error)
            bse_item_push_undo_proc (master, "disconnect-track", self);
        }
    }

#line 334 "bsetrack.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_insert_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a part into a track and retrieve the corresponding link id.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_insert_part = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseTrack+insert-part", 
    NULL,
    "/Methods/BseTrack/General/Insert Part",
    NULL,
    __enode_insert_part__fill_strings,
  },
  0, insert_part_setup, insert_part_exec, 
};
static void
__enode_remove_tick__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a part at specified tick from a track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_remove_tick = {
  { (BseExportNode*) &__enode_insert_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-tick", 
    NULL,
    "/Methods/BseTrack/General/Remove Tick",
    NULL,
    __enode_remove_tick__fill_strings,
  },
  0, remove_tick_setup, remove_tick_exec, 
};
static void
__enode_remove_link__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a specific part link by ID from a track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_remove_link = {
  { (BseExportNode*) &__enode_remove_tick, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-link", 
    NULL,
    "/Methods/BseTrack/General/Remove Link",
    NULL,
    __enode_remove_link__fill_strings,
  },
  0, remove_link_setup, remove_link_exec, 
};
static void
__enode_list_parts__fill_strings (BseExportStrings *es)
{
  es->blurb = "List parts scheduled in a track, sorted by tick.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_list_parts = {
  { (BseExportNode*) &__enode_remove_link, BSE_EXPORT_NODE_PROC,
    "BseTrack+list-parts", 
    NULL,
    "/Methods/BseTrack/General/List Parts",
    NULL,
    __enode_list_parts__fill_strings,
  },
  0, list_parts_setup, list_parts_exec, 
};
static void
__enode_list_parts_uniq__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all parts contained in a track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_list_parts_uniq = {
  { (BseExportNode*) &__enode_list_parts, BSE_EXPORT_NODE_PROC,
    "BseTrack+list-parts-uniq", 
    NULL,
    "/Methods/BseTrack/General/List Parts Uniq",
    NULL,
    __enode_list_parts_uniq__fill_strings,
  },
  0, list_parts_uniq_setup, list_parts_uniq_exec, 
};
static void
__enode_get_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the part starting at a specific tick position.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_part = {
  { (BseExportNode*) &__enode_list_parts_uniq, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-part", 
    NULL,
    "/Methods/BseTrack/General/Get Part",
    NULL,
    __enode_get_part__fill_strings,
  },
  0, get_part_setup, get_part_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve song timing information at a specific tick.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_get_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-timing", 
    NULL,
    "/Methods/BseTrack/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
static void
__enode_get_output_source__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Get the output module for this track. The output of this module is the merged result from "
            "all polyphonic voices and has all track specific alterations applied.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_output_source = {
  { (BseExportNode*) &__enode_get_timing, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-output-source", 
    NULL,
    "/Methods/BseTrack/General/Get Output Source",
    NULL,
    __enode_get_output_source__fill_strings,
  },
  0, get_output_source_setup, get_output_source_exec, 
};
static void
__enode_get_last_tick__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the last tick for this track.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_get_last_tick = {
  { (BseExportNode*) &__enode_get_output_source, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-last-tick", 
    NULL,
    "/Methods/BseTrack/General/Get Last Tick",
    NULL,
    __enode_get_last_tick__fill_strings,
  },
  0, get_last_tick_setup, get_last_tick_exec, 
};
static void
__enode_ensure_output__fill_strings (BseExportStrings *es)
{
  es->blurb = "Ensure the track has an output connection to a bus.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2003 Tim Janik";
}
static BseExportNodeProc __enode_ensure_output = {
  { (BseExportNode*) &__enode_get_last_tick, BSE_EXPORT_NODE_PROC,
    "BseTrack+ensure-output", 
    NULL,
    "/Methods/BseTrack/General/Ensure Output",
    NULL,
    __enode_ensure_output__fill_strings,
  },
  0, ensure_output_setup, ensure_output_exec, 
};
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_ensure_output;
}

/*
 * Generated data ends here
 */
