
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseprocedure.proc"

#include "bseplugin.h"
#include "bseprocedure.h"
#include "bsescripthelper.h"
#include "bseserver.h"
#line 22 "bseprocedure.proc"
#include "bsemath.h"    
#include "bsemain.h"
#line 24 "bseprocedure.proc"
#include <string.h>     
#line 25 "bseprocedure.proc"
#include <stdlib.h>     


#line 30 "bseprocedure.proc"

/* --- bse-note-to-freq --- */
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bseprocedure.proc"
 {
#line 33 "bseprocedure.proc"
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
#line 38 "bseprocedure.proc"
}  }
static BseErrorType
#line 38 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 41 "bseprocedure.proc"
{
#line 42 "bseprocedure.proc"
  
  gint       note       = sfi_value_get_int (in_values++);
  gint       fine_tune  = sfi_value_get_int (in_values++);
  BseNoteDescription *info;
  gfloat freq;
  
#line 48 "bseprocedure.proc"
  
  info = bse_note_description (note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bse_note_description_free (info);
  
#line 56 "bseprocedure.proc"
  
  sfi_value_set_real (out_values++, freq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-freq --- */
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 62 "bseprocedure.proc"
 {
#line 64 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY, 0, BSE_MAX_FREQUENCY, 0.1,
			  SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_note ("note", "Note", NULL, SFI_KAMMER_NOTE, SFI_MIN_NOTE, SFI_MAX_NOTE, TRUE, SFI_PARAM_STANDARD);
#line 68 "bseprocedure.proc"
}  }
static BseErrorType
#line 68 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 71 "bseprocedure.proc"
{
#line 72 "bseprocedure.proc"
  
  gfloat frequency = sfi_value_get_real (in_values++);
  
#line 75 "bseprocedure.proc"
  
  sfi_value_set_int (out_values++, bse_note_from_freq (frequency));
  
  return BSE_ERROR_NONE;
}

/* --- bse-type-options --- */
static void
bse_type_options_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 81 "bseprocedure.proc"
 {
#line 83 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 85 "bseprocedure.proc"
}  }
static BseErrorType
#line 85 "bseprocedure.proc"
bse_type_options_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 88 "bseprocedure.proc"
{
#line 89 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 93 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 99 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_options (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-blurb --- */
static void
bse_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 105 "bseprocedure.proc"
 {
#line 107 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 109 "bseprocedure.proc"
}  }
static BseErrorType
#line 109 "bseprocedure.proc"
bse_type_blurb_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 112 "bseprocedure.proc"
{
#line 113 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 117 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 123 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_blurb (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-authors --- */
static void
bse_type_authors_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 129 "bseprocedure.proc"
 {
#line 131 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 133 "bseprocedure.proc"
}  }
static BseErrorType
#line 133 "bseprocedure.proc"
bse_type_authors_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 136 "bseprocedure.proc"
{
#line 137 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 141 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 147 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_authors (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- bse-type-license --- */
static void
bse_type_license_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 153 "bseprocedure.proc"
 {
#line 155 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 157 "bseprocedure.proc"
}  }
static BseErrorType
#line 157 "bseprocedure.proc"
bse_type_license_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 160 "bseprocedure.proc"
{
#line 161 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 165 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 171 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_get_license (type) : NULL);

  return BSE_ERROR_NONE;
}

static gdouble
str2num (const gchar *str,
         guint        nth)
{
  gchar *num_any = ".0123456789", *num_first = num_any + 1;
  while (nth--)
    {
#line 184 "bseprocedure.proc"
      
      if (*str && strchr (num_first, *str))
        do
          str++;
        while (*str && strchr (num_any, *str));
#line 189 "bseprocedure.proc"
      
      while (*str && !strchr (num_first, *str))
        str++;
      if (!*str)
#line 193 "bseprocedure.proc"
        return 0;       
    }
  if (strchr (num_first, *str))
    return g_strtod (str, NULL);
#line 197 "bseprocedure.proc"
  return 0; 
}

/* --- bse-string-extract-number --- */
static void
bse_string_extract_number_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 200 "bseprocedure.proc"
 {
#line 202 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("format", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("aux_base", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("dflt", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_real ("number", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_STANDARD);
#line 207 "bseprocedure.proc"
}  }
static BseErrorType
#line 207 "bseprocedure.proc"
bse_string_extract_number_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 210 "bseprocedure.proc"
{
#line 211 "bseprocedure.proc"
  
  gchar *string   = sfi_value_get_string (in_values++);
  gchar *format   = sfi_value_get_string (in_values++);
  SfiReal aux_base = sfi_value_get_real (in_values++);
  SfiReal dflt     = sfi_value_get_real (in_values++);
  SfiReal number = dflt;

  if (string)
    {
      if (format)
        {
          gchar *base, *ep = NULL;
          switch (*format)
            {
              glong l;
            case '#':
              number = str2num (++format, 0);
              break;
            case 'n':
              l = strtol (++format, &ep, 10);
              number = str2num (string, l);
              break;
            case 'b':
              l = strtol (++format, &ep, 10);
              base = g_path_get_basename (string);
              number = str2num  (base ? base : string, l);
              g_free (base);
              break;
            case 'c':
              format++;
              number = aux_base;
              if (*format == '*')
                {
                  gdouble factor = g_strtod (++format, &ep);
                  number *= factor;
                }
              else
                ep = (char*) format;
              break;
            default:
#line 251 "bseprocedure.proc"
              
              number = 0;
              break;
            }
          if (ep && *ep)
            {
#line 257 "bseprocedure.proc"
              if (*ep == 'm')       
                number = bse_temp_freq (BSE_CONFIG (kammer_freq),
                                        number - BSE_CONFIG (midi_kammer_note));
#line 260 "bseprocedure.proc"
              else 
                number = 0;
            }
        }
      else
        number = str2num (string, 0);
    }
  sfi_value_set_real (out_values++, number);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_bse_note_to_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the frequency of a certain note.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 32;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_note_to_freq = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-note-to-freq", 
    NULL,
    "/Proc/Note to Freq",
    NULL,
    __enode_bse_note_to_freq__fill_strings,
  },
  0, bse_note_to_freq_setup, bse_note_to_freq_exec, 
};
static void
__enode_bse_note_from_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the note of a certain frequency.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 63;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_note_from_freq = {
  { (BseExportNode*) &__enode_bse_note_to_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-freq", 
    NULL,
    "/Proc/Note from Freq",
    NULL,
    __enode_bse_note_from_freq__fill_strings,
  },
  0, bse_note_from_freq_setup, bse_note_from_freq_exec, 
};
static void
__enode_bse_type_options__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the options of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 82;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_type_options = {
  { (BseExportNode*) &__enode_bse_note_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-type-options", 
    NULL,
    "/Proc/Type Options",
    NULL,
    __enode_bse_type_options__fill_strings,
  },
  0, bse_type_options_setup, bse_type_options_exec, 
};
static void
__enode_bse_type_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the description of a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 106;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_type_blurb = {
  { (BseExportNode*) &__enode_bse_type_options, BSE_EXPORT_NODE_PROC,
    "bse-type-blurb", 
    NULL,
    "/Proc/Type Blurb",
    NULL,
    __enode_bse_type_blurb__fill_strings,
  },
  0, bse_type_blurb_setup, bse_type_blurb_exec, 
};
static void
__enode_bse_type_authors__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the authors who implemented a specific type.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 130;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_type_authors = {
  { (BseExportNode*) &__enode_bse_type_blurb, BSE_EXPORT_NODE_PROC,
    "bse-type-authors", 
    NULL,
    "/Proc/Type Authors",
    NULL,
    __enode_bse_type_authors__fill_strings,
  },
  0, bse_type_authors_setup, bse_type_authors_exec, 
};
static void
__enode_bse_type_license__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the license of a type impementation.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 154;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_type_license = {
  { (BseExportNode*) &__enode_bse_type_authors, BSE_EXPORT_NODE_PROC,
    "bse-type-license", 
    NULL,
    "/Proc/Type License",
    NULL,
    __enode_bse_type_license__fill_strings,
  },
  0, bse_type_license_setup, bse_type_license_exec, 
};
static void
__enode_bse_string_extract_number__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve numbers from a string.";
  es->file = "/opt/src/beast/bse/bseprocedure.proc";
  es->line = 201;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_bse_string_extract_number = {
  { (BseExportNode*) &__enode_bse_type_license, BSE_EXPORT_NODE_PROC,
    "bse-string-extract-number", 
    NULL,
    "/Proc/String Extract Number",
    NULL,
    __enode_bse_string_extract_number__fill_strings,
  },
  0, bse_string_extract_number_setup, bse_string_extract_number_exec, 
};
BseExportNode* bse__builtin_init_bseprocedure_genprc_c (void);
BseExportNode* bse__builtin_init_bseprocedure_genprc_c (void)
{
  return (BseExportNode*) &__enode_bse_string_extract_number;
}

/*
 * Generated data ends here
 */
