#include "cslarts.h"
#include "soundserver.h"
#include "debug.h"
#include <stdio.h>

using namespace Arts;

int main()
{
	Dispatcher dispatcher;
	SoundServer server = Reference("global:Arts_SoundServer");
	arts_return_val_if_fail(!server.isNull(),1);

	Object obj = server.createObject("CSL::Adapter");
	arts_return_val_if_fail(!obj.isNull(),1);

	CSL::Adapter adapter = DynamicCast(obj);
	arts_return_val_if_fail(!adapter.isNull(),1);

	long id = adapter.open("cslreccxx", CSL::dirInput);
	arts_return_val_if_fail(id > 0,1);

	CSL::StreamParams params(44100, 2, CSL::sf_s16_le);
	bool paramsOk = adapter.setParams(id, params);
	arts_return_val_if_fail(paramsOk,1);

	adapter.activate(id);

	for(;;)
	{
		adapter.waitBufferLevel(id, 4096);
		vector<mcopbyte> *data = adapter.read(id, 4096);
		arts_assert(data->size() == 4096);
		fwrite(&(*data)[0], 1, data->size(), stdout);
		delete data;
	}

/*	not reached ;) */
	adapter.suspend(id);
	adapter.close(id);
	return 0;
}

// vim:ts=4:sts=4:sw=4
