/* This file is part of GEGL
 *
 * GEGL is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * GEGL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GEGL; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Copyright 2006 Dominik Ernst
 *
 * Reflect an image about a line, whose direction is specified by the 
 * vector that is defined by the x and y properties.
 */

#if GEGL_CHANT_PROPERTIES

gegl_chant_double (x, -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, 
  "Direction vector's x component")
gegl_chant_double (y, -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, 
  "Direction vector's y component")

#else

#define GEGL_CHANT_NAME reflect
#define GEGL_CHANT_SELF "reflect.c"
#include "chant.h"

#include <math.h>

static void
create_matrix (GeglChantOperation *op,
               Matrix3        matrix)
{
  gdouble ux=0, uy=0;
  gdouble l;

  ux = op->x;
  uy = op->y;

  l = sqrt(uy*uy + ux*ux);
  ux /= l;
  uy /= l;

  matrix [0][0] = 2*ux*ux - 1;
  matrix [1][1] = 2*uy*uy - 1;
  matrix [0][1] = matrix [1][0] = 2*ux*uy;
}


#endif
