
/* !!!! AUTOGENERATED FILE generated by porter-duff.rb !!!!! 
 *
 *  Copyright 2006 Øyvind Kolås <pippin@gimp.org>
 *
 * !!!! AUTOGENERATED FILE !!!!!
 *
 */
#if GEGL_CHANT_PROPERTIES
/* no properties */
#else

#define GEGL_CHANT_POINT_COMPOSER
#define GEGL_CHANT_NAME          in
#define GEGL_CHANT_DESCRIPTION   "Porter Duff operation in (c = cA * aB)"
#define GEGL_CHANT_CATEGORIES    "compositors:porter duff"
#define GEGL_CHANT_SELF          "in.c"
#define GEGL_CHANT_INIT
#define GEGL_CHANT_CLASS_INIT
#include "gegl-chant.h"

static void init (GeglChantOperation *self)
{
  GEGL_OPERATION_POINT_COMPOSER (self)->format = babl_format ("RaGaBaA float");
  GEGL_OPERATION_POINT_COMPOSER (self)->aux_format = babl_format ("RaGaBaA float");

}

static gboolean
process (GeglOperation *op,
          void          *in_buf,
          void          *aux_buf,
          void          *out_buf,
          glong          n_pixels)
{
  gint i;
  gfloat *in = in_buf;
  gfloat *aux = aux_buf;
  gfloat *out = out_buf;

  if (aux==NULL)
    return TRUE;

  for (i=0; i<n_pixels; i++)
    {
      int  j;
      gfloat aA, aB;

      aB=in[3];
      aA=aux[3];
      for (j=0; j<4; j++)
          {
              gfloat cA, cB;

              cB=in[j];
              cA=aux[j];
              out[j] = cA * aB;
          }
      in  += 4;
      aux += 4;
      out += 4;
    }
  return TRUE;
}

static GeglRectangle
get_defined_region (GeglOperation *self)
{
  GeglRectangle result = {0,0,0,0};
  GeglRectangle *in_rect  = gegl_operation_source_get_defined_region (self, "input");
  if (!in_rect)
    return result;
  return *in_rect;
}

static GeglRectangle
get_affected_region (GeglOperation *self,
                     const gchar   *pad_name,
                     GeglRectangle       region)
{
  GeglRectangle empty = {0,0,0,0};
  if (!strcmp (pad_name, "input"))
    return region;
  return empty;
}

static void class_init (GeglOperationClass *operation_class)
{
  operation_class->get_defined_region = get_defined_region;
  operation_class->get_affected_region = get_affected_region;
}

#endif
