static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2008 Bradley Broom <bmbroom@gmail.com>                           \n"
" * Copyright 2011 Robert Sasu <sasu.robert@gmail.com>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <lensfun.h>                                                          \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (maker, _(\"Maker\"),\"none\")                                \n"
"    description (_(\"Write lens maker correctly\"))                           \n"
"                                                                              \n"
"property_string (Camera, _(\"Camera\"),\"none\")                              \n"
"    description (_(\"Write camera name correctly\"))                          \n"
"                                                                              \n"
"property_string (Lens, _(\"Lens\"),\"none\")                                  \n"
"    description(_(\"Write your lens model with uppercase letters\"))          \n"
"                                                                              \n"
"property_double (focal, _(\"Focal of the camera\"), 20.0)                     \n"
"    description (_(\"Calculate b value from focal\"))                         \n"
"    value_range (0.0, 300.0)                                                  \n"
"                                                                              \n"
"property_boolean (center, _(\"Center\"), TRUE)                                \n"
"    description (_(\"If you want center\"))                                   \n"
"                                                                              \n"
"property_int (cx, _(\"Lens center X\"), 0)                                    \n"
"    description (_(\"Coordinates of lens center\"))                           \n"
"                                                                              \n"
"property_int (cy, _(\"Lens center Y\"), 0)                                    \n"
"    description (_(\"Coordinates of lens center\"))                           \n"
"                                                                              \n"
"property_double (rscale, _(\"Scale\"), 0.5)                                   \n"
"    description (_(\"Scale of the image\"))                                   \n"
"    value_range (0.001, 10.0)                                                 \n"
"                                                                              \n"
"property_boolean (correct, _(\"Autocorrect d values\"), TRUE)                 \n"
"    description (_(\"Autocorrect D values for lens correction models.\"))     \n"
"                                                                              \n"
"property_double (red_a, _(\"Model red a\"), 0.0)                              \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (red_b, _(\"Model red b\"), 0.0)                              \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (red_c, _(\"Model red c\"), 0.0)                              \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (red_d, _(\"Model red d\"), 1.0)                              \n"
"   value_range (0.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (green_a, _(\"Model green a\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (green_b, _(\"Model green b\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (green_c, _(\"Model green c\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (green_d, _(\"Model green d\"), 1.0)                          \n"
"   value_range (0.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (blue_a, _(\"Model blue a\"), 0.0)                            \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (blue_b, _(\"Model blue b\"), 0.0)                            \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (blue_c, _(\"Model blue c\"), 0.0)                            \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (blue_d, _(\"Model blue d\"), 1.0)                            \n"
"   value_range (0.0, 2.0)                                                     \n"
"                                                                              \n"
"                                                                              \n"
"property_double (alpha_a, _(\"Model alpha a\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (alpha_b, _(\"Model alpha b\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (alpha_c, _(\"Model alpha c\"), 0.0)                          \n"
"   value_range (-1.0, 1.0)                                                    \n"
"property_double (alpha_d, _(\"Model alpha d\"), 1.0)                          \n"
"   value_range (0.0, 2.0)                                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     lens_correct                                         \n"
"#define GEGL_OP_C_SOURCE lens-correct.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"/* Struct containing the correction parameters a,b,c,d for a lens color       \n"
" * channel.  These parameters as the same as used in the Panotools            \n"
" * system.  For a detailed explanation, please consult                        \n"
" * http://wiki.panotools.org/Lens_correction_model                            \n"
" *                                                                            \n"
" * Normally a, b, and c are close to zero, and d is close to one.  Note       \n"
" * that d is the parameter that's approximately equal to 1 - a - b - c,       \n"
" * NOT one of the image shift parameters as used in some GUIs.                \n"
" */                                                                           \n"
"typedef struct {                                                              \n"
"  gfloat a, b, c, d;                                                          \n"
"} ChannelCorrectionModel;                                                     \n"
"                                                                              \n"
"/* Struct containing all the information required for lens correction.        \n"
" * It includes the total size of the image plus the correction                \n"
" * parameters for each color channel.                                         \n"
" */                                                                           \n"
"typedef struct {                                                              \n"
"  GeglRectangle BB;                               /* Bounding box of the imaged area. */\n"
"  gfloat cx, cy;                                  /* Coordinates of lens center within the imaged area.  */\n"
"  gfloat rscale;                                  /* Scale of the image (1/2 of the shortest side). */\n"
"  ChannelCorrectionModel red, green, blue, alpha; /* Correction parameters for each color channel. */\n"
"} LensCorrectionModel;                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"make_lens (LensCorrectionModel *lens,                                         \n"
"           GeglProperties          *o,                                        \n"
"           GeglRectangle        boundary)                                     \n"
"{                                                                             \n"
"  lens->BB.x = boundary.x;                                                    \n"
"  lens->BB.y = boundary.y;                                                    \n"
"  lens->BB.width = boundary.width;                                            \n"
"  lens->BB.height = boundary.height;                                          \n"
"                                                                              \n"
"  if (o->center)                                                              \n"
"    {                                                                         \n"
"      o->cx = (boundary.x + boundary.width) / 2;                              \n"
"      o->cy = (boundary.y + boundary.height) / 2;                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  lens->cx = o->cx;                                                           \n"
"  lens->cy = o->cy;                                                           \n"
"                                                                              \n"
"  lens->rscale = o->rscale;                                                   \n"
"                                                                              \n"
"  lens->red.a = o->red_a;                                                     \n"
"  lens->red.b = o->red_b;                                                     \n"
"  lens->red.c = o->red_c;                                                     \n"
"                                                                              \n"
"  if (o->correct)                                                             \n"
"    lens->red.d = 1 - o->red_a - o->red_b - o->red_c;                         \n"
"  else                                                                        \n"
"    lens->red.d = o->red_d;                                                   \n"
"                                                                              \n"
"  lens->green.a = o->green_a;                                                 \n"
"  lens->green.b = o->green_b;                                                 \n"
"  lens->green.c = o->green_c;                                                 \n"
"                                                                              \n"
"  if (o->correct)                                                             \n"
"    lens->green.d = 1 - o->green_a - o->green_b - o->green_c;                 \n"
"  else                                                                        \n"
"    lens->green.d = o->green_d;                                               \n"
"                                                                              \n"
"  lens->blue.a = o->blue_a;                                                   \n"
"  lens->blue.b = o->blue_b;                                                   \n"
"  lens->blue.c = o->blue_c;                                                   \n"
"                                                                              \n"
"  if (o->correct)                                                             \n"
"    lens->blue.d = 1 - o->blue_a - o->blue_b - o->blue_c;                     \n"
"  else                                                                        \n"
"    lens->blue.d = o->blue_d;                                                 \n"
"                                                                              \n"
"  lens->alpha.a = o->alpha_a;                                                 \n"
"  lens->alpha.b = o->alpha_b;                                                 \n"
"  lens->alpha.c = o->alpha_c;                                                 \n"
"                                                                              \n"
"  if (o->correct)                                                             \n"
"    lens->alpha.d = 1 - o->alpha_a - o->alpha_b - o->alpha_c;                 \n"
"  else                                                                        \n"
"    lens->alpha.d = o->red_d;                                                 \n"
"                                                                              \n"
"  if (o->focal!=0.0)                                                          \n"
"    {                                                                         \n"
"      gdouble f = o->focal;                                                   \n"
"      lens->red.b = lens->green.b = lens->blue.b = lens->alpha.b              \n"
"        = 0.000005142 * f*f*f - 0.000380839 * f*f + 0.009606325 * f - 0.075316854;\n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"find_make_lens(LensCorrectionModel *lens,                                     \n"
"               GeglProperties          *o,                                    \n"
"               GeglRectangle        boundary)                                 \n"
"{                                                                             \n"
"  struct lfDatabase *ldb;                                                     \n"
"  const lfCamera **cameras;                                                   \n"
"  const lfLens   **lenses;                                                    \n"
"  const lfCamera  *camera;                                                    \n"
"  const lfLens    *onelen;                                                    \n"
"                                                                              \n"
"  struct lfLensCalibDistortion **dist;                                        \n"
"                                                                              \n"
"  gint             i, j=0;                                                    \n"
"  gfloat           aux = G_MAXINT;                                            \n"
"                                                                              \n"
"  lens->BB.x = boundary.x;                                                    \n"
"  lens->BB.y = boundary.y;                                                    \n"
"  lens->BB.width = boundary.width;                                            \n"
"  lens->BB.height = boundary.height;                                          \n"
"                                                                              \n"
"  if (o->center)                                                              \n"
"    {                                                                         \n"
"      o->cx = (boundary.x + boundary.width) / 2;                              \n"
"      o->cy = (boundary.y + boundary.height) / 2;                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  lens->cx = o->cx;                                                           \n"
"  lens->cy = o->cy;                                                           \n"
"                                                                              \n"
"  lens->rscale = o->rscale;                                                   \n"
"                                                                              \n"
"  ldb = lf_db_new ();                                                         \n"
"  if (!ldb)                                                                   \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  lf_db_load (ldb);                                                           \n"
"                                                                              \n"
"  cameras =  lf_db_find_cameras (ldb, o->maker, o->Camera);                   \n"
"  if (!cameras)                                                               \n"
"    return FALSE;                                                             \n"
"  camera = cameras[0];                                                        \n"
"                                                                              \n"
"  lf_free (cameras);                                                          \n"
"                                                                              \n"
"  lenses = lf_db_find_lenses_hd (ldb, camera, o->maker, o->Lens, 0);          \n"
"  if (!lenses)                                                                \n"
"    return FALSE;                                                             \n"
"  onelen = lenses[0];                                                         \n"
"                                                                              \n"
"  dist = onelen->CalibDistortion;                                             \n"
"                                                                              \n"
"  for (i=0; lenses[i]; i++)                                                   \n"
"    if (lenses[i]->MinFocal < o->focal && o->focal < lenses[i]->MaxFocal)     \n"
"      break;                                                                  \n"
"                                                                              \n"
"  dist = lenses[i]->CalibDistortion;                                          \n"
"                                                                              \n"
"  if (!dist)                                                                  \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  for (i=0; dist[i]; i++)                                                     \n"
"    {                                                                         \n"
"      if (dist[i]->Focal == o->focal)                                         \n"
"        {                                                                     \n"
"          lens->red.a = lens->green.a = lens->blue.a = lens->alpha.a          \n"
"            = dist[i]->Terms[0];                                              \n"
"          lens->red.b = lens->green.b = lens->blue.b = lens->alpha.b          \n"
"            = dist[i]->Terms[1];                                              \n"
"          lens->red.c = lens->green.c = lens->blue.c = lens->alpha.c          \n"
"            = dist[i]->Terms[2];                                              \n"
"                                                                              \n"
"          lens->red.d = 1 - lens->red.a - lens->red.b - lens->red.c;          \n"
"          lens->green.d = 1 - lens->green.a - lens->green.b - lens->green.c;  \n"
"          lens->blue.d = 1 - lens->blue.a - lens->blue.b - lens->blue.c;      \n"
"          lens->alpha.d = 1 - lens->alpha.a - lens->alpha.b - lens->alpha.c;  \n"
"                                                                              \n"
"          aux = -G_MAXINT;                                                    \n"
"          break;                                                              \n"
"        }                                                                     \n"
"      else if (i > 0)                                                         \n"
"        {                                                                     \n"
"          if (aux > fabs (dist[i]->Focal - o->focal                           \n"
"                          + dist[i-1]->Focal - o->focal))                     \n"
"            {                                                                 \n"
"              aux = fabs (dist[i]->Focal + dist[i-1]->Focal - 2 * o->focal);  \n"
"              j = i;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  lf_free (lenses);                                                           \n"
"                                                                              \n"
"  if (aux != -G_MAXINT)                                                       \n"
"    {                                                                         \n"
"      gfloat aux[3];                                                          \n"
"      for (i=0; i<3; i++)                                                     \n"
"        aux[i] = (dist[j]->Terms[i] - dist[j-1]->Terms[i]) / 2.0;             \n"
"                                                                              \n"
"      lens->red.a = lens->green.a = lens->blue.a = lens->alpha.a              \n"
"        = aux[0];                                                             \n"
"      lens->red.b = lens->green.b = lens->blue.b = lens->alpha.b              \n"
"        = aux[1];                                                             \n"
"      lens->red.c = lens->green.c = lens->blue.c = lens->alpha.c              \n"
"        = aux[2];                                                             \n"
"                                                                              \n"
"      lens->red.d = 1 - lens->red.a - lens->red.b - lens->red.c;              \n"
"      lens->green.d = 1 - lens->green.a - lens->green.b - lens->green.c;      \n"
"      lens->blue.d = 1 - lens->blue.a - lens->blue.b - lens->blue.c;          \n"
"      lens->alpha.d = 1 - lens->alpha.a - lens->alpha.b - lens->alpha.c;      \n"
"                                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"find_src_pixel (LensCorrectionModel *lcip, ChannelCorrectionModel *pp,        \n"
"                gfloat x, gfloat y, gfloat *srcx, gfloat *srcy)               \n"
"{                                                                             \n"
"  gdouble r, radj;                                                            \n"
"                                                                              \n"
"  r = hypot (x - lcip->cx, y - lcip->cy) / lcip->rscale;                      \n"
"  radj = (((pp->a*r+pp->b)*r+pp->c)*r+pp->d);                                 \n"
"  *srcx = (x - lcip->cx) * radj + lcip->cx;                                   \n"
"  *srcy = (y - lcip->cy) * radj + lcip->cy;                                   \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"lens_distort_newl (gfloat              *src_buf,                              \n"
"                   gfloat              *dst_buf,                              \n"
"                   const GeglRectangle *extended,                             \n"
"                   const GeglRectangle *result,                               \n"
"                   const GeglRectangle *boundary,                             \n"
"                   LensCorrectionModel *lens,                                 \n"
"                   gint                 xx,                                   \n"
"                   gint                 yy,                                   \n"
"                   GeglBuffer          *input)                                \n"
"{                                                                             \n"
"  gfloat temp[4];                                                             \n"
"  gint   tmpx, tmpy, x, y, rgb;                                               \n"
"  gint   offset;                                                              \n"
"                                                                              \n"
"  ChannelCorrectionModel ccm[4];                                              \n"
"                                                                              \n"
"  /* Compute each dst pixel in turn and store into dst buffer. */             \n"
"  ccm[0] = lens->red;                                                         \n"
"  ccm[1] = lens->green;                                                       \n"
"  ccm[2] = lens->blue;                                                        \n"
"  ccm[3] = lens->alpha;                                                       \n"
"                                                                              \n"
"  for (rgb = 0; rgb < 4; rgb++)                                               \n"
"    {                                                                         \n"
"      gfloat gx, gy;                                                          \n"
"      gfloat val = 0.0;                                                       \n"
"      gfloat wx[2], wy[2], wt = 0.0;                                          \n"
"                                                                              \n"
"      find_src_pixel (lens, &ccm[rgb], (gfloat)xx, (gfloat)yy, &gx, &gy);     \n"
"      tmpx = (gint) gx;                                                       \n"
"      tmpy = (gint) gy;                                                       \n"
"                                                                              \n"
"      wx[1] = gx - tmpx;                                                      \n"
"      wx[0] = 1.0 - wx[1];                                                    \n"
"      wy[1] = gy - tmpy;                                                      \n"
"      wy[0] = 1.0 - wy[1];                                                    \n"
"                                                                              \n"
"      for (x = 0; x < 2; x++)                                                 \n"
"        {                                                                     \n"
"          for (y = 0; y < 2; y++)                                             \n"
"            {                                                                 \n"
"              if (tmpx+x >= extended->x && tmpx+x < extended->x + extended->width\n"
"                  && tmpy+y >= extended->y && tmpy+y < extended->y + extended->height)\n"
"                {                                                             \n"
"                  offset = (tmpy + y - extended->y) * extended->width * 4 +   \n"
"                    (tmpx + x - extended->x) * 4 + rgb;                       \n"
"                  val += src_buf[offset] * wx[x] * wy[y];                     \n"
"                  wt += wx[x] * wy[y];                                        \n"
"                }                                                             \n"
"              else if (tmpx+x >= boundary->x &&                               \n"
"                       tmpx+x < boundary->x + boundary->width &&              \n"
"                       tmpy+y >= boundary->y &&                               \n"
"                       tmpy+y < boundary->y + boundary->height)               \n"
"                {                                                             \n"
"                  gfloat color[4];                                            \n"
"                  gegl_buffer_sample (input, tmpx+x, tmpy+y, NULL, color,     \n"
"                                      babl_format (\"RGBA float\"),           \n"
"                                      GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE); \n"
"                  val += color[rgb] * wx[x] * wy[y];                          \n"
"                  wt += wx[x] * wy[y];                                        \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      if (wt <= 0)                                                            \n"
"        {                                                                     \n"
"          temp [rgb] = 0.0;                                                   \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          temp [rgb] =  val / wt;                                             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  offset = (yy - result->y) * result->width * 4 + (xx - result->x) * 4;       \n"
"  for (x=0; x<4; x++)                                                         \n"
"    dst_buf[offset++] = temp[x];                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o = GEGL_PROPERTIES (operation);                   \n"
"  LensCorrectionModel  lens = { { 0, }, };                                    \n"
"  GeglRectangle        boundary = *gegl_operation_source_get_bounding_box     \n"
"    (operation, \"input\");                                                   \n"
"                                                                              \n"
"  gint     x, y, found = FALSE;                                               \n"
"  gfloat *src_buf, *dst_buf;                                                  \n"
"  src_buf    = g_new0 (gfloat, result->width * result->height * 4);           \n"
"  dst_buf    = g_new0 (gfloat, result->width * result->height * 4);           \n"
"                                                                              \n"
"  found = find_make_lens (&lens, o, boundary);                                \n"
"  if (!found) make_lens (&lens, o, boundary);                                 \n"
"                                                                              \n"
"  gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"),          \n"
"                   src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);            \n"
"                                                                              \n"
"  for (y = result->y; y < result->y + result->height; y++)                    \n"
"    for (x = result->x; x < result->x + result->width; x++)                   \n"
"      {                                                                       \n"
"        lens_distort_newl (src_buf, dst_buf, result,                          \n"
"                           result, &boundary, &lens, x, y, input);            \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, babl_format (\"RGBA float\"),           \n"
"                   dst_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (dst_buf);                                                           \n"
"  g_free (src_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"   \"name\"       , \"gegl:lens-correct\",                                    \n"
"   \"categories\" , \"blur\",                                                 \n"
"   \"description\",                                                           \n"
"    _(\"Copies image performing lens distortion correction.\"),               \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
