static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006-2014 Øyvind Kolås <pippin@gimp.org>                       \n"
" * Copyright 2014 The Grid, Jon Nordby <jononor@gmail.com>                    \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include \"math.h\"                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"property_color(color1, _(\"Color 1\"), \"black\")                             \n"
"property_double(stop1, _(\"Stop 1\"), 0.0)                                    \n"
"property_color(color2, _(\"Color 2\"), \"white\")                             \n"
"property_double(stop2, _(\"Stop 2\"), 1.0)                                    \n"
"property_color(color3, _(\"Color 3\"), \"white\")                             \n"
"property_double(stop3, _(\"Stop 3\"), 1.0)                                    \n"
"property_color(color4, _(\"Color 4\"), \"white\")                             \n"
"property_double(stop4, _(\"Stop 4\"), 1.0)                                    \n"
"property_color(color5, _(\"Color 5\"), \"white\")                             \n"
"property_double(stop5, _(\"Stop 5\"), 1.0)                                    \n"
"property_boolean(srgb, _(\"sRGB\"), FALSE)                                    \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME gradient_map                                             \n"
"#define GEGL_OP_C_SOURCE gradient-map.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"// TODO: create a custom GeglGradient type                                    \n"
"// - take this as input                                                       \n"
"// - should have a number of GeglColor stops                                  \n"
"// - should be deserializable from a (JSON) array of GeglColor values         \n"
"                                                                              \n"
"#define GRADIENT_STOPS 5                                                      \n"
"static const gint gradient_length = 2048;                                     \n"
"static const gint gradient_channels = 4; // RGBA                              \n"
"                                                                              \n"
"typedef struct RgbaColor_ {                                                   \n"
"    gdouble r;                                                                \n"
"    gdouble g;                                                                \n"
"    gdouble b;                                                                \n"
"    gdouble a;                                                                \n"
"} RgbaColor;                                                                  \n"
"                                                                              \n"
"static void                                                                   \n"
"rgba_from_gegl_color(RgbaColor *c, GeglColor *color, const Babl *format)      \n"
"{                                                                             \n"
"    gfloat out[4];                                                            \n"
"    gegl_color_get_pixel(color, format, out);                                 \n"
"    c->r = out[0];                                                            \n"
"    c->g = out[1];                                                            \n"
"    c->b = out[2];                                                            \n"
"    c->a = out[3];                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"typedef struct GradientMapProperties_ {                                       \n"
"    gdouble *gradient;                                                        \n"
"} GradientMapProperties;                                                      \n"
"                                                                              \n"
"static inline void                                                            \n"
"pixel_interpolate_gradient(gdouble *samples, const gint offset,               \n"
"                    const RgbaColor *c1, const RgbaColor *c2, const float weight)\n"
"{                                                                             \n"
"    samples[offset+0] = c1->r + (weight * (c2->r - c1->r));                   \n"
"    samples[offset+1] = c1->g + (weight * (c2->g - c1->g));                   \n"
"    samples[offset+2] = c1->b + (weight * (c2->b - c1->b));                   \n"
"    samples[offset+3] = c1->a + (weight * (c2->a - c1->a));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float                                                           \n"
"mapf(float x, float in_min, float in_max, float out_min, float out_max)       \n"
"{                                                                             \n"
"  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gdouble *                                                              \n"
"create_linear_gradient(GeglColor **colors, gdouble *stops, const gint no_stops,\n"
"                       const gint gradient_len, gint channels, const Babl *format)\n"
"{                                                                             \n"
"    gdouble *samples = (gdouble *)g_new(gdouble, gradient_len*channels);      \n"
"                                                                              \n"
"    // XXX: assumes that                                                      \n"
"    // - stops are in ascending order                                         \n"
"    // - first stop is at 0.0                                                 \n"
"    RgbaColor from, to;                                                       \n"
"    gint from_stop = 0;                                                       \n"
"    gint to_stop = 1;                                                         \n"
"    rgba_from_gegl_color(&from, colors[from_stop], format);                   \n"
"    rgba_from_gegl_color(&to, colors[to_stop], format);                       \n"
"                                                                              \n"
"    for (int px=0; px < gradient_len; px++) {                                 \n"
"        const float pos = ((float)px)/gradient_len;                           \n"
"        float to_pos = (to_stop >= no_stops) ? 1.0 : stops[to_stop];          \n"
"        if (pos > to_pos) {                                                   \n"
"            from_stop = (from_stop+1 < no_stops) ? from_stop+1 : from_stop;   \n"
"            to_stop = (to_stop+1 < no_stops) ? to_stop+1 : to_stop;           \n"
"            to_pos = stops[to_stop];                                          \n"
"            rgba_from_gegl_color(&from, colors[from_stop], format);           \n"
"            rgba_from_gegl_color(&to, colors[to_stop], format);               \n"
"        }                                                                     \n"
"        {                                                                     \n"
"        const float from_pos = (from_stop < 0) ? 0.0 : stops[from_stop];      \n"
"        const float weight = ((to_stop-from_stop) == 0) ? 1.0 : mapf(pos, from_pos, to_pos, 0.0, 1.0);\n"
"        const size_t offset = px*channels;                                    \n"
"        pixel_interpolate_gradient(samples, offset, &from, &to, weight);      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"    return samples;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_pixel_gradient_map(gfloat *in, gfloat *out, gdouble *gradient,        \n"
"                           gint gradient_len, gint gradient_channels)         \n"
"{                                                                             \n"
"    const gint index = CLAMP (in[0] * (gradient_len-1), 0, gradient_len-1);   \n"
"    gdouble *mapped = &(gradient[index * gradient_channels]);                 \n"
"    out[0] = mapped[0];                                                       \n"
"    out[1] = mapped[1];                                                       \n"
"    out[2] = mapped[2];                                                       \n"
"    out[3] = mapped[3] * in[1];                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GradientMapProperties *props = (GradientMapProperties*)o->user_data;        \n"
"  GeglColor *colors[GRADIENT_STOPS] = {                                       \n"
"      o->color1,                                                              \n"
"      o->color2,                                                              \n"
"      o->color3,                                                              \n"
"      o->color4,                                                              \n"
"      o->color5                                                               \n"
"  };                                                                          \n"
"  gdouble stops[GRADIENT_STOPS] = {                                           \n"
"      o->stop1,                                                               \n"
"      o->stop2,                                                               \n"
"      o->stop3,                                                               \n"
"      o->stop4,                                                               \n"
"      o->stop5                                                                \n"
"  };                                                                          \n"
"  const Babl *input_format = (o->srgb) ? babl_format (\"Y'A float\") : babl_format (\"YA float\");\n"
"  const Babl *output_format = (o->srgb) ? babl_format (\"R'G'B'A float\") : babl_format (\"RGBA float\");\n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", input_format);             \n"
"  gegl_operation_set_format (operation, \"output\", output_format);           \n"
"                                                                              \n"
"  if (!props)                                                                 \n"
"    {                                                                         \n"
"      props = g_new(GradientMapProperties, 1);                                \n"
"      props->gradient = NULL;                                                 \n"
"      o->user_data = props;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (props->gradient) {                                                      \n"
"    g_free(props->gradient);                                                  \n"
"  }                                                                           \n"
"  props->gradient = create_linear_gradient(colors, stops, GRADIENT_STOPS,     \n"
"                                gradient_length, gradient_channels, output_format);\n"
"}                                                                             \n"
"                                                                              \n"
"static void finalize (GObject *object)                                        \n"
"{                                                                             \n"
"    GeglOperation *op = (void*)object;                                        \n"
"    GeglProperties *o = GEGL_PROPERTIES (op);                                 \n"
"    if (o->user_data) {                                                       \n"
"      GradientMapProperties *props = (GradientMapProperties *)o->user_data;   \n"
"      if (props->gradient) {                                                  \n"
"        g_free(props->gradient);                                              \n"
"      }                                                                       \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"    G_OBJECT_CLASS(gegl_op_parent_class)->finalize (object);                  \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat     * GEGL_ALIGNED in_pixel = in_buf;                                \n"
"  gfloat     * GEGL_ALIGNED out_pixel = out_buf;                              \n"
"  GradientMapProperties *props = (GradientMapProperties*)o->user_data;        \n"
"                                                                              \n"
"  for (int i=0; i<n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      process_pixel_gradient_map(in_pixel, out_pixel, props->gradient, gradient_length, gradient_channels);\n"
"      in_pixel  += 2;                                                         \n"
"      out_pixel += 4;                                                         \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"  gchar                         *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:gradient-map'>\"                                  \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='color1'>#410404</param>\"                              \n"
"    \"    <param name='color2'>#22FFFA</param>\"                              \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"  operation_class->prepare = prepare;                                         \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:gradient-map\",                                  \n"
"      \"title\"      , _(\"Gradient Map\"),                                   \n"
"      \"categories\", \"color\",                                              \n"
"      \"description\", _(\"Applies a color gradient.\"),                      \n"
"      \"reference-composition\", composition,                                 \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif /* #ifdef GEGL_PROPERTIES */                                           \n"
;
