static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double(real, _(\"Real coordinate\"), -1.77)                          \n"
"   value_range (-200.0, 200.0)                                                \n"
"property_double(img,  _(\"Imaginary coordinate\"), 0.0)                       \n"
"   value_range (-200.0, 200.0)                                                \n"
"property_double(level, _(\"Water level\"), 3.5)                               \n"
"   value_range (-200.0, 200.0)                                                \n"
"property_int (maxiter, _(\"Iterations\"), 128)                                \n"
"   description (_(\"Maximum number of iterations\"))                          \n"
"   value_range (0, 512)                                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_NAME mandelbrot                                               \n"
"#define GEGL_OP_C_SOURCE mandelbrot.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"mandel_calc(GeglProperties *o, gfloat x, gfloat y)                            \n"
"{                                                                             \n"
"  gfloat fViewRectReal = o->real;                                             \n"
"  gfloat fViewRectImg  = o->img;                                              \n"
"  gfloat fMagLevel     = o->level;                                            \n"
"                                                                              \n"
"  gfloat fCReal = fViewRectReal + x * fMagLevel;                              \n"
"  gfloat fCImg  = fViewRectImg + y * fMagLevel;                               \n"
"  gfloat fZReal = fCReal;                                                     \n"
"  gfloat fZImg  = fCImg;                                                      \n"
"                                                                              \n"
"        gint n;                                                               \n"
"                                                                              \n"
"        for (n=0;n<o->maxiter;n++)                                            \n"
"          {                                                                   \n"
"                gfloat fZRealSquared = fZReal * fZReal;                       \n"
"                gfloat fZImgSquared = fZImg * fZImg;                          \n"
"                                                                              \n"
"                if (fZRealSquared + fZImgSquared > 4)                         \n"
"                        return 1.0*n/(o->maxiter);                            \n"
"                                                                              \n"
"/*                -- z = z^2 + c*/                                            \n"
"                fZImg = 2 * fZReal * fZImg + fCImg;                           \n"
"                fZReal = fZRealSquared - fZImgSquared + fCReal;               \n"
"          }                                                                   \n"
"        return 1.0;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {-256,-256, 1024, 1024};                             \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *buf;                                                            \n"
"  gint        pxsize;                                                         \n"
"                                                                              \n"
"  g_object_get (output, \"px-size\", &pxsize, NULL);                          \n"
"                                                                              \n"
"  buf = g_malloc (result->width * result->height * pxsize);                   \n"
"                                                                              \n"
"    {                                                                         \n"
"      gfloat *dst = buf;                                                      \n"
"      gint y;                                                                 \n"
"      for (y=0; y < result->height; y++)                                      \n"
"        {                                                                     \n"
"          gint x;                                                             \n"
"          for (x=0; x < result->width ; x++)                                  \n"
"            {                                                                 \n"
"              gfloat value;                                                   \n"
"              gfloat nx,ny;                                                   \n"
"                                                                              \n"
"              nx = (x + result->x);                                           \n"
"              ny = (y + result->y);                                           \n"
"                                                                              \n"
"              nx = (nx/512);                                                  \n"
"              ny = (ny/512);                                                  \n"
"                                                                              \n"
"              value = mandel_calc (o, nx, ny);                                \n"
"                                                                              \n"
"              *dst++ = value;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, NULL, 0, babl_format (\"Y float\"), buf,           \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  g_free (buf);                                                               \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:mandelbrot\",                                    \n"
"    \"categories\"  , \"render\",                                             \n"
"    \"description\" , _(\"Mandelbrot set renderer\"),                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
