static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Author: Hirotsuna Mizuno <s1041150@u-aizu.ac.jp>                           \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_illusion_type)                                               \n"
"  enum_value (GEGL_ILLUSION_TYPE_1, \"type1\", N_(\"Type 1\"))                \n"
"  enum_value (GEGL_ILLUSION_TYPE_2, \"type2\", N_(\"Type 2\"))                \n"
"enum_end (GeglIllusionType)                                                   \n"
"                                                                              \n"
"property_int  (division, _(\"Division\"), 8)                                  \n"
"  description (_(\"The number of divisions\"))                                \n"
"  value_range (0, 64)                                                         \n"
"  ui_range    (0, 64)                                                         \n"
"                                                                              \n"
"property_enum (illusion_type, _(\"Illusion type\"),                           \n"
"                GeglIllusionType, gegl_illusion_type,                         \n"
"                GEGL_ILLUSION_TYPE_1)                                         \n"
"  description (_(\"Type of illusion\"))                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE illusion.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const GeglRectangle *bb = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (! format || ! babl_format_has_alpha (format))                           \n"
"    format = babl_format (\"R'G'B' float\");                                  \n"
"  else                                                                        \n"
"    format = babl_format (\"R'G'B'A float\");                                 \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"                                                                              \n"
"  if (bb && ! gegl_rectangle_is_infinite_plane (bb))                          \n"
"    {                                                                         \n"
"      GeglProperties *o  = GEGL_PROPERTIES (operation);                       \n"
"      gdouble        *dx = g_new (gdouble, (4 * o->division + 1) * 2);        \n"
"      gdouble        *dy = &dx[4 * o->division + 1];                          \n"
"      gdouble         offset = (gint) (sqrt (bb->width * bb->width + bb->height * bb->height) / 4);\n"
"      gint            i;                                                      \n"
"                                                                              \n"
"      g_object_set_data_full (G_OBJECT (operation), \"free-me\",              \n"
"                              o->user_data = dx, g_free);                     \n"
"                                                                              \n"
"      for (i = -2 * o->division; i <= 2 * o->division; ++i)                   \n"
"        {                                                                     \n"
"          gdouble a = G_PI / o->division * (i * 0.5 + 1.0);                   \n"
"          gdouble c = cos (a);                                                \n"
"          gdouble s = sin (a);                                                \n"
"                                                                              \n"
"          dx[i + 2 * o->division] = GEGL_FLOAT_IS_ZERO (c) ? 0.0 : c * offset;\n"
"          dy[i + 2 * o->division] = GEGL_FLOAT_IS_ZERO (s) ? 0.0 : s * offset;\n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties     *o = GEGL_PROPERTIES (operation);                        \n"
"  GeglBufferIterator *iter;                                                   \n"
"  GeglSampler        *sampler;                                                \n"
"                                                                              \n"
"  gint         x, y, xx, yy, b;                                               \n"
"  gint         width, height, components, angle;                              \n"
"  gdouble      radius, cx, cy;                                                \n"
"  gdouble      center_x;                                                      \n"
"  gdouble      center_y;                                                      \n"
"  gdouble      scale;                                                         \n"
"  gboolean     has_alpha;                                                     \n"
"  gfloat       alpha, alpha1, alpha2;                                         \n"
"  gfloat      *in_pixel1;                                                     \n"
"  gfloat      *in_pixel2;                                                     \n"
"  const gdouble *dx = o->user_data;                                           \n"
"  const gdouble *dy = &dx[4 * o->division + 1];                               \n"
"                                                                              \n"
"  const Babl *format = gegl_operation_get_format (operation, \"output\");     \n"
"  has_alpha  = babl_format_has_alpha (format);                                \n"
"                                                                              \n"
"  if (has_alpha)                                                              \n"
"    components = 4;                                                           \n"
"  else                                                                        \n"
"    components = 3;                                                           \n"
"                                                                              \n"
"  in_pixel1 = g_new (float, components);                                      \n"
"  in_pixel2 = g_new (float, components);                                      \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, level, format,             \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  sampler = gegl_buffer_sampler_new_at_level (input, format,                  \n"
"                                              GEGL_SAMPLER_NEAREST, level);   \n"
"                                                                              \n"
"  width = result->width;                                                      \n"
"  height = result->height;                                                    \n"
"                                                                              \n"
"  center_x = width / 2.0;                                                     \n"
"  center_y = height / 2.0;                                                    \n"
"  scale = sqrt (width * width + height * height) / 2;                         \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"       gfloat  *out_pixel = iter->data[0];                                    \n"
"                                                                              \n"
"       for (y = iter->roi[0].y; y < iter->roi[0].y + iter->roi[0].height; ++y)\n"
"         for (x = iter->roi[0].x; x < iter->roi[0].x + iter->roi[0].width; ++x)\n"
"           {                                                                  \n"
"              cy = ((gdouble) y - center_y) / scale;                          \n"
"              cx = ((gdouble) x - center_x) / scale;                          \n"
"                                                                              \n"
"              angle = floor (atan2 (cy, cx) * o->division / G_PI_2 +          \n"
"                             GEGL_FLOAT_EPSILON);                             \n"
"              radius = sqrt ((gdouble) (cx * cx + cy * cy));                  \n"
"                                                                              \n"
"              if (o->illusion_type == GEGL_ILLUSION_TYPE_1)                   \n"
"                {                                                             \n"
"                   xx = x - dx [2 * o->division + angle];                     \n"
"                   yy = y - dy [2 * o->division + angle];                     \n"
"                }                                                             \n"
"              else                          /* GEGL_ILLUSION_TYPE_2 */        \n"
"                {                                                             \n"
"                   xx = x - dy [2 * o->division + angle];                     \n"
"                   yy = y - dx [2 * o->division + angle];                     \n"
"                }                                                             \n"
"                                                                              \n"
"                gegl_sampler_get (sampler, x, y, NULL,                        \n"
"                                  in_pixel1, GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"                gegl_sampler_get (sampler, xx, yy, NULL,                      \n"
"                                  in_pixel2, GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"                if (has_alpha)                                                \n"
"                  {                                                           \n"
"                     alpha1 = in_pixel1[3];                                   \n"
"                     alpha2 = in_pixel2[3];                                   \n"
"                     alpha  = (1 - radius) * alpha1 + radius * alpha2;        \n"
"                                                                              \n"
"                     if ((out_pixel[3] = (alpha / 2)))                        \n"
"                       {                                                      \n"
"                         for (b = 0; b < 3; b++)                              \n"
"                           out_pixel[b] = ((1 - radius) * in_pixel1[b] * alpha1 +\n"
"                                           radius * in_pixel2[b] * alpha2) / alpha;\n"
"                       }                                                      \n"
"                  }                                                           \n"
"                else                                                          \n"
"                 {                                                            \n"
"                   for (b = 0; b < 3; b++)                                    \n"
"                     out_pixel[b] = (1 - radius) * in_pixel1[b] + radius * in_pixel2[b];\n"
"                 }                                                            \n"
"                                                                              \n"
"                 out_pixel += components;                                     \n"
"           }                                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (in_pixel1);                                                         \n"
"  g_free (in_pixel2);                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"                                                                              \n"
"  const GeglRectangle *in_rect =                                              \n"
"    gegl_operation_source_get_bounding_box (operation, \"input\");            \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (in_rect && gegl_rectangle_is_infinite_plane (in_rect))                  \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->process                 = operation_process;               \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  operation_class->opencl_support          = FALSE;                           \n"
"  operation_class->threaded                = FALSE;                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",        \"gegl:illusion\",                                     \n"
"      \"title\",       _(\"Illusion\"),                                       \n"
"      \"categories\",  \"map\",                                               \n"
"      \"license\",     \"GPL3+\",                                             \n"
"      \"description\", _(\"Superimpose many altered copies of the image.\"),  \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
