/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

/* Uninstalled header defining types and functions internal to GDK */

#ifndef __GDK_INTERNALS_H__
#define __GDK_INTERNALS_H__

#include <gio/gio.h>
#include <gdk/gdktypes.h>
#include <gdk/gdkwindow.h>
#include <gdk/gdkprivate.h>
#ifdef USE_MEDIALIB
#include <gdk/gdkmedialib.h>
#endif

G_BEGIN_DECLS

/**********************
 * General Facilities * 
 **********************/

/* Debugging support */

typedef struct _GdkColorInfo           GdkColorInfo;
typedef struct _GdkEventFilter	       GdkEventFilter;
typedef struct _GdkClientFilter	       GdkClientFilter;

typedef enum {
  GDK_COLOR_WRITEABLE = 1 << 0
} GdkColorInfoFlags;

struct _GdkColorInfo
{
  GdkColorInfoFlags flags;
  guint ref_count;
};

struct _GdkEventFilter {
  GdkFilterFunc function;
  gpointer data;
};

struct _GdkClientFilter {
  GdkAtom       type;
  GdkFilterFunc function;
  gpointer      data;
};

typedef enum {
  GDK_DEBUG_MISC          = 1 << 0,
  GDK_DEBUG_EVENTS        = 1 << 1,
  GDK_DEBUG_DND           = 1 << 2,
  GDK_DEBUG_XIM           = 1 << 3,
  GDK_DEBUG_NOGRABS       = 1 << 4,
  GDK_DEBUG_COLORMAP	  = 1 << 5,
  GDK_DEBUG_INPUT	  = 1 << 6,
  GDK_DEBUG_CURSOR	  = 1 << 7,
  GDK_DEBUG_MULTIHEAD	  = 1 << 8,
  GDK_DEBUG_XINERAMA	  = 1 << 9,
  GDK_DEBUG_DRAW	  = 1 <<10,
  GDK_DEBUG_EVENTLOOP     = 1 <<11
} GdkDebugFlag;

extern GList            *_gdk_default_filters;
extern GdkWindow  	*_gdk_parent_root;

extern guint _gdk_debug_flags;
extern gboolean _gdk_native_windows;

#ifdef G_ENABLE_DEBUG

#define GDK_NOTE(type,action)		     G_STMT_START { \
    if (_gdk_debug_flags & GDK_DEBUG_##type)		    \
       { action; };			     } G_STMT_END

#else /* !G_ENABLE_DEBUG */

#define GDK_NOTE(type,action)

#endif /* G_ENABLE_DEBUG */

/* Arg parsing */

typedef enum 
{
  GDK_ARG_STRING,
  GDK_ARG_INT,
  GDK_ARG_BOOL,
  GDK_ARG_NOBOOL,
  GDK_ARG_CALLBACK
} GdkArgType;

typedef struct _GdkArgContext GdkArgContext;
typedef struct _GdkArgDesc GdkArgDesc;

typedef void (*GdkArgFunc) (const char *name, const char *arg, gpointer data);

struct _GdkArgContext
{
  GPtrArray *tables;
  gpointer cb_data;
};

struct _GdkArgDesc
{
  const char *name;
  GdkArgType type;
  gpointer location;
  GdkArgFunc callback;
};

/* Event handling */

typedef struct _GdkEventPrivate GdkEventPrivate;

typedef enum
{
  /* Following flag is set for events on the event queue during
   * translation and cleared afterwards.
   */
  GDK_EVENT_PENDING = 1 << 0
} GdkEventFlags;

struct _GdkEventPrivate
{
  GdkEvent   event;
  guint      flags;
  GdkScreen *screen;
  gpointer   windowing_data;
  GdkDevice *device;
};

/* Tracks information about the pointer grab on this display */
typedef struct
{
  GdkWindow *window;
  GdkWindow *native_window;
  gulong serial_start;
  gulong serial_end; /* exclusive, i.e. not active on serial_end */
  gboolean owner_events;
  guint event_mask;
  gboolean implicit;
  guint32 time;
  GdkGrabOwnership ownership;

  guint activated : 1;
  guint implicit_ungrab : 1;
} GdkDeviceGrabInfo;

typedef struct _GdkInputWindow GdkInputWindow;

typedef void (* GdkDisplayPointerInfoForeach) (GdkDisplay           *display,
                                               GdkDevice            *device,
                                               GdkPointerWindowInfo *device_info,
                                               gpointer              user_data);

/* Private version of GdkWindowObject. The initial part of this strucuture
   is public for historical reasons. Don't change that part */
typedef struct _GdkWindowPaint             GdkWindowPaint;

#define GDK_WINDOW_OBJECT(object)    ((GdkWindowObject *) GDK_WINDOW (object))

struct _GdkWindowObject
{
  GdkDrawable parent_instance;

  GdkDrawable *impl; /* window-system-specific delegate object */  
  
  GdkWindowObject *parent;
  GdkVisual *visual;

  gpointer user_data;

  gint x;
  gint y;
  
  gint extension_events;

  GList *filters;
  GList *children;

  cairo_pattern_t *background;
  
  GSList *paint_stack;
  
  cairo_region_t *update_area;
  guint update_freeze_count;
  
  guint8 window_type;
  guint8 depth;
  guint8 resize_count;

  GdkWindowState state;
  
  guint guffaw_gravity : 1;
  guint input_only : 1;
  guint modal_hint : 1;
  guint composited : 1;
  
  guint destroyed : 2;

  guint accept_focus : 1;
  guint focus_on_map : 1;
  guint shaped : 1;
  guint support_multidevice : 1;
  
  GdkEventMask event_mask;

  guint update_and_descendants_freeze_count;

  /* The GdkWindowObject that has the impl, ref:ed if another window.
   * This ref is required to keep the wrapper of the impl window alive
   * for as long as any GdkWindow references the impl. */
  GdkWindowObject *impl_window; 
  int abs_x, abs_y; /* Absolute offset in impl */
  gint width, height;
  guint32 clip_tag;
  cairo_region_t *clip_region; /* Clip region (wrt toplevel) in window coords */
  cairo_region_t *clip_region_with_children; /* Clip region in window coords */
  GdkCursor *cursor;
  GHashTable *device_cursor;
  gint8 toplevel_window_type;
  guint synthesize_crossing_event_queued : 1;
  guint effective_visibility : 2;
  guint visibility : 2; /* The visibility wrt the toplevel (i.e. based on clip_region) */
  guint native_visibility : 2; /* the native visibility of a impl windows */
  guint viewable : 1; /* mapped and all parents mapped */
  guint applied_shape : 1;

  guint num_offscreen_children;
  GdkWindowPaint *implicit_paint;
  GdkInputWindow *input_window; /* only set for impl windows */

  GList *outstanding_moves;

  cairo_region_t *shape;
  cairo_region_t *input_shape;
  
  cairo_surface_t *cairo_surface;
  guint outstanding_surfaces; /* only set on impl window */

  GList *devices_inside;
  GHashTable *device_events;
};

#define GDK_WINDOW_TYPE(d) (((GdkWindowObject*)(GDK_WINDOW (d)))->window_type)
#define GDK_WINDOW_DESTROYED(d) (((GdkWindowObject*)(GDK_WINDOW (d)))->destroyed)

extern GdkEventFunc   _gdk_event_func;    /* Callback for events */
extern gpointer       _gdk_event_data;
extern GDestroyNotify _gdk_event_notify;

extern GSList    *_gdk_displays;
extern gchar     *_gdk_display_name;
extern gint       _gdk_screen_number;
extern gchar     *_gdk_display_arg_name;
extern gboolean   _gdk_enable_multidevice;

void      _gdk_events_queue  (GdkDisplay *display);
GdkEvent* _gdk_event_unqueue (GdkDisplay *display);

GList* _gdk_event_queue_find_first   (GdkDisplay *display);
void   _gdk_event_queue_remove_link  (GdkDisplay *display,
				      GList      *node);
GList* _gdk_event_queue_prepend      (GdkDisplay *display,
				      GdkEvent   *event);
GList* _gdk_event_queue_append       (GdkDisplay *display,
				      GdkEvent   *event);
GList* _gdk_event_queue_insert_after (GdkDisplay *display,
                                      GdkEvent   *after_event,
                                      GdkEvent   *event);
GList* _gdk_event_queue_insert_before(GdkDisplay *display,
                                      GdkEvent   *after_event,
                                      GdkEvent   *event);
void   _gdk_event_button_generate    (GdkDisplay *display,
				      GdkEvent   *event);

void _gdk_windowing_event_data_copy (const GdkEvent *src,
                                     GdkEvent       *dst);
void _gdk_windowing_event_data_free (GdkEvent       *event);

void gdk_synthesize_window_state (GdkWindow     *window,
                                  GdkWindowState unset_flags,
                                  GdkWindowState set_flags);

GdkDeviceManager * _gdk_device_manager_new (GdkDisplay *display);

gboolean _gdk_cairo_surface_extents (cairo_surface_t *surface,
                                     GdkRectangle *extents);

cairo_surface_t *_gdk_drawable_ref_cairo_surface (GdkDrawable *drawable);

cairo_surface_t * _gdk_drawable_create_cairo_surface (GdkDrawable *drawable,
						      int width,
						      int height);

/*************************************
 * Interfaces used by windowing code *
 *************************************/

void       _gdk_window_impl_new          (GdkWindow      *window,
					  GdkWindow      *real_parent,
					  GdkScreen      *screen,
					  GdkEventMask    event_mask,
                                          GdkWindowAttr  *attributes,
                                          gint            attributes_mask);
void       _gdk_window_destroy           (GdkWindow      *window,
                                          gboolean        foreign_destroy);
void       _gdk_window_clear_update_area (GdkWindow      *window);
void       _gdk_window_update_size       (GdkWindow      *window);
gboolean   _gdk_window_update_viewable   (GdkWindow      *window);

void       _gdk_window_process_updates_recurse (GdkWindow *window,
                                                cairo_region_t *expose_region);

void       _gdk_screen_close             (GdkScreen      *screen);

const char *_gdk_get_sm_client_id (void);

/*****************************************
 * Interfaces provided by windowing code *
 *****************************************/

/* Font/string functions implemented in module-specific code */

void _gdk_cursor_destroy (GdkCursor *cursor);

void     _gdk_windowing_init                    (void);

extern const GOptionEntry _gdk_windowing_args[];
void     _gdk_windowing_set_default_display     (GdkDisplay *display);

gchar *_gdk_windowing_substitute_screen_number (const gchar *display_name,
					        gint         screen_number);

gulong   _gdk_windowing_window_get_next_serial  (GdkDisplay *display);
void     _gdk_windowing_window_get_offsets      (GdkWindow  *window,
						 gint       *x_offset,
						 gint       *y_offset);
cairo_region_t *_gdk_windowing_window_get_shape      (GdkWindow  *window);
cairo_region_t *_gdk_windowing_window_get_input_shape(GdkWindow  *window);
void     _gdk_windowing_window_beep             (GdkWindow *window);


void       _gdk_windowing_get_device_state   (GdkDisplay       *display,
                                              GdkDevice        *device,
					      GdkScreen       **screen,
					      gint             *x,
					      gint             *y,
					      GdkModifierType  *mask);
GdkWindow* _gdk_windowing_window_at_device_position  (GdkDisplay       *display,
                                                      GdkDevice        *device,
                                                      gint             *win_x,
                                                      gint             *win_y,
                                                      GdkModifierType  *mask,
                                                      gboolean          get_toplevel);
GdkGrabStatus _gdk_windowing_device_grab     (GdkDevice        *device,
                                              GdkWindow        *window,
					      GdkWindow        *native,
					      gboolean          owner_events,
					      GdkEventMask      event_mask,
					      GdkWindow        *confine_to,
					      GdkCursor        *cursor,
					      guint32           time);
void _gdk_windowing_got_event                (GdkDisplay       *display,
					      GList            *event_link,
					      GdkEvent         *event,
					      gulong            serial);

void _gdk_windowing_window_process_updates_recurse (GdkWindow *window,
                                                    cairo_region_t *expose_region);
void _gdk_windowing_before_process_all_updates     (void);
void _gdk_windowing_after_process_all_updates      (void);

/* Return the number of bits-per-pixel for images of the specified depth. */
gint _gdk_windowing_get_bits_for_depth (GdkDisplay *display,
					gint        depth);


#define GDK_WINDOW_IS_MAPPED(window) ((((GdkWindowObject*)window)->state & GDK_WINDOW_STATE_WITHDRAWN) == 0)


/* Called when gdk_window_destroy() is called on a foreign window
 * or an ancestor of the foreign window. It should generally reparent
 * the window out of it's current heirarchy, hide it, and then
 * send a message to the owner requesting that the window be destroyed.
 */
void _gdk_windowing_window_destroy_foreign (GdkWindow *window);

void _gdk_windowing_display_set_sm_client_id (GdkDisplay  *display,
					      const gchar *sm_client_id);

void _gdk_windowing_window_set_composited (GdkWindow *window,
					   gboolean composited);

#define GDK_TYPE_PAINTABLE            (_gdk_paintable_get_type ())
#define GDK_PAINTABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDK_TYPE_PAINTABLE, GdkPaintable))
#define GDK_IS_PAINTABLE(obj)	      (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDK_TYPE_PAINTABLE))
#define GDK_PAINTABLE_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDK_TYPE_PAINTABLE, GdkPaintableIface))

typedef struct _GdkPaintable        GdkPaintable;
typedef struct _GdkPaintableIface   GdkPaintableIface;

struct _GdkPaintableIface
{
  GTypeInterface g_iface;
  
  void (* begin_paint_region)       (GdkPaintable    *paintable,
                                     GdkWindow       *window,
                                     const cairo_region_t *region);
  void (* end_paint)                (GdkPaintable    *paintable);
};

GType _gdk_paintable_get_type (void) G_GNUC_CONST;

/* Implementation types */
GType _gdk_window_impl_get_type (void) G_GNUC_CONST;

struct GdkAppLaunchContextPrivate
{
  GdkDisplay *display;
  GdkScreen *screen;
  gint workspace;
  guint32 timestamp;
  GIcon *icon;
  char *icon_name;
};

char *_gdk_windowing_get_startup_notify_id (GAppLaunchContext *context,
					    GAppInfo          *info, 
					    GList             *files);
void  _gdk_windowing_launch_failed         (GAppLaunchContext *context, 
				            const char        *startup_notify_id);

void _gdk_display_device_grab_update                     (GdkDisplay *display,
                                                          GdkDevice  *device,
                                                          gulong      current_serial);
GdkDeviceGrabInfo  *_gdk_display_get_last_device_grab  (GdkDisplay *display,
                                                        GdkDevice  *device);
GdkDeviceGrabInfo  *_gdk_display_add_device_grab   (GdkDisplay       *display,
                                                    GdkDevice        *device,
						    GdkWindow        *window,
						    GdkWindow        *native_window,
                                                    GdkGrabOwnership  grab_ownership,
						    gboolean          owner_events,
						    GdkEventMask      event_mask,
						    unsigned long     serial_start,
						    guint32           time,
						    gboolean          implicit);
GdkDeviceGrabInfo  * _gdk_display_has_device_grab  (GdkDisplay *display,
                                                    GdkDevice  *device,
						    gulong      serial);
gboolean _gdk_display_end_device_grab  (GdkDisplay *display,
                                        GdkDevice  *device,
					gulong      serial,
					GdkWindow  *if_child,
					gboolean    implicit);
gboolean _gdk_display_check_grab_ownership (GdkDisplay *display,
                                            GdkDevice  *device,
                                            gulong      serial);
void _gdk_display_enable_motion_hints     (GdkDisplay *display,
                                           GdkDevice  *device);

GdkPointerWindowInfo * _gdk_display_get_pointer_info (GdkDisplay *display,
                                                      GdkDevice  *device);

void _gdk_display_pointer_info_foreach (GdkDisplay                   *display,
                                        GdkDisplayPointerInfoForeach  func,
                                        gpointer                      user_data);

void _gdk_window_invalidate_for_expose (GdkWindow       *window,
					cairo_region_t       *region);

gboolean _gdk_windowing_set_cairo_surface_size (cairo_surface_t *surface,
					        int width,
					        int height);

GdkWindow * _gdk_window_find_child_at (GdkWindow *window,
				       int x, int y);
GdkWindow * _gdk_window_find_descendant_at (GdkWindow *toplevel,
					    double x, double y,
					    double *found_x,
					    double *found_y);

void _gdk_window_add_damage (GdkWindow *toplevel,
			     cairo_region_t *damaged_region);

GdkEvent * _gdk_make_event (GdkWindow    *window,
			    GdkEventType  type,
			    GdkEvent     *event_in_queue,
			    gboolean      before_event);
gboolean _gdk_window_event_parent_of (GdkWindow *parent,
                                      GdkWindow *child);

void _gdk_synthesize_crossing_events (GdkDisplay                 *display,
				      GdkWindow                  *src,
				      GdkWindow                  *dest,
                                      GdkDevice                  *device,
				      GdkCrossingMode             mode,
				      gint                        toplevel_x,
				      gint                        toplevel_y,
				      GdkModifierType             mask,
				      guint32                     time_,
				      GdkEvent                   *event_in_queue,
				      gulong                      serial,
				      gboolean                    non_linear);
void _gdk_display_set_window_under_pointer (GdkDisplay *display,
                                            GdkDevice  *device,
					    GdkWindow  *window);


void _gdk_synthesize_crossing_events_for_geometry_change (GdkWindow *changed_window);

cairo_region_t *_gdk_window_calculate_full_clip_region    (GdkWindow     *window,
                                                      GdkWindow     *base_window,
                                                      gboolean       do_children,
                                                      gint          *base_x_offset,
                                                      gint          *base_y_offset);
gboolean    _gdk_window_has_impl (GdkWindow *window);
GdkWindow * _gdk_window_get_impl_window (GdkWindow *window);
GdkWindow *_gdk_window_get_input_window_for_event (GdkWindow *native_window,
						   GdkEventType event_type,
						   int x, int y,
						   gulong serial);

/*****************************
 * offscreen window routines *
 *****************************/
GType gdk_offscreen_window_get_type (void);
void       _gdk_offscreen_window_new                 (GdkWindow     *window,
						      GdkWindowAttr *attributes,
						      gint           attributes_mask);


/************************************
 * Initialization and exit routines *
 ************************************/

void _gdk_windowing_exit (void);

G_END_DECLS

#endif /* __GDK_INTERNALS_H__ */
