#ifndef __INTERP_H__
#define __INTERP_H__


#include "gtk/gtk.h"


typedef enum
{
  PARAM_UNKNOWN,
  PARAM_VOID,
  PARAM_CHAR,
  PARAM_SHORT,
  PARAM_INT,
  PARAM_UNSIGNED,
  PARAM_FLOAT,
  PARAM_DOUBLE,
  PARAM_STRING,
  PARAM_POINTER,
  PARAM_FUNCTION
} ParamType;


typedef union _Param   Param;

typedef void (*Func) (void);
typedef Param (*Marshaller) (Func   func,
			     Param *params);

union _Param
{
  char c;
  short s;
  int i;
  unsigned u;
  float f;
  double d;
  char *str;
  void *p;
  Func func;
};


void init_interp (void);

void add_func (char       *name,
	       Marshaller  marshaller,
	       Func        func,
	       ParamType   return_val,
	       int         nargs,
	       ...);

void add_const (char *name,
		int   value);


#endif /* __INTERP_H__ */
