#include <math.h>
#include <stdio.h>
#include <guile/gh.h>


static SCM gtkobj_mark (SCM);
static scm_sizet gtkobj_free (SCM);
static int gtkobj_print (SCM, SCM, scm_print_state *);
static SCM gtkobj_equalp (SCM, SCM);


static scm_smobfuns gtkobj_smob_funs =
{
  gtkobj_mark,
  gtkobj_free,
  gtkobj_print,
  gtkobj_equalp
};

static long gtkobj_id;


static SCM
gtkobj_mark (SCM sexp)
{
  printf ("gtkobj_mark\n");
  if (SCM_GC8MARKP (sexp))
    return SCM_BOOL_F;

  SCM_SETGC8MARK (sexp);
  return SCM_BOOL_F;
}

static scm_sizet
gtkobj_free (SCM sexp)
{
  printf ("gtkobj_free\n");
  return 0;
}

static int
gtkobj_print (SCM sexp,
	      SCM port,
	      scm_print_state *pstate)
{
  printf ("gtkobj_print\n");
  scm_gen_puts (scm_regular_string, "#<gtkobj_smob ", port);
  scm_intprint ((long) gh_scm2int (SCM_CDR (sexp)), 10, port);
  scm_gen_putc ('>', port);
  return 1;
}

static SCM
gtkobj_equalp (SCM a, SCM b)
{
  return scm_equal_p (SCM_CDR (a), SCM_CDR (b));
}

static SCM
gtkobj_new (SCM sexp)
{
  SCM smob;

  SCM_NEWCELL (smob);

  SCM_DEFER_INTS;

  SCM_SETCAR (smob, gtkobj_id);
  SCM_SETCDR (smob, sexp);

  SCM_ALLOW_INTS;

  return smob;
}


static void
main_prog (int   argc,
	   char *argv[])
{
  int done;
  char input_str[200];

  gtkobj_id = scm_newsmob (&gtkobj_smob_funs);
  gh_new_procedure1_0 ("gtk:new", gtkobj_new);

  gh_eval_str ("(display \"hello guile\n\")");

  gh_repl ();
  exit (0);
}

int
main (int   argc,
      char *argv[])
{
  gh_enter (argc, argv, main_prog);
  return 0;
}
