#!/usr/local/bin/swig -python -o gtkmodule.c
#
# SWIG wrapper for Gtk-Python

%module _gtk

%{
#include <gtk/gtk.h>
%}

%include glue.i
%include gtkenums.i
%include gdk_typemap.i
%include gtk_typemap.i

// some useful gdk functions
%include gdkfuncs.i

void pygtk_init();

int gtk_accel_label_get_type();
GtkWidget *gtk_accel_label_new(char *string);
int gtk_accel_label_accelerator_width(GtkAccelLabel *accel);
void gtk_accel_label_set_accel_widget(GtkAccelLabel *accel, GtkWidget *wid);
int gtk_accel_label_refetch(GtkAccelLabel *accel);
%{
#define gtk_adjustment_get_lower(o)          ((o)->lower)
#define gtk_adjustment_get_upper(o)          ((o)->upper)
#define gtk_adjustment_get_value(o)          ((o)->value)
#define gtk_adjustment_get_step_increment(o) ((o)->step_increment)
#define gtk_adjustment_get_page_increment(o) ((o)->page_increment)
#define gtk_adjustment_get_page_size(o)      ((o)->page_size)
%}
int gtk_adjustment_get_type();
GtkObject *gtk_adjustment_new(double v, double l, double u, double si,
                                                 double pi, double ps);
double gtk_adjustment_get_lower(GtkAdjustment *a);
double gtk_adjustment_get_upper(GtkAdjustment *a);
double gtk_adjustment_get_value(GtkAdjustment *a);
double gtk_adjustment_get_step_increment(GtkAdjustment *a);
double gtk_adjustment_get_page_increment(GtkAdjustment *a);
double gtk_adjustment_get_page_size(GtkAdjustment *a);
void gtk_adjustment_changed(GtkAdjustment *a);
void gtk_adjustment_value_changed(GtkAdjustment *a);
void gtk_adjustment_set_value(GtkAdjustment *a, double value);
void gtk_adjustment_clamp_page(GtkAdjustment *a, double lower, double upper);
int gtk_alignment_get_type();
GtkWidget *gtk_alignment_new(double xa, double ya, double xs, double ys);
void gtk_alignment_set(GtkAlignment *a, double xa, double ya, double xs,
                                                              double ys);
int gtk_arrow_get_type();
GtkWidget *gtk_arrow_new(int at, int st);
void gtk_arrow_set(GtkArrow *a, int at, int st);
int gtk_aspect_frame_get_type();
GtkWidget *gtk_aspect_frame_new(char *label, double xa, double ya,
                                     double ratio, int obey_child);
void gtk_aspect_frame_set(GtkAspectFrame *a, double xa, double ya,
                                     double ratio, int obey_child);
int gtk_bin_get_type();
int gtk_box_get_type();
void gtk_box_pack_start(GtkBox *b, GtkWidget *w, int e, int f, int p);
void gtk_box_pack_end(GtkBox *b, GtkWidget *w, int e, int f, int p);
void gtk_box_pack_start_defaults(GtkBox *b, GtkWidget *w);
void gtk_box_pack_end_defaults(GtkBox *b, GtkWidget *w);
void gtk_box_set_homogeneous(GtkBox *b, int h);
void gtk_box_set_spacing(GtkBox *b, int s);
void gtk_box_reorder_child(GtkBox *b, GtkWidget *w, int pos);
%{
static PyObject *
gtk__box_query_child_packing(PyObject *self, PyObject *args) {
  PyObject *box, *child;
  gboolean expand, fill;
  guint padding;
  GtkPackType pack_type;
  if (!PyArg_ParseTuple(args, "O!O!:gtk_box_query_child_packing", PyGtk_Type,
			&box, PyGtk_Type, &child))
    return NULL;
  gtk_box_query_child_packing(GTK_BOX(PyGtk_Get(box)),
			      GTK_WIDGET(PyGtk_Get(child)), &expand, &fill,
			      &padding, &pack_type);
  return Py_BuildValue("(iiii)", (int)expand, (int)fill, padding, pack_type);
}
%}
%native(gtk_box_query_child_packing) PyObject *gtk__box_query_child_packing(
					PyObject *self, PyObject *args);
void gtk_box_set_child_packing(GtkBox *box, GtkWidget *child, int expand,
			       int fill, int padding, GtkPackType pack_type);
int gtk_button_get_type();
GtkWidget *gtk_button_new();
GtkWidget *gtk_button_new_with_label(char *l);
void gtk_button_pressed(GtkButton *b);
void gtk_button_released(GtkButton *b);
void gtk_button_clicked(GtkButton *b);
void gtk_button_enter(GtkButton *b);
void gtk_button_leave(GtkButton *b);
void gtk_button_set_relief(GtkButton *b, GtkReliefStyle newstyle);
GtkReliefStyle gtk_button_get_relief(GtkButton *b);
int gtk_button_box_get_type();
%{
static PyObject *
gtk__button_box_get_child_size_default(PyObject *self, PyObject *args) {
    int mw, mh;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_size_default"))
        return NULL;
    gtk_button_box_get_child_size_default(&mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args) {
    int ipx, ipy;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_ipadding_default"))
        return NULL;
    gtk_button_box_get_child_ipadding_default(&ipx, &ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
static PyObject *
gtk__button_box_get_child_size(PyObject *self, PyObject *args) {
    int mw, mh;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_size",
            PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_size(GTK_BUTTON_BOX(PyGtk_Get(o)), &mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args) {
    int ipx, ipy;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_ipadding",
            PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_ipadding(GTK_BUTTON_BOX(PyGtk_Get(o)),&ipx,&ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
%}
%native(gtk_button_box_get_child_size_default) PyObject *
    gtk__button_box_get_child_size_default(PyObject *self, PyObject *args);
%native(gtk_button_box_get_ipadding_default) PyObject *
    gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args);
void gtk_button_box_set_child_size_default(int mw, int mh);
void gtk_button_box_set_child_ipadding_default(int ipx, int ipy);
int gtk_button_box_get_spacing(GtkButtonBox *w);
GtkButtonBoxStyle gtk_button_box_get_layout(GtkButtonBox *w);
%native(gtk_button_box_get_child_size) PyObject *
    gtk__button_box_get_child_size(PyObject *self, PyObject *args);
%native(gtk_button_box_get_child_ipadding) PyObject *
    gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args);
void gtk_button_box_set_spacing(GtkButtonBox *w, int s);
void gtk_button_box_set_layout(GtkButtonBox *w, GtkButtonBoxStyle l);
void gtk_button_box_set_child_size(GtkButtonBox *w, int mw, int mh);
void gtk_button_box_set_child_ipadding(GtkButtonBox *w, int ipx, int ipy);
int gtk_check_button_get_type();
GtkWidget *gtk_check_button_new();
GtkWidget *gtk_check_button_new_with_label(char *l);
%{
#define gtk_check_menu_item_get_active(cb) ((cb)->active)
%}
int gtk_check_menu_item_get_type();
GtkWidget *gtk_check_menu_item_new();
GtkWidget *gtk_check_menu_item_new_with_label(char *l);
void gtk_check_menu_item_set_state(GtkCheckMenuItem *c, int s);
void gtk_check_menu_item_toggled(GtkCheckMenuItem *c);
void gtk_check_menu_item_set_show_toggle(GtkCheckMenuItem *c, int always);
int gtk_check_menu_item_get_active(GtkCheckMenuItem *c);
int gtk_clist_get_type();
GtkWidget *gtk_clist_new(int columns);
%{
static PyObject *gtk__clist_get_selection(PyObject *self, PyObject *args) {
  GList *selection;
  guint row;
  PyObject *clist, *ret;
  if (!PyArg_ParseTuple(args, "O!:gtk_clist_get_selection", PyGtk_Type,
			&clist))
    return NULL;
  ret = PyList_New(0);
  for (selection = GTK_CLIST(PyGtk_Get(clist))->selection; selection != NULL;
       selection = selection->next) {
    row = (guint)selection->data;
    PyList_Append(ret, PyInt_FromLong(row));
  }
  return ret;
}
static PyObject *gtk__clist_new_with_titles(PyObject *self, PyObject *args) {
	int c, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "iO:gtk_clist_new_with_titles",
			&c, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError,"3rd argument not a sequence");
		return NULL;
	}
	if (PySequence_Length(l) < c) {
		PyErr_SetString(PyExc_TypeError, "sequence not long enough");
		return NULL;
	}
	list = malloc(sizeof(char *)*c);
	for (i = 0; i < c; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				 "sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	item = (PyObject *) PyGtk_New((GtkObject *)gtk_clist_new_with_titles
		(c, list));
	free(list);
	return item;
}
%}
%native(gtk_clist_new_with_titles) PyObject *gtk__clist_new_with_titles
		(PyObject *self, PyObject *args); 
%native(gtk_clist_get_selection) PyObject *gtk__clist_get_selection(
				PyObject *self, PyObject *args);
int gtk_clist_row_is_visible(GtkCList *c, int row);
void gtk_clist_set_border(GtkCList *c, GtkShadowType border);
void gtk_clist_set_policy(GtkCList *c, GtkPolicyType vsp, GtkPolicyType hsp);
void gtk_clist_freeze(GtkCList *c);
void gtk_clist_thaw(GtkCList *c);
void gtk_clist_column_titles_show(GtkCList *c);
void gtk_clist_column_titles_hide(GtkCList *c);
void gtk_clist_column_title_active(GtkCList *c, int col);
void gtk_clist_column_title_passive(GtkCList *c, int col);
void gtk_clist_column_titles_active(GtkCList *c);
void gtk_clist_column_titles_passive(GtkCList *c);
void gtk_clist_set_column_title(GtkCList *c, int col, char *title);
void gtk_clist_set_column_widget(GtkCList *c, int col, GtkWidget *w);
void gtk_clist_set_column_justification(GtkCList *c, int col,
					GtkJustification just);
void gtk_clist_set_column_width(GtkCList *c, int col, int width);
void gtk_clist_set_row_height(GtkCList *c, int height);
void gtk_clist_moveto(GtkCList *cl, int r, int c, double ra, double ca);
GtkCellType gtk_clist_get_cell_type(GtkCList *clist, int row, int column);
void gtk_clist_set_text(GtkCList *cl, int r, int c, char *text);
void gtk_clist_set_pixmap(GtkCList *cl, int r, int c, GdkPixmap *pixmap,
			  GdkBitmap *mask);
void gtk_clist_set_pixtext(GtkCList *cl, int r, int c, char *text, int spacing,
			   GdkPixmap *pixmap, GdkBitmap *mask);
%{
static PyObject *gtk__clist_get_text(PyObject *self, PyObject *args) {
	PyGtk_Object *w;
	int r, c;
	char *text;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_text", PyGtk_Type,
			&w, &r, &c))
		return NULL;
	gtk_clist_get_text(GTK_CLIST(PyGtk_Get(w)), r, c, &text);
	return PyString_FromString(text);
}
static PyObject *gtk__clist_get_pixmap(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!iiO!:gtk_clist_get_pixmap", PyGtk_Type,
			&o, &r, &c))
		return NULL;
	gtk_clist_get_pixmap(GTK_CLIST(PyGtk_Get(o)), r, c, &p, &m);
	return Py_BuildValue("(OO)", PyGdkWindow_New(p), PyGdkWindow_New(m));
}
static PyObject *gtk__clist_get_pixtext(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	guint8 spacing;
	char *text;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_pixtext",
			PyGtk_Type, &o, &r, &c))
		return NULL;
	gtk_clist_get_pixtext(GTK_CLIST(PyGtk_Get(o)), r, c, &text, &spacing,
		&p, &m);
	return Py_BuildValue("(siOO)", text, (int)spacing,
			     PyGdkWindow_New(p), PyGdkWindow_New(m));
}
%}
%native(gtk_clist_get_text) PyObject *gtk__clist_get_text(
	PyObject *self, PyObject *args);;
%native(gtk_clist_get_pixmap) PyObject *gtk__clist_get_pixmap(
	PyObject *self, PyObject *args);
%native(gtk_clist_get_pixtext) PyObject *gtk__clist_get_pixtext(
	PyObject *self, PyObject *args);
void gtk_clist_set_foreground(GtkCList *cl, int row, GdkColor *c);
void gtk_clist_set_background(GtkCList *cl, int row, GdkColor *c);
void gtk_clist_set_selection_mode(GtkCList *cl, GtkSelectionMode mode);
void gtk_clist_set_shift(GtkCList *cl, int r, int c, int v, int h);
%{
static PyObject *gtk__clist_append(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!O:gtk_clist_append", PyGtk_Type, &cl,
			&l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	i = gtk_clist_append(GTK_CLIST(PyGtk_Get(cl)), list);
	free(list);
	return PyInt_FromLong(i);
}

static PyObject *gtk__clist_insert(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, r, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_insert", PyGtk_Type, &cl,
			&r, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	gtk_clist_insert(GTK_CLIST(PyGtk_Get(cl)), r, list);
	free(list);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__clist_set_row_data(PyObject *self, PyObject *args) {
        PyGtk_Object *obj;
	int row;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_set_row_data", PyGtk_Type,
			      &obj, &row, &data))
	    return NULL;
	Py_INCREF(data);
	gtk_clist_set_row_data_full(GTK_CLIST(PyGtk_Get(obj)), row, data,
				    (GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__clist_get_selection_info(PyObject *s, PyObject *args) {
  PyObject *clist;
  gint x, y, row, column;
  if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_selection_info", PyGtk_Type,
			&clist, &x, &y))
    return NULL;
  if (gtk_clist_get_selection_info(GTK_CLIST(PyGtk_Get(clist)), x, y,
				   &row, &column))
    return Py_BuildValue("(ii)", row, column);
  else {
    Py_INCREF(Py_None);
    return Py_None;
  }
}   
%}
%native(gtk_clist_append) PyObject *gtk__clist_append(PyObject *s,PyObject *a);
%native(gtk_clist_insert) PyObject *gtk__clist_insert(PyObject *s,PyObject *a);
void gtk_clist_remove(GtkCList *cl, int row);
void gtk_clist_select_row(GtkCList *cl, int r, int c);
void gtk_clist_unselect_row(GtkCList *cl, int r, int c);
void gtk_clist_undo_selection(GtkCList *cl);
void gtk_clist_clear(GtkCList *cl);
%native(gtk_clist_get_selection_info) PyObject *gtk__clist_get_selection_info(
					PyObject *self, PyObject *args);
%native(gtk_clist_set_row_data) PyObject *gtk__clist_set_row_data(PyObject *s,
								  PyObject *a);
PyObject *gtk_clist_get_row_data(GtkCList *cl, int row);
int gtk_clist_find_row_from_data(GtkCList *cl, PyObject *data);
void gtk_clist_select_all(GtkCList *cl);
void gtk_clist_unselect_all(GtkCList *cl);
void gtk_clist_swap_rows(GtkCList *cl, int row1, int row2);
int gtk_color_selection_get_type();
int gtk_color_selection_dialog_get_type();
GtkWidget *gtk_color_selection_new();
void gtk_color_selection_set_update_policy(GtkColorSelection *c,
					   GtkUpdateType p);
void gtk_color_selection_set_opacity(GtkColorSelection *c, int uo);
void gtk_color_selection_set_color(GtkColorSelection *c, gdouble *color);
void gtk_color_selection_get_color(GtkColorSelection *c, gdouble *ocolor);
%{
#define gtk_color_selection_dialog_get_colorsel(d)      ((d)->colorsel)
#define gtk_color_selection_dialog_get_main_vbox(d)     ((d)->main_vbox)
#define gtk_color_selection_dialog_get_ok_button(d)     ((d)->ok_button)
#define gtk_color_selection_dialog_get_reset_button(d)  ((d)->reset_button)
#define gtk_color_selection_dialog_get_cancel_button(d) ((d)->cancel_button)
#define gtk_color_selection_dialog_get_help_button(d)   ((d)->help_button)
%}
GtkWidget *gtk_color_selection_dialog_new(char *title);
GtkWidget *gtk_color_selection_dialog_get_colorsel(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_get_main_vbox(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_get_ok_button(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_get_reset_button(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_get_cancel_button(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_get_help_button(GtkColorSelectionDialog *c);
int gtk_combo_get_type();
%{
#define gtk_combo_get_entry(c) ((c)->entry)
#define gtk_combo_get_list(c)  ((c)->list)
%}
GtkWidget *gtk_combo_new();
void gtk_combo_set_value_in_list(GtkCombo *c, int val, int ok_if_empty);
void gtk_combo_set_use_arrows(GtkCombo *c, int val);
void gtk_combo_set_use_arrows_always(GtkCombo *c, int val);
void gtk_combo_set_case_sensitive(GtkCombo *c, int val);
void gtk_combo_set_item_string(GtkCombo *c, GtkItem *i, char *val);
%{
static PyObject *
gtk__combo_set_popdown_strings(PyObject *self, PyObject *args) {
  PyObject *obj, *list, *item;
  GList *glist = NULL;
  int len, i;
  if (!PyArg_ParseTuple(args, "O!O!:gtk_combo_set_popdown_strings",
			PyGtk_Type, &obj, &PyList_Type, &list))
    return NULL;
  len = PyList_Size(list);
  for (i = 0; i < len; i++) {
    item = PyList_GetItem(list, i);
    if (!PyString_Check(item)) {
      PyErr_SetString(PyExc_TypeError, "list item not a string");
      g_list_free(glist);
      return NULL;
    }
    glist = g_list_append(glist, PyString_AsString(item));
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(PyGtk_Get(obj)), glist);
  g_list_free(glist);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gtk_combo_set_popdown_strings) PyObject *
	gtk__combo_set_popdown_strings(PyObject *self, PyObject *args);
GtkWidget *gtk_combo_get_entry(GtkCombo *c);
GtkWidget *gtk_combo_get_list(GtkCombo *c);
void gtk_combo_disable_activate(GtkCombo *c);
int gtk_curve_get_type();
GtkWidget *gtk_curve_new();
void gtk_curve_reset(GtkCurve *c);
void gtk_curve_set_gamma(GtkCurve *c, double g);
void gtk_curve_set_range(GtkCurve *c, double min_x, double max_x,
                                      double min_y, double max_y);
%{
static PyObject *gtk__curve_get_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  int size=-1, i;
  gfloat *vector;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "O!|i:gtk_curve_get_vector", PyGtk_Type, &obj,
			&size))
    return NULL;
  if (size < 0) size = GTK_CURVE(PyGtk_Get(obj))->num_points;
  vector = g_new(gfloat, size);
  gtk_curve_get_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  ret = PyTuple_New(size);
  for (i = 0; i < size; i++)
    PyTuple_SetItem(ret, i, PyFloat_FromDouble(vector[i]));
  g_free(vector);
  return ret;
}
static PyObject *gtk__curve_set_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  PyObject *seq, *item;
  int size, i;
  gfloat *vector;

  if (!PyArg_ParseTuple(args, "O!O:gtk_curve_set_vector", PyGtk_Type, &obj,
			&seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "2nd argument is not a sequence");
    return NULL;
  }
  size = PySequence_Length(seq);
  vector = g_new(gfloat, size);
  for (i = 0; i < size; i++) {
    item = PyNumber_Float(PySequence_GetItem(seq, i));
    if (item == NULL) {
      g_free(vector);
      return NULL;
    }
    vector[i] = PyFloat_AsDouble(item);
    Py_DECREF(item);
  }
  gtk_curve_set_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  g_free(vector);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gtk_curve_get_vector) PyObject *gtk__curve_get_vector(PyObject *self,
							      PyObject *args);
%native(gtk_curve_set_vector) PyObject *gtk__curve_set_vector(PyObject *self,
							      PyObject *args);
void gtk_curve_set_curve_type(GtkCurve *c, GtkCurveType t);
int gtk_data_get_type();
%{
#define gtk_dialog_get_vbox(d) ((d)->vbox)
#define gtk_dialog_get_action_area(d) ((d)->action_area)
%}
int gtk_dialog_get_type();
GtkWidget *gtk_dialog_new();
GtkWidget *gtk_dialog_get_vbox(GtkDialog *d);
GtkWidget *gtk_dialog_get_action_area(GtkDialog *d);
int gtk_drawing_area_get_type();
GtkWidget *gtk_drawing_area_new();
void gtk_drawing_area_size(GtkDrawingArea *d, int w, int h);
int gtk_editable_get_type();
void gtk_editable_select_region(GtkEditable *e, int start, int end);
%{
static PyObject *gtk__editable_insert_text(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *text;
	int len, pos;
	if (!PyArg_ParseTuple(args, "O!s#:gtk_editable_insert_text",
			PyGtk_Type, &o, &text, &len))
		return NULL;
	gtk_editable_insert_text(GTK_EDITABLE(PyGtk_Get(o)), text, len, &pos);
	return PyInt_FromLong(pos);
}
%}
%native(gtk_editable_insert_text) PyObject *gtk__editable_insert_text(
	PyObject *self, PyObject *args);
void gtk_editable_delete_text(GtkEditable *e, int start, int end);
char *gtk_editable_get_chars(GtkEditable *e, int start, int end);
void gtk_editable_cut_clipboard(GtkEditable *e);
void gtk_editable_copy_clipboard(GtkEditable *e);
void gtk_editable_paste_clipboard(GtkEditable *e);
void gtk_editable_claim_selection(GtkEditable *e, int claim, int time);
void gtk_editable_delete_selection(GtkEditable *e);
void gtk_editable_changed(GtkEditable *e);
void gtk_editable_set_position(GtkEditable *e, int pos);
int gtk_editable_get_position(GtkEditable *e);
void gtk_editable_set_editable(GtkEditable *e, int is_editable);
int gtk_entry_get_type();
GtkWidget *gtk_entry_new();
GtkWidget *gtk_entry_new_with_max_length(int max);
void gtk_entry_set_text(GtkEntry *e, char *t);
void gtk_entry_append_text(GtkEntry *e, char *t);
void gtk_entry_prepend_text(GtkEntry *e, char *t);
void gtk_entry_set_position(GtkEntry *e, int p);
char *gtk_entry_get_text(GtkEntry *e);
void gtk_entry_select_region(GtkEntry *e, int start, int stop);
void gtk_entry_set_visibility(GtkEntry *e, int visible);
void gtk_entry_set_editable(GtkEntry *e, int editable);
void gtk_entry_adjust_scroll(GtkEntry *e);
void gtk_entry_set_max_length(GtkEntry *e, int max);
int gtk_event_box_get_type();
GtkWidget *gtk_event_box_new();

%{
#define gtk_file_selection_get_dir_list(f)  ((f)->dir_list)
#define gtk_file_selection_get_file_list(f) ((f)->file_list)
#define gtk_file_selection_get_selection_entry(f) ((f)->selection_entry)
#define gtk_file_selection_get_selection_text(f)  ((f)->selection_text)
#define gtk_file_selection_get_main_vbox(f) ((f)->main_vbox)
#define gtk_file_selection_get_ok_button(f) ((f)->ok_button)
#define gtk_file_selection_get_cancel_button(f) ((f)->cancel_button)
#define gtk_file_selection_get_help_button(f) ((f)->help_button)
%}
GtkWidget *gtk_file_selection_get_dir_list(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_file_list(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_selection_entry(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_selection_text(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_main_vbox(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_ok_button(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_cancel_button(GtkFileSelection *f);
GtkWidget *gtk_file_selection_get_help_button(GtkFileSelection *f);

int gtk_file_selection_get_type();
GtkWidget *gtk_file_selection_new(char *title);
void gtk_file_selection_set_filename(GtkFileSelection *f, char *file);
char *gtk_file_selection_get_filename(GtkFileSelection *f);
void gtk_file_selection_show_fileop_buttons(GtkFileSelection *f);
void gtk_file_selection_hide_fileop_buttons(GtkFileSelection *f);
int gtk_fixed_get_type();
GtkWidget *gtk_fixed_new();
void gtk_fixed_put(GtkFixed *fixed, GtkWidget *w, int x, int y);
void gtk_fixed_move(GtkFixed *fixed, GtkWidget *w, int x, int y);
int gtk_font_selection_get_type();
GtkWidget *gtk_font_selection_new();
char *gtk_font_selection_get_font_name(GtkFontSelection *fontsel);
GdkFont *gtk_font_selection_get_font(GtkFontSelection *fontsel);
int gtk_font_selection_set_font_name(GtkFontSelection *fontsel, char *name);
char *gtk_font_selection_get_preview_text(GtkFontSelection *fontsel);
void gtk_font_selection_set_preview_text(GtkFontSelection *fontsel,char *text);
%{
#define gtk_font_selection_dialog_get_fontsel(o) ((o)->fontsel)
#define gtk_font_selection_dialog_get_main_vbox(o) ((o)->main_vbox)
#define gtk_font_selection_dialog_get_action_area(o) ((o)->action_area)
#define gtk_font_selection_dialog_get_ok_button(o) ((o)->ok_button)
#define gtk_font_selection_dialog_get_apply_button(o) ((o)->apply_button)
#define gtk_font_selection_dialog_get_cancel_button(o) ((o)->cancel_button)
%}
int gtk_font_selection_dialog_get_type();
GtkWidget *gtk_font_selection_dialog_get_fontsel(GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_get_main_vbox(GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_get_action_area(
						GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_get_ok_button(GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_get_apply_button(
						GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_get_cancel_button(
						GtkFontSelectionDialog *d);
GtkWidget *gtk_font_selection_dialog_new(char *title);
char *gtk_font_selection_dialog_get_font_name(GtkFontSelectionDialog *fsd);
GdkFont *gtk_font_selection_dialog_get_font(GtkFontSelectionDialog *fsd);
int gtk_font_selection_dialog_set_font_name(GtkFontSelectionDialog *fsd,
					    char *name);
char *gtk_font_selection_dialog_get_preview_text(GtkFontSelectionDialog *fsd);
void gtk_font_selection_dialog_set_preview_text(GtkFontSelectionDialog *fsd,
					   char *text);
int gtk_frame_get_type();
GtkWidget *gtk_frame_new(char *label);
void gtk_frame_set_label(GtkFrame *f, char *label);
void gtk_frame_set_label_align(GtkFrame *f, double xa, double ya);
void gtk_frame_set_shadow_type(GtkFrame *f, GtkShadowType st);
int gtk_gamma_curve_get_type();
GtkWidget *gtk_gamma_curve_new();
int gtk_handle_box_get_type();
GtkWidget *gtk_handle_box_new();
int gtk_hbox_get_type();
GtkWidget *gtk_hbox_new(int homogeneous, int spacing);
int gtk_hbutton_box_get_type();
GtkWidget *gtk_hbutton_box_new();
int gtk_hbutton_box_get_spacing_default();
int gtk_hbutton_box_get_layout_default();
void gtk_hbutton_box_set_spacing_default(int s);
void gtk_hbutton_box_set_layout_default(GtkButtonBoxStyle l);
int gtk_hpaned_get_type();
GtkWidget *gtk_hpaned_new();
int gtk_hruler_get_type();
GtkWidget *gtk_hruler_new();
int gtk_hscale_get_type();
GtkWidget *gtk_hscale_new(GtkAdjustment *adjustment = NULL);
int gtk_hscrollbar_get_type();
GtkWidget *gtk_hscrollbar_new(GtkAdjustment *adjustment = NULL);
int gtk_hseparator_get_type();
GtkWidget *gtk_hseparator_new();
int gtk_image_get_type();
// GtkWidget *gtk_image_new(GdkImage *val, GdkBitmap *mask);
// void gtk_image_set(GtkImage *i, GdkImage *val, GdkBitmap *mask);
// void gtk_image_get(GtkImage *i, GdkImage **val, GdkBitmap **mask);
int gtk_input_dialog_get_type();
GtkWidget *gtk_input_dialog_new();
int gtk_item_get_type();
void gtk_item_select(GtkItem *i);
void gtk_item_deselect(GtkItem *i);
void gtk_item_toggle(GtkItem *i);
int gtk_label_get_type();
GtkWidget *gtk_label_new(char *str);
void gtk_label_set(GtkLabel *l, char *str);
void gtk_label_get(GtkLabel *l, char **outstr);
void gtk_label_set_justify(GtkLabel *l, GtkJustification just);
%{
#define gtk_list_get_selection(l) ((l)->selection)
%}
int gtk_list_get_type();
GtkWidget *gtk_list_new();
GList *gtk_list_get_selection(GtkList *l);
void gtk_list_insert_items(GtkList *l, GList *items, int position);
void gtk_list_append_items(GtkList *l, GList *items);
void gtk_list_prepend_items(GtkList *l, GList *items);
void gtk_list_remove_items(GtkList *l, GList *items);
void gtk_list_clear_items(GtkList *l, int start, int end);
void gtk_list_select_item(GtkList *l, int item);
void gtk_list_unselect_item(GtkList *l, int item);
void gtk_list_select_child(GtkList *l, GtkWidget *child);
void gtk_list_unselect_child(GtkList *l, GtkWidget *child);
int gtk_list_child_position(GtkList *l, GtkWidget *child);
void gtk_list_set_selection_mode(GtkList *l, GtkSelectionMode mode);
void gtk_list_extend_selection(GtkList *list, GtkScrollType st, double pos,
			       int auto_start_sel);
void gtk_list_start_selection(GtkList *list);
void gtk_list_end_selection(GtkList *list);
void gtk_list_select_all(GtkList *list);
void gtk_list_unselect_all(GtkList *list);
void gtk_list_scroll_horizontal(GtkList *list, GtkScrollType st, double pos);
void gtk_list_scroll_vertical(GtkList *list, GtkScrollType st, double pos);
void gtk_list_toggle_add_mode(GtkList *list);
void gtk_list_toggle_focus_row(GtkList *list);
void gtk_list_toggle_row(GtkList *list, GtkWidget *item);
void gtk_list_undo_selection(GtkList *list);
void gtk_list_end_drag_selection(GtkList *list);
int gtk_list_item_get_type();
GtkWidget *gtk_list_item_new();
GtkWidget *gtk_list_item_new_with_label(char *label);
void gtk_list_item_select(GtkListItem *i);
void gtk_list_item_deselect(GtkListItem *i);
int gtk_menu_get_type();
GtkWidget *gtk_menu_new();
void gtk_menu_append(GtkMenu *m, GtkWidget *child);
void gtk_menu_prepend(GtkMenu *m, GtkWidget *child);
void gtk_menu_insert(GtkMenu *m, GtkWidget *child, int pos);
%{
static void PyGtk_MenuPosition(GtkMenu *menu, int *x, int *y, PyObject *func) {
    PyObject *ret;
    ret = PyObject_CallFunction(func, "(O)", PyGtk_New(GTK_OBJECT(menu)));
    if (ret == NULL || !PyArg_ParseTuple(ret, "ii", x, y)) {
        PyErr_Clear();
        fprintf(stderr, "Ignoring Exception\n");
        *x = 0;
        *y = 0;
    } else
        Py_DECREF(ret);
}
static PyObject *gtk__menu_popup(PyObject *self, PyObject *args) {
    PyGtk_Object *m, *pms, *pmi;
    PyObject *func;
    int button, time;
    if (!PyArg_ParseTuple(args, "O!O!O!Oii:gtk_menu_item", PyGtk_Type, &m,
            PyGtk_Type, &pms, PyGtk_Type, &pmi, &func, &button, &time))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "forth argument not callable");
        return NULL;
    }
    Py_INCREF(func);
    gtk_menu_popup(GTK_MENU(PyGtk_Get(m)), GTK_WIDGET(PyGtk_Get(pms)),
        GTK_WIDGET(PyGtk_Get(pmi)), (GtkMenuPositionFunc)PyGtk_MenuPosition,
        func, button, time);
    Py_INCREF(Py_None);
    return Py_None;
}
%}
%native(gtk_menu_popup) PyObject *gtk__menu_popup(PyObject *s,PyObject *args);
void gtk_menu_reposition(GtkMenu *m);
void gtk_menu_popdown(GtkMenu *m);
GtkWidget *gtk_menu_get_active(GtkMenu *m);
void gtk_menu_set_active(GtkMenu *m, int pos);
void gtk_menu_set_accel_group(GtkMenu *m, GtkAccelGroup *group);
GtkWidget *gtk_menu_get_attach_widget(GtkMenu *m);
void gtk_menu_detach(GtkMenu *m);
int gtk_menu_bar_get_type();
GtkWidget *gtk_menu_bar_new();
void gtk_menu_bar_append(GtkMenuBar *m, GtkWidget *child);
void gtk_menu_bar_prepend(GtkMenuBar *m, GtkWidget *child);
void gtk_menu_bar_insert(GtkMenuBar *m, GtkWidget *child, int pos);
int gtk_menu_item_get_type();
GtkWidget *gtk_menu_item_new();
GtkWidget *gtk_menu_item_new_with_label(char *label);
void gtk_menu_item_set_submenu(GtkMenuItem *m, GtkWidget *submenu);
void gtk_menu_item_remove_submenu(GtkMenuItem *m);
void gtk_menu_item_set_placement(GtkMenuItem *m,
				 GtkSubmenuPlacement placement);
void gtk_menu_item_configure(GtkMenuItem *m, int show_toggle, int show_sub);
void gtk_menu_item_select(GtkMenuItem *m);
void gtk_menu_item_deselect(GtkMenuItem *m);
void gtk_menu_item_activate(GtkMenuItem *m);
void gtk_menu_item_right_justify(GtkMenuItem *m);
int gtk_menu_shell_get_type();
void gtk_menu_shell_append(GtkMenuShell *m, GtkWidget *child);
void gtk_menu_shell_prepend(GtkMenuShell *m, GtkWidget *child);
void gtk_menu_shell_insert(GtkMenuShell *m, GtkWidget *child, int pos);
void gtk_menu_shell_deactivate(GtkMenuShell *m);
int gtk_misc_get_type();
void gtk_misc_set_alignment(GtkMisc *m, double xalign, double yalign);
void gtk_misc_set_padding(GtkMisc *m, int xpad, int ypad);
int gtk_notebook_get_type();
GtkWidget *gtk_notebook_new();
void gtk_notebook_append_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab);
void gtk_notebook_append_page_menu(GtkNotebook *n, GtkWidget *c,
	GtkWidget *tab, GtkWidget *menu_label);
void gtk_notebook_prepend_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab);
void gtk_notebook_prepend_page_menu(GtkNotebook *n, GtkWidget *c,
	GtkWidget *tab, GtkWidget *menu_label);
void gtk_notebook_insert_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab,
	int pos);
void gtk_notebook_insert_page_menu(GtkNotebook *n, GtkWidget *c,
	GtkWidget *tab, GtkWidget *menu_label, int pos);
void gtk_notebook_remove_page(GtkNotebook *n, int pos);
int gtk_notebook_current_page(GtkNotebook *n);
void gtk_notebook_set_page(GtkNotebook *n, int pos);
void gtk_notebook_next_page(GtkNotebook *n);
void gtk_notebook_prev_page(GtkNotebook *n);
void gtk_notebook_reorder_child(GtkNotebook *n, GtkWidget *child, int pos);
void gtk_notebook_set_tab_pos(GtkNotebook *n, GtkPositionType pos);
void gtk_notebook_set_show_tabs(GtkNotebook *n, int show);
void gtk_notebook_set_show_border(GtkNotebook *n, int show);
void gtk_notebook_set_scrollable(GtkNotebook *n, int scrollable);
void gtk_notebook_set_tab_border(GtkNotebook *n, int border_width);
void gtk_notebook_popup_enable(GtkNotebook *n);
void gtk_notebook_popup_disable(GtkNotebook *n);
int gtk_option_menu_get_type();
GtkWidget *gtk_option_menu_new();
GtkWidget *gtk_option_menu_get_menu(GtkOptionMenu *o);
void gtk_option_menu_set_menu(GtkOptionMenu *o, GtkWidget *m);
void gtk_option_menu_remove_menu(GtkOptionMenu *o);
void gtk_option_menu_set_history(GtkOptionMenu *o, int index);
int gtk_packer_get_type();
GtkWidget *gtk_packer_new();
void gtk_packer_add_defaults(GtkPacker *packer, GtkWidget *child,
			     GtkSideType side, GtkAnchorType anchor,
			     GtkPackerOptions options);
void gtk_packer_add(GtkPacker *packer, GtkWidget *child, GtkSideType side,
		    GtkAnchorType anchor, GtkPackerOptions options,
		    int border_width, int pad_x, int pad_y,
		    int i_pad_x, int i_pad_y);
void gtk_packer_configure(GtkPacker *packer, GtkWidget *child, GtkSideType s,
			  GtkAnchorType anchor, GtkPackerOptions options,
			  int border_width, int pad_x, int pad_y,
			  int i_pad_x, int i_pad_y);
void gtk_packer_reorder_child(GtkPacker *packer, GtkWidget *child, int pos);
void gtk_packer_set_spacing(GtkPacker *packer, int spacing);
void gtk_packer_set_default_border_width(GtkPacker *packer, int width);
void gtk_packer_set_default_pad(GtkPacker *packer, int pad_x, int pad_y);
void gtk_packer_set_default_ipad(GtkPacker *packer, int i_pad_x, int i_pad_y);
int gtk_paned_get_type();
void gtk_paned_add1(GtkPaned *paned, GtkWidget *child);
void gtk_paned_add2(GtkPaned *paned, GtkWidget *child);
void gtk_paned_handle_size(GtkPaned *paned, int size);
void gtk_paned_gutter_size(GtkPaned *paned, int size);
int gtk_pixmap_get_type();
GtkWidget *gtk_pixmap_new(GdkPixmap *pixmap, GdkBitmap *mask);
void gtk_pixmap_set(GtkPixmap *pixmap, GdkPixmap *val, GdkBitmap *mask);
%{
static PyObject *gtk__pixmap_new_from_xpm(PyObject *self, PyObject *args) {
    PyGtk_Object *win;
    PyGdkColor_Object *tc = NULL;
    char *name;
    GdkColor *bg;
    GdkPixmap *pm;
    GdkBitmap *bm;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s|O!:gtk_pixmap_new_from_xpm", PyGtk_Type,
            &win, &name, PyGdkColor_Type, &tc))
        return  NULL;
    if (tc == NULL)
        bg = NULL;
    else
        bg = PyGdkColor_Get(tc);
    pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(PyGtk_Get(win))->window, &bm,
        bg, name);
    if (pm == NULL) {
      PyErr_SetString(PyExc_IOError, "can't load pixmap");
      return NULL;
    }
    ret = PyGtk_New(GTK_OBJECT(gtk_pixmap_new(pm, bm)));
    /* gtk_pixmap_new ref's the pixmap and mask, so we can unref out vars */
    gdk_pixmap_unref(pm);
    gdk_bitmap_unref(bm);
    return ret;
}
static PyObject *gtk__pixmap_get(PyObject *self, PyObject *args) {
  PyObject *pix;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  if (!PyArg_ParseTuple(args, "O!:gtk_pixmap_get", PyGtk_Type, &pix))
    return NULL;
  gtk_pixmap_get(GTK_PIXMAP(PyGtk_Get(pix)), &pixmap, &mask);
  return Py_BuildValue("(OO)", PyGdkWindow_New(pixmap),
		       PyGdkWindow_New(mask));
}
%}
%native(gtk_pixmap_new_from_xpm) PyObject *gtk__pixmap_new_from_xpm(PyObject
    *self, PyObject *args);
%native(gtk_pixmap_get) PyObject *gtk__pixmap_get(PyObject *self,
						  PyObject *args);
int gtk_preview_get_type();
void gtk_preview_uninit();
GtkWidget *gtk_preview_new(int preview_type);
void gtk_preview_size(GtkPreview *p, int w, int h);
void gtk_preview_put(GtkPreview *p, GdkWindow *win, GdkGC *gc, int sx, int sy,
		     int dx, int dy, int w, int h);
void gtk_preview_draw_row(GtkPreview *p, char *data, int x, int y, int w);
void gtk_preview_set_expand(GtkPreview *p, int expand);
void gtk_preview_set_gamma(double gamma);
void gtk_preview_set_color_cube(unsigned int nred, unsigned int ngreen,
                                unsigned int nblue, unsigned int ngrey);
void gtk_preview_set_install_cmap(int install);
void gtk_preview_set_reserved(int res);
// gtk_preview_get_visual
// gtk_preview_get_cmap
// gtk_preview_get_info
int gtk_progress_get_type();
void gtk_progress_set_show_text(GtkProgress *prog, int show_text);
void gtk_progress_set_text_alignment(GtkProgress *prog, double xalign,
				     double yalign);
void gtk_progress_set_format_string(GtkProgress *prog, char *format);
void gtk_progress_set_adjustment(GtkProgress *prog, GtkAdjustment *adj);
void gtk_progress_reconfigure(GtkProgress *prog, double value, double min,
			      double max);
void gtk_progress_set_percentage(GtkProgress *prog, double pcnt);
void gtk_progress_set_value(GtkProgress *prog, double value);
double gtk_progress_get_value(GtkProgress *prog);
void gtk_progress_set_activity_mode(GtkProgress *prog, int activity_mode);
char *gtk_progress_get_current_text(GtkProgress *progress);
char *gtk_progress_get_text_from_value(GtkProgress *prog, double value);
double gtk_progress_get_current_percentage(GtkProgress *prog);
double gtk_progress_get_percentage_from_value(GtkProgress *prog, double value);
int gtk_progress_bar_get_type();
GtkWidget *gtk_progress_bar_new();
GtkWidget *gtk_progress_bar_new_with_adjustment(GtkAdjustment *adj);
void gtk_progress_bar_set_bar_style(GtkProgressBar *bar,
				    GtkProgressBarStyle style);
void gtk_progress_bar_set_discrete_blocks(GtkProgressBar *bar, int blocks);
void gtk_progress_bar_set_activity_step(GtkProgressBar *bar, int step);
void gtk_progress_bar_set_activity_blocks(GtkProgressBar *bar, int blocks);
void gtk_progress_bar_set_orientation(GtkProgressBar *bar,
				      GtkProgressBarOrientation orient);
void gtk_progress_bar_update(GtkProgressBar *p, double percent);
int gtk_radio_button_get_type();
%typemap(python,in) GSList *nulllist { $target = NULL; }
GtkWidget *gtk_radio_button_new(GSList *nulllist = NULL);
GtkWidget *gtk_radio_button_new_from_widget(GtkRadioButton *group);
GtkWidget *gtk_radio_button_new_with_label(GSList *nulllist,
					   char *label);
GtkWidget *gtk_radio_button_new_with_label_from_widget(GtkRadioButton *group,
						       char *label);
int gtk_radio_menu_item_get_type();
%{
static PyObject *gtk__radio_menu_item_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_menu_item_new",PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new(l)));
}
static PyObject *gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a) {
    PyGtk_Object *g = NULL;
    char *label = "";
    GSList *l = NULL;
    if (!PyArg_ParseTuple(a, "|Os:gtk_radio_menu_item_new_with_label",
            &g, &label))
        return NULL;
    if (g != NULL)
        if (!PyGtk_Check(g) && (PyObject *)g != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "first argument not a GtkObject or None");
            return NULL;
        }
    if ((PyObject *)g == Py_None) g = NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new_with_label(l, label)));
}
%}
%native(gtk_radio_menu_item_new) PyObject *gtk__radio_menu_item_new(PyObject
    *self, PyObject *args);
%native(gtk_radio_menu_item_new_with_label) PyObject *
    gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a);
int gtk_range_get_type();
GtkAdjustment *gtk_range_get_adjustment(GtkRange *r);
void gtk_range_set_update_policy(GtkRange *r, GtkUpdateType update);
void gtk_range_set_adjustment(GtkRange *r, GtkAdjustment *a);
void gtk_range_draw_background(GtkRange *r);
void gtk_range_draw_trough(GtkRange *r);
void gtk_range_draw_slider(GtkRange *r);
void gtk_range_draw_step_forw(GtkRange *r);
void gtk_range_draw_step_back(GtkRange *r);
void gtk_range_slider_update(GtkRange *r);
// These seven should not be available directly -- they are for descendants
//void gtk_range_trough_click(GtkRange *r, int x, int y, double *jump_perc);
//void gtk_range_default_hslider_update(GtkRange *r);
//void gtk_range_default_vslider_update(GtkRange *r);
//void gtk_range_default_htrough_click(GtkRange *r, int x, int y);
//void gtk_range_default_vtrough_click(GtkRange *r, int x, int y);
//void gtk_range_default_hmotion(GtkRange *r, int x, int y);
//void gtk_range_default_vmotion(GtkRange *r, int x, int y);
// This one disapeared with 0.99.5
//double gtk_range_calc_value(GtkRange *r, int pos);
int gtk_ruler_get_type();
void gtk_ruler_set_metric(GtkRuler *r, GtkMetricType metric);
void gtk_ruler_set_range(GtkRuler *r, double lower, double upper, double pos,
                                                             double max_size);
void gtk_ruler_draw_ticks(GtkRuler *r);
void gtk_ruler_draw_pos(GtkRuler *r);
int gtk_scale_get_type();
void gtk_scale_set_digits(GtkScale *s, int digits);
void gtk_scale_set_draw_value(GtkScale *s, int value);
void gtk_scale_set_value_pos(GtkScale *s, int pos);
int gtk_scale_value_width(GtkScale *s);
void gtk_scale_draw_value(GtkScale *s);
int gtk_scrollbar_get_type();
int gtk_scrolled_window_get_type();
GtkWidget *gtk_scrolled_window_new(GtkAdjustment *h = NULL, GtkAdjustment *v = NULL);
GtkAdjustment *gtk_scrolled_window_get_hadjustment(GtkScrolledWindow *s);
GtkAdjustment *gtk_scrolled_window_get_vadjustment(GtkScrolledWindow *s);
void gtk_scrolled_window_set_policy(GtkScrolledWindow *s, GtkPolicyType hp,
				    GtkPolicyType vp);
int gtk_separator_get_type();
int gtk_spin_button_get_type();
%{
#define gtk_spin_button_new_no_adj(c,d) gtk_spin_button_new(NULL,c,d)
%}
GtkWidget *gtk_spin_button_new(GtkAdjustment *a, double climb, int digits);
GtkWidget *gtk_spin_button_new_no_adj(double climb, int digits);
void gtk_spin_button_set_adjustment(GtkSpinButton *s, GtkAdjustment *a);
GtkAdjustment *gtk_spin_button_get_adjustment(GtkSpinButton *s);
void gtk_spin_button_set_digits(GtkSpinButton *s, int digits);
double gtk_spin_button_get_value_as_float(GtkSpinButton *s);
int gtk_spin_button_get_value_as_int(GtkSpinButton *s);
void gtk_spin_button_set_value(GtkSpinButton *s, double value);
void gtk_spin_button_set_update_policy(GtkSpinButton *s,
				       GtkSpinButtonUpdatePolicy policy);
void gtk_spin_button_set_numeric(GtkSpinButton *s, int numeric);
void gtk_spin_button_spin(GtkSpinButton *s, int direction, double step);
void gtk_spin_button_set_wrap(GtkSpinButton *s, int wrap);
void gtk_spin_button_set_shadow_type(GtkSpinButton *s, GtkShadowType type);
void gtk_spin_button_set_snap_to_ticks(GtkSpinButton *s, int snap);
int gtk_statusbar_get_type();
GtkWidget *gtk_statusbar_new();
int gtk_statusbar_get_context_id(GtkStatusbar *s, char *context_description);
int gtk_statusbar_push(GtkStatusbar *s, int statusid, char *text);
void gtk_statusbar_pop(GtkStatusbar *s, int statusid);
void gtk_statusbar_remove(GtkStatusbar *s, int context_id, int message_id);
int gtk_table_get_type();
GtkWidget *gtk_table_new(int rows, int cols, int homogeneous);
void gtk_table_attach(GtkTable *t, GtkWidget *child, int la, int ra, int ta,
		      int ba, GtkAttachOptions xo, GtkAttachOptions yo,
		      int xp, int yp);
void gtk_table_attach_defaults(GtkTable *t, GtkWidget *child, int la, int ra,
                                                              int ta, int ba);
void gtk_table_set_row_spacing(GtkTable *t, int row, int spacing);
void gtk_table_set_col_spacing(GtkTable *t, int col, int spacing);
void gtk_table_set_row_spacings(GtkTable *t, int spacing);
void gtk_table_set_col_spacings(GtkTable *t, int spacing);
void gtk_table_set_homogeneous(GtkTable *t, int homogeneous);
%{
#define gtk_text_get_hadjustment(t) ((t)->hadj)
#define gtk_text_get_vadjustment(t) ((t)->vadj)
%}
int gtk_text_get_type();
GtkWidget *gtk_text_new(GtkAdjustment *ha = NULL, GtkAdjustment *va = NULL);
void gtk_text_set_editable(GtkText *t, int editable);
void gtk_text_set_word_wrap(GtkText *t, int word_wrap);
void gtk_text_set_adjustments(GtkText *t, GtkAdjustment *ha,GtkAdjustment *va);
GtkAdjustment *gtk_text_get_hadjustment(GtkText *t);
GtkAdjustment *gtk_text_get_vadjustment(GtkText *t);
void gtk_text_set_point(GtkText *t, unsigned int index);
unsigned int gtk_text_get_point(GtkText *t);
unsigned int gtk_text_get_length(GtkText *t);
void gtk_text_freeze(GtkText *t);
void gtk_text_thaw(GtkText *t);
void gtk_text_insert(GtkText *t, GdkFont *f, GdkColor *fore, GdkColor *back, char *chars, int length);
int gtk_text_backward_delete(GtkText *t, unsigned int nchars);
int gtk_text_forward_delete(GtkText *t, unsigned int nchars);
%{
static PyObject *gtk__text_insert_defaults(PyObject *self, PyObject *args) {
    PyGtk_Object *txt;
    char *chars;
    int l;
    GtkStyle *style;
    if (!PyArg_ParseTuple(args, "O!s#:gtk_text_insert_defaults", PyGtk_Type,
                                     &txt, &chars, &l))
        return NULL;
    style = gtk_widget_get_style(GTK_WIDGET(PyGtk_Get(txt)));
    gtk_text_insert(GTK_TEXT(PyGtk_Get(txt)), NULL,
        &style->fg[GTK_STATE_NORMAL], NULL, chars, l);
    Py_INCREF(Py_None);
    return Py_None;
}
%}
%native(gtk_text_insert_defaults) PyObject *gtk__text_insert_defaults(
                                           PyObject *self, PyObjject *args);
int gtk_tips_query_get_type();
GtkWidget *gtk_tips_query_new();
void gtk_tips_query_start_query(GtkTipsQuery *tq);
void gtk_tips_query_stop_query(GtkTipsQuery *qt);
void gtk_tips_query_set_caller(GtkTipsQuery *qt, GtkWidget *w);
void gtk_tips_query_set_labels(GtkTipsQuery *qt, char *inactive, char *no_tip);
%{
#define gtk_toggle_button_get_active(tb) ((tb)->active)
%}
int gtk_toggle_button_get_type();
GtkWidget *gtk_toggle_button_new();
GtkWidget *gtk_toggle_button_new_with_label(char *label);
void gtk_toggle_button_set_mode(GtkToggleButton *t, int draw_i);
void gtk_toggle_button_set_state(GtkToggleButton *t, int s);
void gtk_toggle_button_toggled(GtkToggleButton *t);
int gtk_toggle_button_get_active(GtkToggleButton *t);
int gtk_toolbar_get_type();
GtkWidget *gtk_toolbar_new(int orientation, int style);
%{
static PyObject *gtk__toolbar_append_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_append_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
                        PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
        /* if you set sigfunc to NULL, no signal is connected, rather than
           the default signal handler being used */
	gtk_toolbar_append_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None) {
		tmp_list = g_list_last(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))));
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_prepend_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_prepend_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
			PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_prepend_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None)
		gtk_signal_connect(GTK_OBJECT(gtk_container_children(
			GTK_CONTAINER(PyGtk_Get(t)))->data), "clicked", NULL,
			callback);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_insert_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	int pos;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!Oi|gtk_toolbar_insert_item",
			PyGtk_Type, &t, &text, &tooltip, &tip_private,
			PyGtk_Type, &icon, &callback, &pos))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_insert_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL, pos);
	if (callback != Py_None) {
		tmp_list = g_list_nth(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))), pos);
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}
%}
%native(gtk_toolbar_append_item) PyObject *gtk__toolbar_append_item(
	PyObject *self, PyObject *args);
%native(gtk_toolbar_prepend_item) PyObject *gtk__toolbar_prepend_item(
	PyObject *self, PyObject *args);
%native(gtk_toolbar_insert_item) PyObject *gtk__toolbar_insert_item(
	PyObject *self, PyObject *args);
void gtk_toolbar_append_space(GtkToolbar *t);
void gtk_toolbar_prepend_space(GtkToolbar *t);
void gtk_toolbar_insert_space(GtkToolbar *t, int pos);
void gtk_toolbar_append_widget(GtkToolbar *t, GtkWidget *w, char *tooltip,
	char *tip_private);
void gtk_toolbar_prepend_widget(GtkToolbar *t, GtkWidget *w, char *tooltip,
	char *tip_private);
void gtk_toolbar_insert_widget(GtkToolbar *t, GtkWidget *w, char *tooltip,
	char *tip_private, int pos);
void gtk_toolbar_set_orientation(GtkToolbar *t, GtkOrientation orientation);
void gtk_toolbar_set_style(GtkToolbar *t, GtkToolbarStyle style);
void gtk_toolbar_set_space_size(GtkToolbar *t, int size);
void gtk_toolbar_set_tooltips(GtkToolbar *t, int enable);
void gtk_toolbar_set_button_relief(GtkToolbar *t, GtkReliefStyle relief);
GtkReliefStyle gtk_toolbar_get_button_relief(GtkToolbar *t);
%{
#define gtk_tree_get_selection(t) ((t)->selection)
%}
int gtk_tree_get_type();
GtkWidget *gtk_tree_new();
GList *gtk_tree_get_selection(GtkTree *t);
void gtk_tree_append(GtkTree *t, GtkWidget *child);
void gtk_tree_prepend(GtkTree *t, GtkWidget *child);
void gtk_tree_insert(GtkTree *t, GtkWidget *child, int pos);
// void gtk_tree_remove_item(GtkTree *t, GtkWidget *child);
void gtk_tree_remove_items(GtkTree *t, GList *items);
void gtk_tree_clear_items(GtkTree *t, int start, int end);
void gtk_tree_select_item(GtkTree *t, int item);
void gtk_tree_unselect_item(GtkTree *t, int item);
void gtk_tree_select_child(GtkTree *t, GtkWidget *c);
void gtk_tree_unselect_child(GtkTree *t, GtkWidget *c);
int gtk_tree_child_position(GtkTree *t, GtkWidget *c);
void gtk_tree_set_selection_mode(GtkTree *t, GtkSelectionMode mode);
void gtk_tree_set_view_mode(GtkTree *t, GtkTreeViewMode mode);
void gtk_tree_set_view_lines(GtkTree *t, int flag);
int gtk_tree_item_get_type();
GtkWidget *gtk_tree_item_new();
GtkWidget *gtk_tree_item_new_with_label(char *label);
void gtk_tree_item_set_subtree(GtkTreeItem *t, GtkWidget *st);
void gtk_tree_item_select(GtkTreeItem *t);
void gtk_tree_item_deselect(GtkTreeItem *t);
void gtk_tree_item_expand(GtkTreeItem *t);
void gtk_tree_item_collapse(GtkTreeItem *t);
void gtk_tree_item_remove_subtree(GtkTreeItem *t);
int gtk_vbox_get_type();
GtkWidget *gtk_vbox_new(int homogeneous, int spacing);
int gtk_vbutton_box_get_type();
GtkWidget *gtk_vbutton_box_new();
int gtk_vbutton_box_get_spacing_default();
void gtk_vbutton_box_set_spacing_default(int s);
GtkButtonBoxStyle gtk_vbutton_box_get_layout_default();
void gtk_vbutton_box_set_layout_default(GtkButtonBoxStyle l);
int gtk_viewport_get_type();
GtkWidget *gtk_viewport_new(GtkAdjustment *ha = NULL, GtkAdjustment *va=NULL);
GtkAdjustment *gtk_viewport_get_hadjustment(GtkViewport *v);
GtkAdjustment *gtk_viewport_get_vadjustment(GtkViewport *v);
void gtk_viewport_set_hadjustment(GtkViewport *v, GtkAdjustment *ha);
void gtk_viewport_set_vadjustment(GtkViewport *v, GtkAdjustment *va);
void gtk_viewport_set_shadow_type(GtkViewport *v, GtkShadowType st);
int gtk_vpaned_get_type();
GtkWidget *gtk_vpaned_new();
int gtk_vruler_get_type();
GtkWidget *gtk_vruler_new();
int gtk_vscale_get_type();
GtkWidget *gtk_vscale_new(GtkAdjustment *a = NULL);
int gtk_vscrollbar_get_type();
GtkWidget *gtk_vscrollbar_new(GtkAdjustment *a = NULL);
int gtk_vseparator_get_type();
GtkWidget *gtk_vseparator_new();

// GtkTooltips Functions
int gtk_tooltips_get_type();
GtkTooltips *gtk_tooltips_new();
void gtk_tooltips_enable(GtkTooltips *t);
void gtk_tooltips_disable(GtkTooltips *t);
void gtk_tooltips_set_delay(GtkTooltips *t, int delay);
void gtk_tooltips_set_tip(GtkTooltips *t, GtkWidget *w, char *tip, char *tip_p);
void gtk_tooltips_set_colors(GtkTooltips *t, GdkColor *b, GdkColor *f);


