/* GLE - The GTK+ Layout Editor
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"gleargs.h"
#include	<stdio.h>


/* --- functions --- */
void
gle_arg_set_from_string (GtkArg         *arg,
			 const gchar    *value_string)
{
  gchar *string;

  g_return_if_fail (arg != NULL);
  g_return_if_fail (value_string != NULL);

  string = g_strdup (value_string);

  switch (arg->type)
    {
    case  GTK_TYPE_INVALID:
      g_warning ("gle_arg_set_from_string() used with invalid type");
      break;
    case  GTK_TYPE_CHAR:
      if (strlen (string) > 1)
	{
	  arg->d.int_data = 0;
	  sscanf (string, "%d", &arg->d.int_data);
	  arg->d.char_data = arg->d.int_data;
	}
      else
	arg->d.char_data = string[0];
      break;
    case  GTK_TYPE_BOOL:
      g_strdown (string);
      if ((string[0] > '0' && string[0] <= '9') ||
	  g_str_equal (string, "true") ||
	  g_str_equal (string, "yes"))
	arg->d.bool_data = TRUE;
      else
	arg->d.bool_data = FALSE;
      break;
    case  GTK_TYPE_INT:
      arg->d.int_data = 0;
      sscanf (string, "%d", &arg->d.int_data);
      break;
    case  GTK_TYPE_UINT:
      arg->d.uint_data = 0;
      sscanf (string, "%u", &arg->d.int_data);
      break;
    case  GTK_TYPE_LONG:
      arg->d.long_data = 0;
      sscanf (string, "%ld", &arg->d.long_data);
      break;
    case  GTK_TYPE_ULONG:
      arg->d.ulong_data = 0;
      sscanf (string, "%lu", &arg->d.ulong_data);
      break;
    case  GTK_TYPE_FLOAT:
      arg->d.float_data = 0;
      sscanf (string, "%f", &arg->d.float_data);
      break;
    case  GTK_TYPE_DOUBLE:
      arg->d.double_data = 0;
      sscanf (string, "%lf", &arg->d.double_data);
      break;
    case  GTK_TYPE_STRING:
      arg->d.string_data = g_strdup (value_string);
      break;
    default:
      g_warning ("gle_arg_set_from_string() used with type <%s>", gtk_type_name (arg->type));
      break;
    }
  g_free (string);
}
