/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_GCONTAINER_H__
#define __GLE_GCONTAINER_H__


#include	<gle/glegwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- GleGWidget flags --- */
typedef enum
{
  GLE_CTEST_FLAG	 = 1 << (GLE_GWIDGET_FLAGS_NEXT_SHIFT)
} GleGContainerFlags;


/* --- GContainer macros --- */
#define GLE_TYPE_GCONTAINER		(gle_gcontainer_get_type ())
#define GLE_GCONTAINER(gc)		(GTK_CHECK_CAST ((gc), GLE_TYPE_GCONTAINER, GleGContainer))
#define GLE_GCONTAINER_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_GCONTAINER, GleGContainerClass))
#define GLE_IS_GCONTAINER(gc)		(GTK_CHECK_TYPE ((gc), GLE_TYPE_GCONTAINER))
#define GLE_IS_GCONTAINER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_GCONTAINER))
#define GLE_GCONTAINER_GET_CLASS(gc)	(GLE_GCONTAINER_CLASS (GLE_GOBJECT (gc)->type_object.klass))

#define	GLE_GCONTAINER_CONTAINER(gw)	((GtkContainer*) GLE_GOBJECT (gw)->object)


/* --- typedefs --- */
typedef struct	_GleGContainer		GleGContainer;
typedef struct	_GleGContainerClass	GleGContainerClass;


/* --- structures --- */
struct _GleGContainer
{
  GleGWidget	gwidget;

  GList		*children;
  GList		*internal_children;
};
struct _GleGContainerClass
{
  GleGWidgetClass	gwidget_class;

  /* notify methods
   */
  void  (*add_child)	(GleGContainer	*gcontainer,
			 GleGWidget	*gchild);
  void  (*remove_child)	(GleGContainer	*gcontainer,
			 GleGWidget	*gchild);
};


/* --- GleGContainer methods --- */
GtkType		gle_gcontainer_get_type		(void) G_GNUC_CONST;
void		gle_gcontainer_add_child	(GleGContainer	*gcontainer,
						 GleGWidget	*gchild);
void		gle_gcontainer_remove_child	(GleGContainer	*gcontainer,
						 GleGWidget	*gchild);
void		gle_gcontainer_force_gchildren	(GleGContainer	*gcontainer);
GtkWidget*	gle_gcontainer_find_composite	(GleGContainer	*gcontainer,
						 const gchar	*name);

/* --- internal macros --- */
#define GLE_GCONTAINER_NOTIFY( gcontainer, method ) \
    _GLE_NOTIFY ((gcontainer), GleGContainerClass, method)






#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLE_GCONTAINER_H__ */
