/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998, 1999 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __GLE_GOBJECT_H__
#define __GLE_GOBJECT_H__


#include	<gle/glegarg.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* --- enumerations/flags --- */
typedef enum
{
  GLE_GENERIC_GNAME		= 1 << 0,
  GLE_GOBJECT_DESTROYED		= 1 << 1,
  GLE_GOBJECT_SHELL_OWNED	= 1 << 2,
#define	GLE_GOBJECT_FLAGS_NEXT_SHIFT	(3)
} GleGObjectFlags;
typedef enum
{
  GLE_QUEUE_UPDATE_ARGS	 = 1 << 0,
  GLE_QUEUE_SAVE_ARGS	 = 1 << 1,
  GLE_QUEUE_APPLY_ARGS	 = 1 << 2,
} GleQueueFlags;


/* --- GObject macros --- */
#define GLE_TYPE_GOBJECT		 (gle_gobject_get_type ())
#define GLE_GOBJECT(go)			 (GTK_CHECK_CAST ((go), GLE_TYPE_GOBJECT, GleGObject))
#define GLE_GOBJECT_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GLE_TYPE_GOBJECT, GleGObjectClass))
#define GLE_IS_GOBJECT(go)		 (GTK_CHECK_TYPE ((go), GLE_TYPE_GOBJECT))
#define GLE_IS_GOBJECT_CLASS(klass)	 (GTK_CHECK_CLASS_TYPE ((klass), GLE_TYPE_GOBJECT))
#define	GLE_GOBJECT_GET_CLASS(go)	 (GLE_GOBJECT_CLASS (GLE_GOBJECT (go)->type_object.klass))

#define	GLE_GOBJECT_PROXY_TYPE(go)	 (((GtkTypeObject*) (go))->klass->type)
#define	GLE_GOBJECT_OTYPE(go)		 (GLE_GOBJECT (go)->object_type)
#define	GLE_GOBJECT_IS_INSTANTIATED(go)	 (GLE_GOBJECT(go)->object!=NULL)
#define	GLE_GOBJECT_FLAGS(go)		 (GLE_GOBJECT (go)->flags)
#define	GLE_GOBJECT_SET_FLAG(go,f)	 (GLE_GOBJECT_FLAGS (go) |= (f))
#define	GLE_GOBJECT_UNSET_FLAG(go,f)	 (GLE_GOBJECT_FLAGS (go) &= ~(f))
#define	GLE_GOBJECT_GENERIC_GNAME(go)	 ((GLE_GOBJECT_FLAGS (go) & GLE_GENERIC_GNAME) != 0)
#define GLE_GOBJECT_OBJECT(go)		 (GLE_GOBJECT((go))->object)
#define GLE_GOBJECT_DESTROYED(go)	 ((GLE_GOBJECT_FLAGS (go) & GLE_GOBJECT_DESTROYED) != 0)
#define GLE_GOBJECT_SHELL_OWNED(go)	 ((GLE_GOBJECT_FLAGS (go) & GLE_GOBJECT_SHELL_OWNED) != 0)


/* --- GtkObject macros --- */
#define	GLE_OBJECT_HAS_GOBJECT(object)	 (gle_object_get_gobject (GTK_OBJECT (object)) != NULL)
#define	GLE_OBJECT_HAS_GNAME(object)	 (gle_object_get_glename (GTK_OBJECT (object)) != NULL)


/* --- typedefs --- */
typedef struct  _GleGObject             GleGObject;
typedef struct	_GleGObjectClass	GleGObjectClass;
typedef struct	_GleGArgGroup		GleGArgGroup;
typedef struct  _GleConnection          GleConnection;


/* --- GObject callbacks --- */
typedef struct	_GleCbNode		GleCbNode;
typedef	void			(*GleFunc)		();
typedef	void			(*GleNotifyFunc_go_d)	(GleGObject	*gobject,
							 gpointer	 cb_data,
							 gpointer	 arg1,
							 gpointer	 arg2);
typedef	void			(*GleNotifyFunc_d_go)	(gpointer	 cb_data,
							 GleGObject	*gobject,
							 gpointer	 arg1,
							 gpointer	 arg2);
typedef enum
{
  GLE_NOTIFY_GO_D	= 1,
  GLE_NOTIFY_D_GO
} GleNotifyType;
typedef enum
{
  GLE_NOTIFY_METHOD_MASK	= 1 << 0,
  GLE_NOTIFY_FUNC_MASK		= 1 << 1,
  GLE_NOTIFY_DATA_MASK		= 1 << 2,
  GLE_NOTIFY_MASK		= 0x7f
} GleNotifyMask;


/* --- structures --- */
struct _GleGObject
{
  GtkTypeObject	 type_object;
  
  GtkType	 object_type;
  
  guint		 iref_count : 20;
  guint		 flags : 8;
  guint		 queue_flags : 4;
  
  gchar		*gname;
  
  GData		*datalist;
  
  GtkObject	*object;
  
  guint		 n_garg_groups;
  GleGArgGroup  *garg_groups;	/* relocatable! */
  
  GleConnection *connections;
};
struct _GleGObjectClass
{
  GtkTypeClass		type_class;

  GQuark		*method_ids;
  guint			 n_method_ids;

  GSList		*banned_args;
  
  /* private methods
   */
  void	(*initialize)		(GleGObject	*gobject);
  void	(*instantiate)		(GleGObject	*gobject);
  void	(*foreign_associated)	(GleGObject	*gobject);

  /* notify methods
   * (notification always happens after the class method's invokation,
   *  except for pre_* methods)
   */
  void	(*pre_destroy)		(GleGObject	*gobject);
  void	(*associate)		(GleGObject	*gobject,
				 GtkObject	*object);
  void	(*pre_disassociate)	(GleGObject	*gobject);
  void	(*disassociate)		(GleGObject	*gobject);
  void	(*apply_all_args)	(GleGObject	*gobject);
  void	(*reset_all_args)	(GleGObject	*gobject);
  void	(*restore_all_args)	(GleGObject	*gobject);
  void	(*save_all_args)	(GleGObject	*gobject);
  void	(*update_all_args)	(GleGObject	*gobject);
  void	(*check_args)		(GleGObject	*gobject);
  void	(*rebuilt_args)		(GleGObject	*gobject);
  void	(*set_gname)		(GleGObject	*gobject,
				 const gchar	*gname);
};
struct _GleGArgGroup
{
  GQuark	 garg_group;
  GtkType	 proxy_type;
  GSList	*gargs;
};


/* --- GtkObject prototypes --- */
GleGObject*	gle_object_get_gobject		(GtkObject	*object);
GleGObject*	gle_object_force_gobject	(GtkObject	*object);
gchar*		gle_object_get_gname		(GtkObject	*object);
GtkObject*	gle_object_from_gname		(const gchar	*gname);


/* --- GleGObject methods --- */
GtkType		gle_gobject_get_type		(void) G_GNUC_CONST;
GleGObject*	gle_gobject_new			(GtkType	 gtk_type);
void		gle_gobject_destroy		(GleGObject	*gobject);
void		gle_gobject_set_gname		(GleGObject	*gobject,
						 const gchar	*gname);
void		gle_gobject_apply_object_args	(GleGObject	*gobject);
void		gle_gobject_apply_construct_args(GleGObject	*gobject);
void		gle_gobject_reset_object_args	(GleGObject	*gobject);
void		gle_gobject_restore_object_args	(GleGObject	*gobject);
void		gle_gobject_save_object_args	(GleGObject	*gobject);
void		gle_gobject_update_object_args	(GleGObject	*gobject);
void		gle_gobject_apply_all_args	(GleGObject	*gobject);
void		gle_gobject_reset_all_args	(GleGObject	*gobject);
void		gle_gobject_restore_all_args	(GleGObject	*gobject);
void		gle_gobject_save_all_args	(GleGObject	*gobject);
void		gle_gobject_update_all_args	(GleGObject	*gobject);
void		gle_gobject_connect		(GleGObject	*gobject);
void		gle_gobject_disconnect		(GleGObject	*gobject);
void		gle_gobject_queue		(GleGObject	*gobject,
						 GleQueueFlags	 flags);
GSList*		gle_gobject_get_gargs		(GleGObject	*gobject,
						 GQuark		 garg_group);
GleGArg*	gle_gobject_get_object_garg	(GleGObject	*gobject,
						 const gchar	*arg_name);
void		gle_gobject_set_qdata		(GleGObject	*gobject,
						 GQuark		 id,
						 gpointer	 data);
void		gle_gobject_set_qdata_full	(GleGObject	*gobject,
						 GQuark		 id,
						 gpointer	 data,
						 GDestroyNotify  destroy);
gpointer	gle_gobject_get_qdata		(GleGObject	*gobject,
						 GQuark		 id);
#define		gle_gobject_remove_data(go, id)	\
    gle_gobject_set_qdata ((go), (id), NULL)


/* --- GLE names --- */
GleGObject*	gle_gname_lookup		(const gchar	*gname);
gchar*		gle_gname_new			(GtkType	 gtk_type);
void		gle_gname_free			(gchar		*gname);
gchar*		gle_gname_canonicalize		(gchar		*gname);


/* --- notifiers --- */
#define	GLE_NOTIFIER_INSTALL( gobject, method, func, data ) \
    gle_gobject_notify_add (GLE_GOBJECT (gobject), \
                            (method), \
                            GLE_NOTIFY_GO_D, \
                            (func), \
                            (data))
#define	GLE_NOTIFIER_INSTALL_DATA( gobject, method, func, data ) \
    gle_gobject_notify_add (GLE_GOBJECT (gobject), \
                            (method), \
                            GLE_NOTIFY_D_GO, \
                            (func), \
                            (data))
#define	GLE_NOTIFIER_REMOVE_MF( gobject, method, func ) \
    gle_gobject_notify_del (GLE_GOBJECT (gobject), \
                            (method), \
                            GLE_NOTIFY_METHOD_MASK | GLE_NOTIFY_FUNC_MASK, \
			    (func), NULL)
#define	GLE_NOTIFIER_REMOVE_MFD( gobject, method, func, data ) \
    gle_gobject_notify_del (GLE_GOBJECT (gobject), \
                            (method), \
                            GLE_NOTIFY_METHOD_MASK | GLE_NOTIFY_FUNC_MASK | GLE_NOTIFY_DATA_MASK, \
			    (func), (data))
#define	GLE_NOTIFIER_REMOVE_F( gobject, func ) \
    gle_gobject_notify_del (GLE_GOBJECT (gobject), \
                            NULL, \
                            GLE_NOTIFY_FUNC_MASK, \
			    (func), NULL)
#define	GLE_NOTIFIER_REMOVE_FD( gobject, func, data ) \
    gle_gobject_notify_del (GLE_GOBJECT (gobject), \
                            NULL, \
                            GLE_NOTIFY_FUNC_MASK | GLE_NOTIFY_DATA_MASK, \
			    (func), (data))
#define	GLE_NOTIFIER_CHECK_MF( gobject, method, func ) \
    gle_gobject_notify_check (GLE_GOBJECT (gobject), \
                              (method), \
                              GLE_NOTIFY_METHOD_MASK | GLE_NOTIFY_FUNC_MASK, \
			      (func), NULL)
#define	GLE_NOTIFIER_CHECK_MFD( gobject, method, func, data ) \
    gle_gobject_notify_check (GLE_GOBJECT (gobject), \
                              (method), \
                              GLE_NOTIFY_METHOD_MASK | GLE_NOTIFY_FUNC_MASK | GLE_NOTIFY_DATA_MASK, \
			      (func), (data))
#define	GLE_NOTIFIER_CHECK_F( gobject, func ) \
    gle_gobject_notify_check (GLE_GOBJECT (gobject), NULL, \
                              GLE_NOTIFY_FUNC_MASK, \
			      (func), NULL)
#define	GLE_NOTIFIER_CHECK_FD( gobject, func, data ) \
    gle_gobject_notify_check (GLE_GOBJECT (gobject), NULL, \
                              GLE_NOTIFY_FUNC_MASK | GLE_NOTIFY_DATA_MASK, \
			      (func), (data))


/* --- internal prototypes --- */
void		gle_gobject_notify_add		(GleGObject	*gobject,
						 const gchar	*method,
						 GleNotifyType	 notify_type,
						 GleFunc	 func,
						 gpointer	 data);
void		gle_gobject_notify_del		(GleGObject	*gobject,
						 const gchar	*method,
						 GleNotifyMask	 mask,
						 GleFunc	 func,
						 gpointer	 data);
void		gle_gobject_notify_do		(GleGObject	*gobject,
						 GQuark		 method_id,
						 gpointer	 arg1,
						 gpointer	 arg2);
gboolean	gle_gobject_notify_check	(GleGObject	*gobject,
						 const gchar	*method,
						 GleNotifyMask	 mask,
						 GleFunc	 func,
						 gpointer	 data);
void		gle_class_add_notify_method	(GleGObjectClass*klass,
						 const gchar	*method_name,
						 guint		 method_offs);
GQuark		gle_class_find_notify_method	(GleGObjectClass*klass,
						 const gchar	*method_name);
void		gle_gobject_ref			(GleGObject	*gobject);
void		gle_gobject_unref		(GleGObject	*gobject);
GSList*		gle_gobjects_list		(void);
void		gle_gobject_rebuilt_args	(GleGObject	*gobject);
void		gle_gobject_check_args		(GleGObject	*gobject);
void		gle_gobject_instantiate		(GleGObject	*gobject);
void		gle_gobject_associate		(GleGObject	*gobject,
						 GtkObject	*object);
void		gle_gobject_disassociate	(GleGObject	*gobject);
void		gle_gobject_add_garg_group	(GleGObject	*gobject,
						 GQuark		 garg_group,
						 GtkType	 proxy_type,
						 GSList		*gargs);
void		gle_gobject_set_garg_group	(GleGObject	*gobject,
						 GQuark		 garg_group,
						 GSList		*gargs);
gboolean	gle_class_arg_info_banned	(GleGObjectClass*class,
						 const GleArgInfo*arg_info);
     

/* --- internal macros --- */
#define	GLE_GOBJECT_NOTIFY( gobject, method, arg1, arg2 ) \
    gle_gobject_notify_do (GLE_GOBJECT (gobject), \
                           gle_class_find_notify_method (GLE_GOBJECT_GET_CLASS (gobject), \
                                                         # method), \
                           (arg1), (arg2))
#define GLE_CLASS_ADD_NOTIFY_METHOD( class, class_type, method)	\
    gle_class_add_notify_method (GLE_GOBJECT_CLASS (class), \
                                 # method, \
                                 ((guint) ((gchar*) &((class_type *) 0) -> method)))








#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GLE_GOBJECT_H__ */
