/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"RCS.h"
RCS_ID("$Id: browser.c,v 1.7 1997/05/09 16:17:57 tim Exp $")


#define		__browser_c__

#include	"browser.h"
#include	"treelist.h"
#include	"editor.h"
#include	"widgets.h"
#include	"windows.h"
#include	"widdata.h"
#include	"structures.h"
#include	"misc.h"
#include	"defines.h"
#include	"config.h"



/* --- structures --- */
typedef	struct	listwid_widget_list_S	listwid_widget_list_S;
struct	listwid_widget_list_S {
	gb_wdat_base_S	*widget_data;
	GtkWidget	*Label_symbol_name;
	GtkWidget	*Label_parent_name;
	GtkWidget	*Box_selected;
	GtkWidget	*List;
	GtkWidget	*Button_Add;
	GtkWidget	*Button_Delete;
	GtkWidget	*Button_Edit;
	GtkWidget	*Button_List;
};



/* --- prototypes --- */
static	void	SigH_Browser_List_selection_changed	(GtkList	*widget,
							 gpointer	func_data);
static	void	SigH_Browser_Add_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_Browser_Edit_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_Browser_List_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_Browser_Delete_clicked	(GtkWidget	*widget,
						 gpointer	func_data);
static	void	SigH_Delete_widget_real		(GtkWidget	*widget,
						 gpointer	 func_data);



/* --- variables --- */
static	gboolean	ignore_selection_events=FALSE;



/* --- functions --- */
void
Browser_create	(gb_wdat_base_S	*WidDat)
{
	if (!GUBI_DATA(WidDat)->browser) {
		register listwid_widget_list_S	*widget_list;
		

		/* clone window
		*/
		gb_widget_data_clone(GB_wCAST(base, Browser_Window));
		
		
		/* initialize widgets
		*/
		GB_wCAST(label, Browser_Label_symbol_name->clone)->label=
			(gchar*)widget_data_symbol_name_get(WidDat);
		
		
		/* build window
		*/
		gb_window_build(GB_wCAST(window, Browser_Window->clone));
		
		
		/* set GtkWindow* in the browser field and reset to NULL
		 * if the window is destroyed
		*/
		GUBI_DATA(WidDat)->browser=Browser_Window->clone->widget;
		GB_NULLIFY_ON_DESTROY(Browser_Window->clone->widget,
				      &GUBI_DATA(WidDat)->browser);
		
		
		/* we set user_data of the browser window and the browser
		 * list to our widget_list structure, which will be freed
		 * if the window is destroyed
		*/
		widget_list=g_new(listwid_widget_list_S, 1);
		widget_list->widget_data=WidDat;
		widget_list->Label_symbol_name=Browser_Label_symbol_name->clone->widget;
		widget_list->Label_parent_name=Browser_Label_parent_name->clone->widget;
		widget_list->Box_selected=Browser_Box_Selected->clone->widget;
		widget_list->List=Browser_List->clone->widget;
		widget_list->Button_Add=Browser_Button_Add->clone->widget;
		widget_list->Button_Delete=Browser_Button_Delete->clone->widget;
		widget_list->Button_Edit=Browser_Button_Edit->clone->widget;
		widget_list->Button_List=Browser_Button_List->clone->widget;
		GB_GFREE_ON_DESTROY(Browser_Window->clone->widget, widget_list);
		gtk_object_set_user_data(GTK_OBJECT(Browser_Window->clone->widget),
					 widget_list);
		
		
		/* track selection_changed on single lists
		 * and connect SigH to buttons
		*/
		gtk_signal_connect(GTK_OBJECT(widget_list->List),
				   "selection_changed",
				   GTK_SIGNAL_FUNC(SigH_Browser_List_selection_changed),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(widget_list->Button_Add),
				   "clicked",
				   GTK_SIGNAL_FUNC(SigH_Browser_Add_clicked),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(widget_list->Button_Delete),
				   "clicked",
				   GTK_SIGNAL_FUNC(SigH_Browser_Delete_clicked),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(widget_list->Button_Edit),
				   "clicked",
				   GTK_SIGNAL_FUNC(SigH_Browser_Edit_clicked),
				   NULL);
		gtk_signal_connect(GTK_OBJECT(widget_list->Button_List),
				   "clicked",
				   GTK_SIGNAL_FUNC(SigH_Browser_List_clicked),
				   NULL);
		gtk_signal_connect_object(GTK_OBJECT(Browser_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(Browser_Window->clone->widget));
	
	
		/* show window
		*/
		gtk_widget_show(Browser_Window->clone->widget);
		
		
		/* build up contents
		*/
		Browser_refresh(WidDat, FALSE);
	} else
		_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
}


void
Browser_refresh		(gb_wdat_base_S	*WidDat,
			 guint		selection_only)
{
	register listwid_widget_list_S	*widget_list;
	register GtkWidget		*List;
	register tree_S			*tree;
	gchar				*old_label;
	
	g_assert(GB_IS_WIDGET(WidDat));
	
	g_assert(GUBI_DATA(WidDat)->browser);
	widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(WidDat)->browser));
	g_assert(widget_list);
	List=widget_list->List;
	
	g_assert((tree=GUBI_DATA(WidDat)->tree));
	
	ignore_selection_events=TRUE;

	if (!selection_only) {
		register GList	*list;
		register GList	*last;
		register GList	*item_list;
		register guint	item_pos;
		register guint	parent_level;
		
		g_assert((list=g_list_find(tree->widget_data_list, WidDat)));
		last=g_list_find(tree->widget_data_list, widget_data_last_child(WidDat))->next;
		
		item_list=GTK_LIST(List)->children;
		item_pos=0;
		
		parent_level=widget_data_parent_level(WidDat);
		while (item_list || list) {
			
			if (list && item_list) {
				if (list->data==gtk_object_get_user_data(item_list->data)) {
					list=list->next;
					item_pos++;
					item_list=g_list_nth(GTK_LIST(List)->children, item_pos);
					continue;
				}
			}
			if (list) {
				widget_data_item_new(list->data,
					     (widget_data_parent_level(list->data)-parent_level)*2,
					     GTK_LIST(List),
					     item_pos);
				item_pos++;
				item_list=g_list_nth(GTK_LIST(List)->children, item_pos);
				if (list==last)
					list=NULL;
				else {
					list=list->next;
					if (list==last)
						list=NULL;
				}
				continue;
			}
			if (!list && item_list) {
				gtk_list_clear_items(GTK_LIST(List), item_pos, -1);
				item_list=NULL;
				continue;
			}
		}
	}
	
	if (GTK_LIST(List)->selection &&
	    tree->current!=gtk_object_get_user_data(GTK_LIST(List)->selection->data) ) {
		gtk_list_unselect_child(GTK_LIST(List),
					GTK_LIST(List)->selection->data);
	}

	if (!GTK_LIST(List)->selection && tree->current) {
		register GList	*list;
		
		list=GTK_LIST(List)->children;
		while (list) {
			if (gtk_object_get_user_data(GTK_OBJECT(list->data))==tree->current)
				break;
			list=list->next;
		}
		if (list)
			gtk_list_select_child(GTK_LIST(List),
						list->data);
	}
	
	ignore_selection_events=FALSE;

	gtk_label_get(GTK_LABEL(widget_list->Label_symbol_name), &old_label);
	if (!old_label || strcmp(old_label, widget_data_symbol_name_get(WidDat))!=0)
		gtk_label_set(GTK_LABEL(widget_list->Label_symbol_name),
			      (gchar*)widget_data_symbol_name_get(WidDat));
	gtk_label_set(GTK_LABEL(widget_list->Label_parent_name),
		      GTK_LIST(List)->selection && tree->current->parent ?
		        (gchar*)widget_data_symbol_name_get(tree->current->parent) :
		        "");

	if (WidDat==tree->current &&
	    GUBI_DATA(WidDat)->browser)
	    	_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
}


void	Browser_tree_select	(tree_S		*tree,
				 gboolean	selected)
{
	register GList	*list;
	
	g_assert(tree);
	g_assert((list=tree->widget_data_list));
	
	while (list) {
		register gb_wdat_base_S	*WidDat=list->data;
		
		if (GUBI_DATA(WidDat)->browser) {
			register listwid_widget_list_S	*widget_list;
			
			widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(WidDat)->browser));
			g_assert(widget_list);
			
			if (GTK_WIDGET_IS_SENSITIVE(widget_list->Box_selected)!=selected)
				gtk_widget_set_sensitive(widget_list->Box_selected, selected);
		}
		list=list->next;
	}

}


void
SigH_Browser_List_selection_changed	(GtkList	*gtklist,
					 gpointer	func_data)
{
	register gb_wdat_base_S		*WidDat;
	register tree_S			*tree;
	
	
	/* just return if a list refresh is done
	*/
	if (ignore_selection_events)
		return;
	
	
	/* we get the widget from the current item
	 * and our tree from the widget
	*/
	if (gtklist->selection) {
		WidDat=gtk_object_get_user_data(gtklist->selection->data);
		g_assert(GB_IS_WIDGET(WidDat));
		g_assert((tree=GUBI_DATA(WidDat)->tree));
	} else {
		WidDat=NULL;
		tree=NULL;
	}
	
	
	
	/* check current selection for the tree
	*/
	if (tree && tree->current!=WidDat) {
		register GList	*list;
		
		tree_set_current_widget_data(tree, WidDat);
		
		/* reflect new selection on the whole tree
		*/
		g_assert((list=tree->widget_data_list));
		
		while (list) {
			register gb_wdat_base_S	*WidDat;
			
			WidDat=list->data;
			if (GUBI_DATA(WidDat)->browser)
				Browser_refresh(WidDat, TRUE);
			
			list=list->next;
		}
	}
}


void
SigH_Browser_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	if (!TypeList_Window->widget) {
		register GtkWidget	*item;
		register guint		i;
		
		
		/* initialize widgets
		*/
		
		
		/* build window
		*/
		gb_window_build(TypeList_Window);
		
		
		/* connect window signal handlers
		*/
		gb_window_connect(TypeList_Window);
		
		
		/* fill list with widget types,
		 * we use user_data of the GtkListItem for the widget index
		*/
		for (i=0; i<GB_STRUCT_LAST; i++) {
			if (!GB_TYPE_IS_WIDGET(i) || GB_TYPE_IS_WINDOW_WIDGET(i))
				continue;
			item=gtk_list_item_new_with_label((gchar*)
				to_UpCase(structure_info(i)->struct_name));
			gtk_object_set_user_data(GTK_OBJECT(item), (gpointer)i);
			gtk_container_add(GTK_CONTAINER(TypeList_List->widget), item);
			gtk_widget_show(item);
		}
		
		
		/* show window
		*/
		gtk_widget_show(TypeList_Window->widget);
	} else {
		_gtk_widget_raise(TypeList_Window->widget);
		SigH_TypeList_Add_clicked(widget, NULL);
	}
}


void
SigH_Browser_List_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*WidDat;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	WidDat=tree->current;
	if (!GUBI_DATA(WidDat)->browser) {
		if (g_list_length(GUBI_DATA(WidDat)->children)>0)
			Browser_create(WidDat);
	} else
		_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
}


void
SigH_Browser_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	static	 GtkWidget	*Dialog_delete=NULL;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (tree && tree->current && GB_TYPE_IS_WINDOW_WIDGET(tree->current->type)) {
		SigH_TreeList_Delete_clicked(widget, func_data);
		return;
	}

	if (tree && tree->current) {
		register gb_wdat_base_S	*WidDat;
		
		WidDat=tree->current;
		
		if (!Dialog_delete)
			Dialog_delete=
				Dialog_create(GTK_OBJECT(widget),
					      &Dialog_delete,
					      "Delete",
					      GTK_SIGNAL_FUNC(SigH_Delete_widget_real),
					      WidDat,
					      "Delete  <%s> %s ?",
					      widget_data_symbol_name_get(WidDat),
					      g_list_length(GUBI_DATA(WidDat)->children)>0 ?
					      	" recursively" : "");
	}
}


void
SigH_Browser_Edit_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*WidDat;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	WidDat=tree->current;
	if (!GUBI_DATA(WidDat)->editor)
		Editor_create(WidDat);
	else
		_gtk_widget_raise(GUBI_DATA(WidDat)->editor);
}


void
SigH_Delete_widget_real	(GtkWidget	*widget,
			 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*WidDat;
	register gb_wdat_base_S		*ParDat;
	
	WidDat=func_data;
		
	g_assert(GB_IS_WIDGET(WidDat));
	g_assert(GB_IS_CONTAINER_WIDGET(WidDat->parent));
	
	g_assert((tree=GUBI_DATA(WidDat)->tree));
	

	ParDat=WidDat->parent;
	
	if (tree->current==WidDat) {
		register GList	*list;
		
		tree_set_current_widget_data(tree, ParDat);
		
		g_assert((list=tree->widget_data_list));
		
		while (list) {
			register gb_wdat_base_S	*TmpDat;
			
			TmpDat=list->data;
			if (GUBI_DATA(TmpDat)->browser)
				Browser_refresh(TmpDat, TRUE);
			list=list->next;
		}
	}
	
	tree_widget_data_unlink_R(tree, WidDat);
	widget_data_delete_R(WidDat);
}


void
SigH_TypeList_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*Parent;
	register gb_wdat_base_S		*WidDat;
	register gb_struct_type_E	struct_type;
	
	tree=tree_get_current();
	
	
	/* check for error conditions
	*/
	if (!tree || !tree->current) {
		Message_create(GTK_OBJECT(widget),
				"No widget selected for adding.\n");
		return;
	}
	Parent=tree->current;
	if (!GTK_LIST(TypeList_List->widget)->selection) {
		Message_create(GTK_OBJECT(widget),
				"No widget type selected for adding.\n");
		return;
	}
	struct_type=(gb_struct_type_E)gtk_object_get_user_data(
			GTK_OBJECT(GTK_LIST(TypeList_List->widget)->selection->data));
	
	
	/* add appropriate
	*/
/*	switch (current_add_type) {
	case	ADD_TO_CURRENT:
	case	ADD_AS_CURRENT:
	case	ADD_TO_CURRENT_PARENT_BEFORE:
	case	ADD_TO_CURRENT_PARENT_AFTER:
	default:
		g_assert_not_reached();
		break;
	}
FIXME: unfinished
*/
	if (HAS_MAX_CHILD_COUNT(Parent)) {
		Message_create(GTK_OBJECT(widget),
				"Maximum child count reached\nin parent  <%s>.\n",
				widget_data_symbol_name_get(Parent));
		return;
	}
	
	
	/* add widget
	*/
	WidDat=widget_data_new(struct_type, NULL, FALSE);
	tree_widget_data_insert_R(tree, Parent, WidDat, ~0);
	
	
	/* refresh widget lists of all parents
	*/
	while (WidDat) {
		if (GUBI_DATA(WidDat)->browser)
			Browser_refresh(WidDat, FALSE);
		WidDat=WidDat->parent;
	}
}
