/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997  Tim Janik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*RCS_ID("$Id: defines.h,v 1.6 1997/05/09 16:29:43 tim Exp $")*/


#ifndef		__defines_h__
#define		__defines_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif

#include	<stdio.h>



/* --- my name ;) --- */
#define	PRGNAME_short	"gubi"
#define	PRGNAME_Short	"Gubi"
#define	PRGNAME_SHORT	"GUBI"
#define	PRGNAME_long	"gubi - gtk+ user interface builder"
#define	PRGNAME_Long	"Gubi - Gtk+ User Interface Builder"
#define	PRGNAME_LONG	"GUBI - GTK+ USER INTERFACE BUILDER"



/* --- config file ident --- */
#define	GBC_IDENT	PRGNAME_Short"(gbc)"



/* --- macros --- */


/* macro returning internal byte offset of the member of a structure
*/
#undef	offsetof
#define	offsetof(struct_type, struct_member)	((int)&((struct_type*)0)->struct_member)


/* macro for access to gubi_data_S fields
*/
#define	GUBI_DATA_FIELD		user_data
#define	GUBI_DATA(WidDat)	(((gubi_data_S*)((WidDat)->GUBI_DATA_FIELD)))


/* HACK macro DON'T USE
 * FIXME: remove
*/
#define		BREAKPOINT()	__asm__("int $03")



/* --- parser tokens for *.gbc file --- */
/* token base for basic token types and TOKEN_WIDGET_*
*/
#define		TOKEN			(300)


/* tokens (with values in token_U)
*/
#define		TOKEN_ANY		(0)
#define		TOKEN_EOF		(-1)
#define		TOKEN_NULL		(TOKEN -  1)
#define		TOKEN_LONG		(TOKEN -  2)
#define		TOKEN_DOUBLE		(TOKEN -  3)
#define		TOKEN_STRING		(TOKEN -  4)
#define		TOKEN_TREE		(TOKEN -  5)
#define		TOKEN_STRUCT		(TOKEN -  6)
#define		TOKEN_FIELD		(TOKEN -  7)
#define		TOKEN_WIDGET		(TOKEN -  8)
#define		TOKEN_ERROR		(TOKEN -  9)
#define		TOKEN_HANDLER		(TOKEN - 10)


/* tokens for gb_*_S fields in *.gbc
 * FIXME: remove
*/
#define		TOKEN_HANDLER_connect_options		(TOKEN +  1)
#define		TOKEN_HANDLER_handler_func		(TOKEN +  2)
#define		TOKEN_HANDLER_signal_name		(TOKEN +  3)
#define		TOKEN_HANDLER_data			(TOKEN +  4)






#ifdef		__cplusplus
  }
#endif
#endif		/*__defines_h__*/
