/*******************************************************************************
+
+  LEDA  3.0
+
+
+  circle.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef LEDA_CIRCLE_H
#define LEDA_CIRCLE_H

#include <LEDA/point.h>
#include <LEDA/segment.h>
#include <LEDA/line.h>

//------------------------------------------------------------------------------
// circles
//------------------------------------------------------------------------------


class circle_rep : public handle_rep {

friend class circle;

  double  radius;
  point   center; 
  
  circle_rep() {}
  circle_rep(point p, double r)  { center = p; radius = r; }

 ~circle_rep() {}

  LEDA_MEMORY(circle_rep)
  
};


class circle   : public handle_base 
{

circle_rep* ptr() const { return (circle_rep*)PTR; }

public:

 circle();
 circle(point c, double r);
 circle(double x, double y, double r);
 circle(const circle& c) : handle_base(c) {}

~circle()                { clear(); }


circle& operator=(const circle& C) { handle_base::operator=(C); return *this; }

circle operator+(const vector& v) { return translate(v); }


int operator==(const circle&) ;

int operator!=(const circle& c) { return !operator==(c); };

point center()    const  { return ptr()->center; } 
double  radius()  const  { return ptr()->radius; }


double    distance(point);
double    distance(line);
double    distance(circle);
bool    inside(point);
segment left_tangent(point);
segment right_tangent(point);

bool    outside(point p) { return !inside(p); };

circle  translate(double,double) ;
circle  translate(const vector&) ; 

circle  rotate(point, double);
circle  rotate(double);


list<point> intersection(circle);
list<point> intersection(line);
list<point> intersection(segment);

friend ostream& operator<<(ostream& out, const circle& c);
friend istream& operator>>(istream& in, circle& c);  


friend void Print(const circle&, ostream& = cout);
friend void Read(circle&,  istream& = cin);


};

inline void Print(const circle& c, ostream& out) { out << c; } 
inline void Read(circle& c,  istream& in)        { in >> c; }

LEDA_HANDLE_TYPE(circle)



//------------------------------------------------------------------------------
// CIRCLE<cmp>: circles with user defined linear order cmp
//------------------------------------------------------------------------------

typedef int (*CMP_CIRCLE)(circle,circle);


template <CMP_CIRCLE cmp>

struct _CLASSTYPE CIRCLE: public circle 
{  CIRCLE(circle  p )          : circle(p)   {}
   CIRCLE(CIRCLE& p)      : circle(p)   {}
   CIRCLE() {}
 ~ CIRCLE() {}
friend int compare(CIRCLE<cmp>& x, CIRCLE<cmp>& y) { return cmp(x,y); }
};



#endif
