/*******************************************************************************
+
+  LEDA  3.0
+
+
+  d_array.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_D_ARRAY_H
#define LEDA_D_ARRAY_H

//------------------------------------------------------------------------------
// d_array 
//------------------------------------------------------------------------------ 
#include <LEDA/impl/rs_tree.h> 

typedef rst_item d_array_item;


template<class itype, class etype> 

class _CLASSTYPE d_array : public rs_tree 
{

etype init;
d_array_item iterator;

int  cmp(GenPtr x, GenPtr y) const
                          { return compare(ACCESS(itype,x),ACCESS(itype,y)); }
void clear_key(GenPtr& x)   const { Clear(ACCESS(itype,x)); }
void clear_inf(GenPtr& x)   const { Clear(ACCESS(etype,x)); }
void copy_key(GenPtr& x)    const { x=Copy(ACCESS(itype,x));  }
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS(etype,x));  }
int  int_type()             const { return INT_TYPE(itype); }

public:

virtual etype&  operator[](itype y) 
{ d_array_item i=rs_tree::lookup(Convert(y));
  if (i==nil) i=rs_tree::insert(Convert(y),Convert(init));
  return ACCESS(etype,info(i)); 
}

/*
virtual etype   operator[](itype y) const
{ d_array_item i=rs_tree::lookup(Convert(y));
  if (i==nil) return init;
  else return ACCESS(etype,info(i)); 
 }
*/

virtual bool defined(itype y)  const 
{ return (rs_tree::lookup(Convert(y))!=nil); }

virtual void init_iterator() { iterator = rs_tree::first_item(); }

virtual bool next_index(itype& y)    
{ if (iterator==0) return false;
  else { y = ACCESS(itype,key(iterator));
         iterator = rs_tree::next_item(iterator);
         return true; 
        } 
}

d_array& operator=(const d_array& A)
{ rs_tree::operator=(A); init=A.init; return *this; }


d_array()        { Init(init); }
d_array(etype i) { init=i; }

d_array(const d_array& A) : rs_tree(A) {init=A.init;}

virtual ~d_array() { clear(); }

};

#define forall_defined(i,A)  for ((A).init_iterator(); (A).next_index(i); )



//------------------------------------------------------------------------------
//
// Dictionary arrays with implementation parameter:
//
//   _d_array<itype,etype,impl> 
//
//------------------------------------------------------------------------------


#define _d_array_class(itype,etype,impl)\
\
class _CLASSTYPE _d_array_(itype,etype,impl) : public impl, public d_array<itype,etype> \
{\
\
etype init;\
d_array_item iterator;\
\
int cmp(GenPtr x, GenPtr y) const\
{ return compare(ACCESS(itype,x),ACCESS(itype,y)); }\
void clear_key(GenPtr& x) const { Clear(ACCESS(itype,x)); }\
void clear_inf(GenPtr& x) const { Clear(ACCESS(etype,x)); }\
void copy_key(GenPtr& x) const { x=Copy(ACCESS(itype,x)); }\
void copy_inf(GenPtr& x) const { x=Copy(ACCESS(etype,x)); }\
void print_key(GenPtr x) const { Print(ACCESS(itype,x),cout); }\
void print_inf(GenPtr x) const { Print(ACCESS(etype,x),cout); }\
\
int int_type() const { return INT_TYPE(itype); }\
\
public:\
\
virtual etype& operator[](itype y)\
{ d_array_item i=(d_array_item)impl::lookup(Convert(y));\
  if (i==nil) i=(d_array_item)impl::insert(Convert(y),Convert(init));\
  return ACCESS(etype,impl::info(impl::item(i)));\
}\
\
virtual bool defined(itype y) const\
{ return (impl::lookup(Convert(y))!=nil); }\
\
virtual void init_iterator() { iterator = (d_array_item)impl::first_item(); }\
\
virtual bool next_index(itype& y)\
{ if (iterator==0) return false;\
  else { y = ACCESS(itype,impl::key(impl::item(iterator)));\
         iterator = (d_array_item)impl::next_item(impl::item(iterator));\
         return true; }\
}\
\
_d_array_(itype,etype,impl)& operator=(const _d_array_(itype,etype,impl)& A)\
{ impl::operator=(A); init=A.init; return *this; }\
\
_d_array_(itype,etype,impl)()        { Init(init) ;}\
_d_array_(itype,etype,impl)(etype i) { init=i; }\
\
_d_array_(itype,etype,impl)(const _d_array_(itype,etype,impl)& A) : impl(A)\
{ init=A.init; }\
\
virtual ~_d_array_(itype,etype,impl)() { impl::clear(); }

#if defined(__TEMPLATE_ARGS_AS_BASE__)
#define _d_array_(a,b,c) _d_array
template <class itype, class etype, class impl> 
_d_array_class(itype,etype,impl)
};
#else
#define _d_array(a,b,c)         name4(a,b,c,_d_array)
#define _d_array_(a,b,c)        name4(a,b,c,_d_array)
#define _d_arraydeclare3(_a,_b,_c) _d_array_class(_a,_b,_c) };
#endif

#endif
