/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _g_array.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/graph.h>
#include <LEDA/node_matrix.h>


//------------------------------------------------------------------------------
// node and edge arrays       
//------------------------------------------------------------------------------

#define implement_graph_array(itype)\
\
void graph_array(itype)::init(const graph& G, int n, GenPtr i)\
{ if (g!=0) clear();\
  g = (graph*)&G;\
  max_i=n-1;\
  arr=new GenPtr[n];\
  if (arr==0)  error_handler(104,"(node/edge)_array.init(G): out of memory");\
  for (int j=0;j<=max_i;j++) { copy_entry(i); arr[j] = i; }\
}\
\
void graph_array(itype)::init(const graph& G, GenPtr i)\
{ init(G,name2(G.max_i_,itype)()+1,i); }\
\
void graph_array(itype)::init(const graph& G)\
{ GenPtr i;\
  init_entry(i);\
  init(G,i);\
  clear_entry(i);\
}\
\
void graph_array(itype)::init(const graph_array(itype)& A)\
{ if (g!=0) clear();\
  g = A.g;\
  max_i=A.max_i;\
  arr=new GenPtr[max_i+1];\
  if (arr==0)  error_handler(1,"(node/edge)_array.init: out of memory");\
  for (int j=0;j<=max_i;j++)\
  { GenPtr x = A.arr[j];\
    copy_entry(x);\
    arr[j] = x;\
   }\
}\
\
void graph_array(itype)::clear()\
{ int j;\
  for (j=0;j<=max_i;j++) clear_entry(arr[j]);\
  if (arr) delete arr;\
  arr=0; g=0; max_i = -1;\
}\


implement_graph_array(node)
implement_graph_array(edge)

//------------------------------------------------------------------------------
// node matrices
//------------------------------------------------------------------------------

graph_array(node)& Node_Matrix::row(node v) { return *(M[v]); }

GenPtr& Node_Matrix::entry(node v, node w)     { return M[v]->entry(w); }
GenPtr  Node_Matrix::inf(node v, node w) const { return M[v]->inf(w); }

void Node_Matrix::init(const graph& G, int n, GenPtr x) 
{ int i,j;
  g = (graph*)&G;
  M.init(G,n,0);
  for(i=0;i<M.size();i++) 
    { M.elem(i) = new graph_array(node);
      M.elem(i) -> init(G,n,0);
      for(j=0;j<M.elem(i)->size();j++) 
        { copy_entry(x);
          M.elem(i)->entry(j) = x;
         }
     }
}

void Node_Matrix::init(const graph& G, GenPtr x) 
{  init(G,G.max_i_node()+1,x); }

void Node_Matrix::init(const graph& G) 
{ GenPtr x;
  init_entry(x);
  init(G,x);
  clear_entry(x);
}

void Node_Matrix::init(const Node_Matrix& A) 
{ int i,j;
  g = A.g;
  M.init(*g,0);
  for(i=0;i<M.size();i++) 
    { M.elem(i) = new graph_array(node);
      M.elem(i) -> init(*g,0);
      for(j=0;j<M.elem(i)->size();j++) 
        { GenPtr x = A.M.elem(i)->entry(j);
          copy_entry(x);
          M.elem(i)->entry(j) = x;
         }
     }
}

void Node_Matrix::clear()
{ int i,j;
  for(i=0;i<M.size();i++) 
   { for(j=0;j<M.elem(i)->size();j++) 
      { GenPtr x = M.elem(i)->entry(j);
        clear_entry(x); 
       }
     delete M.elem(i);
    }
  M.clear();
}

