/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _msdos.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifdef __TURBOC__
#include <alloc.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <dos.h>

#include "msdos.h"

#if defined(GNUDOS)
static int   getch() { return getkey(); }
#endif

#define KEY_UP 72
#define KEY_DO 80
#define KEY_LE 75
#define KEY_RI 77

#define BG_COLOR 0
#define FG_COLOR 1
#define PANEL_BG_COLOR 1
#define PANEL_FG_COLOR 0


#define XPIX(coord) (int)(xorigin + (coord)*x_draw_scale)
#define YPIX(coord) (int)(yorigin - (coord)*y_draw_scale)

#define XREAL(pix)  ((double)(pix-xorigin)/x_draw_scale)
#define YREAL(pix)  ((double)(yorigin-pix)/y_draw_scale)


static char default_frame_label[128];

static char frame_label[80];

static char read_frame_format[] = "%8.2f %8.2f      %s";

static int mouse_installed;

typedef void (*PRD)();
typedef void (*PMA)();

static void x_draw_mouse_default_action(x,y) 
double x,y;
{ /* do nothing */}


PRD x_draw_redraw = 0;

static int xpix_mode_op;

static int xdots,ydots, xorigin,yorigin;  /* pixels          */

static int mouse_key,mouse_xpix, mouse_ypix; 
static int mouse_last_xpix, mouse_last_ypix;
static int mouse_start_xpix, mouse_start_ypix;  /* start for segments  ... */
static int mouse_read_kind;


static double mouse_xreal,mouse_yreal;
static double mouse_last_xreal,mouse_last_yreal;
static double mouse_start_xreal,mouse_start_yreal;

static double x_draw_aspect_ratio;
static double y_draw_scale;   

static char* mesg_list[24];
static int   mesg_count;



/* external variables */

int x_draw_window_xpos = 0;
int x_draw_window_ypos = 0;
int x_draw_window_width = 0;
int x_draw_window_height = 0;
   
double x_draw_xmax,x_draw_xmin,x_draw_ymax,x_draw_ymin, x_draw_scale;

int    x_draw_grid_mode;
int    x_draw_depth;

int    x_draw_line_width, x_draw_node_width, x_draw_line_style, x_draw_color,
       x_draw_text_mode, x_draw_drawing_mode, x_draw_screen_flush;



void x_draw_flush() { }

void x_draw_set_show_coord() { }

void x_draw_set_redraw(f)
PRD f;
{ x_draw_redraw = f; 
 }

void x_draw_set_frame_label(message)
char* message;
{ int save = x_draw_set_mode(1);
  put_text(20,1,frame_label,0);
  strcpy(frame_label,message);
  put_text(20,1,frame_label,0);
  x_draw_set_mode(save);
  }

void x_draw_reset_frame_label() 
{ x_draw_set_frame_label(default_frame_label); }


void x_draw_mouse_segment_action(x,y)
double x,y;
{ set_color(FG_COLOR);
  line(mouse_start_xpix,mouse_start_ypix,XPIX(x),YPIX(y));
 }

void x_draw_mouse_rect_action(x,y)
double x,y;
{ set_color(FG_COLOR);
  rectangle(mouse_start_xpix, mouse_start_ypix, XPIX(x),YPIX(y));
 } 


void x_draw_mouse_circle_action(x,y)
double x,y;
{ double r = hypot(x - mouse_start_xreal, y - mouse_start_yreal);
  set_color(FG_COLOR);
  circle(mouse_start_xpix,mouse_start_ypix,(int)(r*x_draw_scale));
 }


void x_draw_set_font(fname)
char* fname;
{ }



/*
from <LEDA/window.h>:
enum color  { white=0, black=1,  red=2,    green=3, 
              blue=4,  yellow=5, violet=6, orange=7 };
*/

static void x_draw_set_color(col)
int col;
{ set_color(col); }

int x_draw_set_line_width(w)
int w;
{ int save = x_draw_line_width;
  x_draw_line_width = w;
  set_line_style(x_draw_line_style,x_draw_line_width);
  return save;
}


int x_draw_set_line_style(s)
int s;
{ int old = x_draw_line_style;
  x_draw_line_style = s;
  set_line_style(s,x_draw_line_width);
  return old;
}


int x_draw_set_mode(m)
int m;
{ int old=get_mode();
  set_mode(m);
  return old;
}


int x_draw_set_node_width(w)
int w;
{ int save = x_draw_node_width;
  x_draw_node_width = w;
  return save;
 }

int x_draw_set_text_mode(m)
int m;
{ int save = x_draw_text_mode;
  x_draw_text_mode = m;
  return save;
 }


static void draw_cursor(x,y)
int x,y;
{ int save = get_color();
  int dx = 8;
  int dy = 8*x_draw_aspect_ratio;
  set_color(1);
  set_line_style(0,3);
  line(x-dx,y,x+dx,y);
  line(x,y-dy,x,y+dy);
  set_line_style(x_draw_line_style,x_draw_line_width);
  set_color(save);
 }

int x_draw_get_button()
{ char c;
  int taste = 0;
  union REGS regs;
  union REGS key_regs;

  if (kbhit())  /* keyboard */
  { c=getch();
    switch(c) {
        case    13:
        case    '1': taste = 1; break; 
        case    '2': taste = 2; break;
        case    '3': taste = 3; break;
        case    '!': taste = -1; break;
        case    '@': taste = -2; break;
        case    '#': taste = -3; break;
        case    '4': taste = 4; break;
        case    '5': taste = 5; break;
        case    '6': taste = 6; break;
        case    27 : exit_graphics(); exit(0); break;     /* escape */
       }
    }
  
    if (mouse_installed)
    { if (taste==0)
      { regs.x.ax=03;
        int86(0x33,&regs,&regs);
        switch (regs.x.bx) {
        case 1:  taste = 1; break;
        case 2:  taste = 3; break;
        case 4:  taste = 2; break;
        }
        if (taste!=0)
        { key_regs.h.ah=0x02;
          int86(0x16,&key_regs,&key_regs);
          if (key_regs.h.al & 3) taste = -taste;    /* shift key */
          if (key_regs.h.al & 4) taste += 3;        /* ctrl key  */
         }
       }

      while (regs.x.bx != 0)
      { regs.x.ax=03;
        int86(0x33,&regs,&regs);
       }
     }
  return taste;
}
  

int x_read_mouse_action(action, xstart,ystart,x,y)
PMA   action;
double xstart;
double ystart;
double *x;
double *y;
{ 
  int  taste=0;
  char c=0;
  int  save_mode;
  int  save_line_width;
  int  step;
  
  union REGS regs, key_regs;

  if (action==0)
    action = x_draw_mouse_default_action; 

  save_mode = x_draw_set_mode(1);
  save_line_width = x_draw_set_line_width(1);

  mouse_start_xreal = xstart;
  mouse_start_yreal = ystart;
  mouse_start_xpix = XPIX(xstart);
  mouse_start_ypix = YPIX(ystart);

  action(mouse_last_xreal,mouse_last_yreal);

  draw_cursor(mouse_last_xpix, mouse_last_ypix);


  while (taste == 0)
  { 
    if (kbhit())  /* keyboard */
    { c=getch();
      step = 8;
      key_regs.h.ah=0x02;
      int86(0x16,&key_regs,&key_regs);
      if (key_regs.h.al & 3) step = 1;    /* shift key */
      switch(c) {
        case KEY_LE: mouse_xpix -= step; break;
        case KEY_RI: mouse_xpix += step; break;
        case KEY_UP: mouse_ypix -= step*x_draw_aspect_ratio; break;
        case KEY_DO: mouse_ypix += step*x_draw_aspect_ratio; break;
        case    13:  /* return */
        case    '1': taste = 1; break;
        case    '2': taste = 2; break;
        case    '3': taste = 3; break;
        case    '!': taste = -1; break;
        case    '@': taste = -2; break;
        case    '#': taste = -3; break;
        case    '4': taste = 4; break;
        case    '5': taste = 5; break;
        case    '6': taste = 6; break;
        case    27 : exit_graphics(); exit(0); break;     /* escape */
       }
      regs.x.ax=04;
      regs.x.cx=mouse_xpix;
      regs.x.dx=mouse_ypix;
      int86(0x33,&regs,&regs);
     }
  
    if (mouse_installed && taste==0)
    { regs.x.ax=03;
      int86(0x33,&regs,&regs);
      switch (regs.x.bx) {
      case 1:  taste = 1; break;
      case 4:  taste = 2; break;
      case 2:  taste = 3; break;
      }
      mouse_xpix=regs.x.cx;
      mouse_ypix=regs.x.dx;

      if (taste!=0)
      { key_regs.h.ah=0x02;
        int86(0x16,&key_regs,&key_regs);
        if (key_regs.h.al & 3) taste = -taste;    /* shift key */
        if (key_regs.h.al & 4) taste += 3;        /* ctrl key  */
       }
     }
  
    mouse_xreal =  XREAL(mouse_xpix);
    mouse_yreal =  YREAL(mouse_ypix);
   
    if (x_draw_grid_mode) 
    { mouse_xreal = x_draw_grid_mode * (int)(mouse_xreal/x_draw_grid_mode + ((mouse_xreal > 0) ? 0.5 : -0.5));
   
      mouse_yreal = x_draw_grid_mode * (int)(mouse_yreal/x_draw_grid_mode + ((mouse_yreal > 0) ? 0.5 : -0.5));
   
      mouse_xpix  = XPIX(mouse_xreal);
      mouse_ypix  = YPIX(mouse_yreal);
    }
          
    if (mouse_last_xpix != mouse_xpix || mouse_last_ypix != mouse_ypix)
    { action(mouse_last_xreal,mouse_last_yreal);
      action(mouse_xreal,mouse_yreal);
      draw_cursor(mouse_last_xpix,mouse_last_ypix);
      draw_cursor(mouse_xpix,mouse_ypix);
     }

    mouse_last_xpix = mouse_xpix;
    mouse_last_ypix = mouse_ypix;
          
    mouse_last_xreal = mouse_xreal;
    mouse_last_yreal = mouse_yreal;

   }

   if (mouse_installed)
     while (regs.x.bx != 0)
     { regs.x.ax=03;
       int86(0x33,&regs,&regs);
      }

   draw_cursor(mouse_xpix,mouse_ypix);

   action(mouse_xreal,mouse_yreal);

   
  *x = mouse_xreal;
  *y = mouse_yreal;

 x_draw_set_mode(save_mode);
 x_draw_set_line_width(save_line_width);

 if (c=='s') taste = -taste;
 if (c=='c') taste =  taste + 3;

 return taste;

}


int x_read_mouse(kind, xstart,ystart,x,y)
int    kind;   /* 0: point, 1: segment, 2:rectangle, 3: circle */
double xstart;
double ystart;
double *x;
double *y;
{ 
  PMA f;
  int key;

  switch(kind) {

  case 0 : f =  x_draw_mouse_default_action;
          break;

  case 1:  f = x_draw_mouse_segment_action;
           break;

  case 2:  f = x_draw_mouse_rect_action;
           break;

  case 3:  f = x_draw_mouse_circle_action;
           break;

  default: f = x_draw_mouse_default_action;
           break;

  }

  key = x_read_mouse_action(f,xstart,ystart,x,y);

  return key;

}



void x_draw_init_window(w_width,w_height,w_xpos,w_ypos,label)
int w_width;
int w_height;
int w_xpos;
int w_ypos;
char* label;
{ 
  int  i;
  union REGS regs;
  int err;

  init_graphics();
  clear_screen();

 /* init mouse driver */
   regs.x.ax=0;
   int86(0x33,&regs,&regs);

  mouse_installed = (regs.x.ax == 0x0ffff);

  strcpy(default_frame_label,frame_label);
  if (label)
      strcpy(frame_label,label);
  else
      frame_label[0] = '\0';

  x_draw_depth = 1;

  x_draw_set_line_style(0);
  x_draw_set_line_width(1);
  x_draw_set_mode(0);
  x_draw_set_node_width(10);
  x_draw_set_text_mode(0); 

  x_draw_color = FG_COLOR;

  x_draw_xmin = 0;
  x_draw_ymin = 0;
  x_draw_xmax = 0;
  x_draw_ymax = 0;
  x_draw_scale = 1;
  y_draw_scale = 1;

  mouse_xpix = 0;
  mouse_ypix = 0;
  mouse_last_xpix = 0;
  mouse_last_ypix = 0;

  x_draw_aspect_ratio = get_xy_ratio();

  if (!mouse_installed) 
   x_draw_acknowledge("No mouse: use cursor keys");

}


/* TEXT  */

void x_draw_del_messages()
{ int x,y;
  int save_mode;
  int i;
  set_color(FG_COLOR);
  save_mode = x_draw_set_mode(1);
  while (mesg_count > 0)
  { x = 4*text_width("H");
    y = (int)(1.25*text_height("H")*mesg_count);
    put_text(x,y,mesg_list[mesg_count-1],0);
    free(mesg_list[mesg_count-1]);
    mesg_count--;
   }
  x_draw_set_mode(save_mode);
 }

void x_draw_message(s)
char * s;
{ int x,y;
  int save_mode;
  x = 4*text_width("H");
  y = (int)(1.25*text_height("H")*(mesg_count+1));
  set_color(FG_COLOR);
  save_mode = x_draw_set_mode(1);
  mesg_list[mesg_count] = (char*)malloc(strlen(s)+1);
  strcpy(mesg_list[mesg_count],s);
  put_text(x,y,s,0);
  mesg_count++;
  x_draw_set_mode(save_mode);
 }

void x_draw_ctext(x,y,s,col)
double x,y;
char * s;
int col;
{ int X = XPIX(x) - text_width(s)/2 + 1;
  int Y = YPIX(y) - text_height(s)/2 + 1;
  set_color(col);
  put_text(X,Y,s,x_draw_text_mode);
}

void x_draw_text(x,y,s,col)
double x,y;
char * s;
int col;
{ set_color(col);
  put_text(XPIX(x),YPIX(y),s,x_draw_text_mode);
}

void x_draw_int(x0,y0,i,col)
double x0,y0;
int i,col;
{ char buf[16];
  sprintf(buf,"%d",i);
  x_draw_ctext(x0,y0,buf,col);
 }


void x_draw_clear(col)
int col;
{ int x,y;
  int save_mode;
  x_draw_del_messages();
  clear_screen();

  save_mode = x_draw_set_mode(1);
  put_text(20,1,frame_label,0);
  x_draw_set_mode(save_mode);

 set_color(FG_COLOR);
 if (x_draw_grid_mode) /* draw grid */
 { for(x = (int)(x_draw_xmin/x_draw_grid_mode)*x_draw_grid_mode; x<=x_draw_xmax; x+=x_draw_grid_mode)
   for(y = (int)(x_draw_ymin/x_draw_grid_mode)*x_draw_grid_mode; y<=x_draw_ymax; y+=x_draw_grid_mode)
   { if (x*y == 0) fill_circle(XPIX(x),YPIX(y),1);
     else  pixel(XPIX(x),YPIX(y));
    }
  }
} 


void x_draw_init(x0,x1,y0,g_mode)
double x0,x1,y0;
int g_mode;
{
  if (x0>=x1) 
  { exit_graphics();
    printf("Illegal arguments in draw_init: x0 (%f) >= x1 (%f)\n",x0,x1);
    abort();
   }

  mesg_count = 0;

  x_draw_grid_mode = g_mode; 

  x_draw_reset_frame_label();

  xdots = max_xcoord();
  ydots = max_ycoord();


  x_draw_scale = ((double)xdots)/(x1-x0);

  if (x_draw_grid_mode*x_draw_scale < 2) x_draw_grid_mode=0;  

  if (x_draw_grid_mode) 
  { if (x_draw_scale < 1) x_draw_scale = 1;
    else x_draw_scale = (int)x_draw_scale;
   }

  y_draw_scale = x_draw_scale * x_draw_aspect_ratio;
  x_draw_xmin = x0;
  x_draw_ymin = y0;
  x_draw_xmax = x0+xdots/x_draw_scale;
  x_draw_ymax = y0+ydots/y_draw_scale;

  xorigin = -x0*x_draw_scale;
  yorigin = ydots+y0*y_draw_scale;

  mouse_xpix = mouse_last_xpix = max_xcoord()/2;
  mouse_ypix = mouse_last_ypix = max_ycoord()/2;

  mouse_xreal = XREAL(mouse_xpix);
  mouse_yreal = YREAL(mouse_ypix);

  x_draw_clear(BG_COLOR);   

  if (x_draw_redraw) (*x_draw_redraw)();


}



void x_show_window() {}


void x_draw_end() { exit_graphics(); }


void x_draw_pix(x,y,col) 
double x,y;
int col;
{ set_color(col);
  pixel(XPIX(x),YPIX(y)); 
 }


void x_draw_line(x1, y1, x2, y2, col)
double x1,y1,x2,y2;
int col;
{ set_color(col);
  line(XPIX(x1), YPIX(y1), XPIX(x2), YPIX(y2));
 }


void x_draw_point(x,y,col)
double x,y;
int col;
{ int X = XPIX(x);
  int Y = YPIX(y);
  set_color(col);
  pixel(X-2,Y-2);
  pixel(X-2,Y+2);
  pixel(X-1,Y-1);
  pixel(X-1,Y+1);
  pixel(X,Y);
  pixel(X+1,Y-1);
  pixel(X+1,Y+1);
  pixel(X+2,Y-2);
  pixel(X+2,Y+2);
 }

void x_draw_node(x0,y0,col)
double x0,y0;
int col;
{ int save = x_draw_set_line_width(1); 
  set_color(col);
  circle(XPIX(x0),YPIX(y0),x_draw_node_width); 
  x_draw_set_line_width(save); 
 }

void x_draw_filled_node(x0,y0,col)
double x0,y0;
int col;
{ set_color(col);
  fill_circle(XPIX(x0),YPIX(y0),x_draw_node_width);
 }


void x_draw_text_node(x0,y0,s,col)
double x0,y0;
int col;
char* s;
{ 
  int save = x_draw_text_mode;
  x_draw_text_mode = 0;  /* transparent */

  if (x_draw_depth==1 || col == 1)
     x_draw_node(x0,y0,1);
  else
     x_draw_filled_node(x0,y0,col);

  x_draw_ctext(x0,y0,s,1);
  x_draw_text_mode = save;

 }

void x_draw_int_node(x0,y0,i,col)
double x0,y0;
int i,col;
{ char buf[16];
  sprintf(buf,"%d",i);
  x_draw_text_node(x0,y0,buf,col);
 }

x_draw_ellipse()
{ fprintf(stderr,"sorry, draw ellipse not implemented\n"); }

x_draw_filled_ellipse()
{ fprintf(stderr,"sorry, draw ellipse not implemented\n"); }


void x_draw_circle(x0,y0,r,col)
double x0,y0,r; 
int col;
{ int R = (int)(r*x_draw_scale);
  int i;
  set_color(col);
  circle(XPIX(x0),YPIX(y0),R);
  for (i=1;i<=x_draw_line_width/2;i++) 
  { circle(XPIX(x0),YPIX(y0),R-i);
    circle(XPIX(x0),YPIX(y0),R+i);
   }
 }

x_draw_arc()
{ fprintf(stderr,"sorry, draw arc not implemented\n"); }

x_draw_filled_arc()
{ fprintf(stderr,"sorry, draw arc not implemented\n"); }


/*
void x_draw_arc(x0,y0,r,a,b,col)
double x0,y0,r,a,b; 
int col;
{ int R = (int)(r*x_draw_scale);
  int i;
  set_color(col);
  if (a<0) a += 2*M_PI;
  if (b<0) b += 2*M_PI;

  if (a<=b)
    { arc(XPIX(x0),YPIX(y0),R,a,b);
      for (i=1;i<=x_draw_line_width/2;i++) 
        { arc(XPIX(x0),YPIX(y0),R-i,a,b);
          arc(XPIX(x0),YPIX(y0),R+i,a,b);
         }
     }
  else
    { arc(XPIX(x0),YPIX(y0),R,0,b);
      arc(XPIX(x0),YPIX(y0),R,a,2*M_PI);
      for (i=1;i<=x_draw_line_width/2;i++) 
      { arc(XPIX(x0),YPIX(y0),R-i,0,b);
        arc(XPIX(x0),YPIX(y0),R+i,0,b);
        arc(XPIX(x0),YPIX(y0),R-i,a,2*M_PI);
        arc(XPIX(x0),YPIX(y0),R+i,a,2*M_PI);
       }
     }
 }
*/


void x_draw_filled_circle(x0,y0,r,col)
double x0,y0,r; 
int col;
{ int R = (int)(r*x_draw_scale);
  set_color(col);
  fill_circle(XPIX(x0),YPIX(y0),R); 
 }


int x_draw_xpix(x)
double x;
{ return XPIX(x); }

int x_draw_ypix(x)
double x;
{ return YPIX(x); }


void x_draw_plot_xy(x0,x1,f,col)
double x0,x1;
double (*f)();
int col;
{ } 

void x_draw_plot_yx(y0,y1,f,col)
double y0,y1;
double (*f)();
int col;
{ }


void x_draw_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{ int  i;
  set_color(col);
  for (i=0; i<n-1; i++)
    line(XPIX(xcoord[i]),YPIX(ycoord[i]),XPIX(xcoord[i+1]),YPIX(ycoord[i+1]));

  line(XPIX(xcoord[0]),YPIX(ycoord[0]),XPIX(xcoord[n-1]),YPIX(ycoord[n-1]));
 }


void x_draw_filled_polygon(n,xcoord,ycoord,col)
int col, n;
double *xcoord, *ycoord;
{ int* X = (int*)malloc(n*sizeof(int));
  int* Y = (int*)malloc(n*sizeof(int));
  int i;
  for(i=0;i<n;i++)
  { X[i] = XPIX(xcoord[i]);
    Y[i] = YPIX(ycoord[i]);
   }
  set_color(col);
  fill_polygon(n,X,Y);
  free(X);
  free(Y);
}



void x_draw_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2;
int col;
{ set_color(col);
  rectangle(XPIX(x1),YPIX(y1),XPIX(x2),YPIX(y2)); 
 }


void x_draw_filled_rectangle(x1,y1,x2,y2,col)
double x1,y1,x2,y2; 
int col;
{ set_color(col);
  box(XPIX(x1),YPIX(y1),XPIX(x2),YPIX(y2)); 
 }

void x_draw_fill(x,y,col)
double x,y;
int col;
{ set_color(col);
  flood_fill(XPIX(x),YPIX(y));
 }

void x_draw_copy_rect() { }

int x_draw_screen_width() { return(max_xcoord()); }

int x_draw_screen_height() { return(max_xcoord()); }


static void x_draw_putch(x,y,ch,col)
int x;
int y;
char ch;
int col;
{ char out[2];
  out[0] = ch;
  out[1] = 0;
  set_color(col);
  put_text(x,y,out,0);
}


static char* read_text_panel(message,x1,y1)
char	*message;
int x1,y1;
{
  int i;
  int tw,mw;
  int x2,y2;
  unsigned char* p;
  char c;

  int cw = text_width("H");

  int loop=0;
  char* result = (char*)malloc(32);
  int maxx=max_xcoord();
  int maxy=max_ycoord();
  int save_color=get_color();
  int save_mode = x_draw_set_mode(0);

  if (strlen(message) == 0) message = "STRING INPUT";
  if (strlen(message) > 31) message[31] = 0;

  mw = text_width(message);
  tw = 24*cw;


  if (x1<0)
  { x1 = (maxx-tw-mw-30)/2;
    y1 = maxy/2-15;
   }

  x2 = x1+tw+mw+30;
  y2 = y1 + 30;

  p = save_box(x1,y1,x2,y2);

  set_color(PANEL_BG_COLOR);
  box(x1,y1,x2,y2);

  set_color(PANEL_FG_COLOR);
  rectangle(x1+1,y1+1,x2-1,y2-1);
  put_text(x1+10,y1+8,message,0);

  x2 = x1 + mw + 20;
  y2 = y1+8;


  x_draw_putch(x2,y2,'|',PANEL_FG_COLOR);

  c=getch();

  while(c != 13)
  { int x = x2+loop*cw;
    if (loop < 23 && isprint(c))
    { result[loop]=c;
      x_draw_putch(x,y2,'|',PANEL_BG_COLOR);
      x_draw_putch(x,y2,c,PANEL_FG_COLOR);
      x_draw_putch(x+cw,y2,'|',PANEL_FG_COLOR);
      loop++;
    }
    if(c==8 && loop>0)
    { loop--;
      x_draw_putch(x,y2,'|',PANEL_BG_COLOR);
      x_draw_putch(x-cw,y2,result[loop],PANEL_BG_COLOR);
      x_draw_putch(x-cw,y2,'|',PANEL_FG_COLOR);
    }
    c=getch();
  }

  result[loop]='\0';

  restore_box(p);
  free((char*)p);

  set_color(save_color);
  x_draw_set_mode(save_mode);

  return result;
}


char* x_draw_read_text_panel(message,menu_label,n,items)
char	*message;
char	*menu_label;
int      n;
char   **items;
{
  return read_text_panel(message,-1,-1);
}



static int read_panel(message,n,labels,xpos,ypos)
char	*message;
int n;
char	**labels;
int    xpos, ypos;
{ 
  unsigned int size;
  int answer= -1;
  int save_color;
  int save_mode;
  int i;
  int panel_width;
  unsigned char* buffer;

  int L[16]; 
  int R[16]; 

  int panel_height = 58;
  int mes_y = 7;
  int y0 = 30;
  int xskip  = 30;
  int xspace = 5;
  int yspace = 3;
  int panel_y;
  int panel_y1;
  int panel_x;
  int panel_x1;
  int mes_x;
  int mes_width;
  int y1;


  mes_width = text_width(message);
  y1 = y0 + text_height("H") + 2*yspace - 1;

  panel_width = xskip;

  for(i=0;i<n;i++)
  { L[i] = panel_width;
    panel_width += 2*xspace+text_width(labels[i]);
    R[i] = panel_width;
    panel_width += xskip;
   }


  mes_x = (panel_width-mes_width)/2;

  if (mes_x < xskip)
  { int d = xskip - mes_x;
    for(i=0;i<n;i++)
    { L[i] += d;
      R[i] += d;
     }
    panel_width += 2*d;
    mes_x = xskip;
  }


  panel_x = (max_xcoord()-panel_width)/2;
  if (xpos > 0 && xpos+panel_width < max_xcoord()) panel_x = xpos;
  if (panel_x<0) panel_x=0;

  panel_y = (ypos>0) ? ypos : (max_ycoord()-panel_height)/2;

  panel_x1=panel_x+panel_width+1; 
  panel_y1=panel_y+panel_height+1;

  /* save picture */
  buffer = save_box(panel_x,panel_y,panel_x1,panel_y1);

  save_mode = x_draw_set_mode(0);
  set_line_style(0,1);

  save_color = get_color();

  set_color(PANEL_BG_COLOR); 
  box(panel_x,panel_y,panel_x1,panel_y1);

  set_color(PANEL_FG_COLOR); 
  rectangle(panel_x+1,panel_y+1,panel_x1-1,panel_y1-1);
  put_text(panel_x+mes_x,panel_y+mes_y,message,0);

  for (i=0;i<n;i++)  /* draw buttons */
  { rectangle(panel_x+L[i],panel_y+y0,panel_x+R[i],panel_y+y1);
    put_text(panel_x+L[i]+xspace,panel_y+y0+yspace,labels[i],0);
   }


  while (answer == -1)
  { 
    double x,y;
    int xpix,ypix;

    x_read_mouse(0,0.0,0.0,&x,&y);

    xpix = XPIX(x) - panel_x;
    ypix = YPIX(y) - panel_y;

    if ( y0 < ypix  && ypix < y1) 
    { int i = 0;
      while (i < n && R[i] < xpix) i++;
      if (i < n && L[i] < xpix)  answer = i;
     }
   }

 /* highlight pressed button */
 set_color(PANEL_FG_COLOR);
 box(panel_x+L[answer],panel_y+y0,panel_x+R[answer],panel_y+y1);
 set_color(PANEL_BG_COLOR);
 for(i=0;i<50;i++)
   put_text(panel_x+L[answer]+xspace,panel_y+y0+yspace,labels[answer],0);
  
 restore_box(buffer);
 free((char*)buffer);

 set_color(save_color);
 x_draw_set_mode(save_mode);
 set_line_style(x_draw_line_style,x_draw_line_width);

 return answer;
}


int x_draw_read_panel(message,n,labels,vertical)
char	*message;
int n;
char	**labels;
int    vertical;
{
  return read_panel(message,n,labels,-1,-1);
 }

int confirm(header,x,y)
char *header;
int x,y;
{ char* s[2];
  s[0] = "NO";
  s[1] = "YES";
  return read_panel(header,2,s,x,y);
}

int x_draw_confirm(header)
char *header;
{ char* s[2];
  s[0] = "NO";
  s[1] = "YES";
  return x_draw_read_panel(header,2,s,0);
}

int x_draw_acknowledge(header)
char *header;
{ /* ask for ok */
  char* s[1];
  s[0] = "OK";

  mouse_last_xpix = mouse_xpix = max_xcoord()/2;
  mouse_last_ypix = mouse_ypix = max_ycoord()/2 + 10;

  return x_draw_read_panel(header,1,s,0);
}


void x_draw_message_panel(argc,argv)
int argc;
char** argv;
{ }

void x_draw_notice()
{ }

void x_draw_cursor()
{ }


/*---------------------------------------------------------------------------*/
/* panels                                                                    */
/*---------------------------------------------------------------------------*/


typedef struct {

char* header;

int but_count;
char* buttons[16];

int text_count;
char* text[16];

int string_count;
char* string_label[8];
char* string_ref[8];

int int_count;
char* int_label[8];
int* int_ref[8];

int float_count;
char* float_label[8];
double* float_ref[8];

int choice_count;
int choice_size[8];
int choice_step[8];
int choice_offset[8];
char* choice_label[8];
char* choices[8][8];
int* choice_ref[8];

} LEDA_PANEL;

typedef LEDA_PANEL* leda_panel;


leda_panel x_draw_panel_create() 
{ leda_panel p = (leda_panel) malloc(sizeof(LEDA_PANEL));
  p->header = "";
  p->but_count = 0;
  p->text_count = 0; 
  p->int_count = 0;
  p->float_count = 0;
  p->string_count = 0;
  p->choice_count = 0;
  return p;
}

void x_draw_panel_destroy(p) 
leda_panel p;
{ free((char*)p); }

void x_draw_panel_label(p,s) 
leda_panel p;
char* s;
{ p->header = s; }


void x_draw_panel_text_item(p,s) 
leda_panel p;
char* s;
{ p->text[p->text_count++] = s; }

void x_draw_panel_string_item(p,s,x) 
leda_panel p;
char* s;
char* x;
{ p->string_label[p->string_count] = s;
  p->string_ref[p->string_count] = x; 
  p->string_count++;
 }

void  x_draw_panel_string_menu_item(p,s,x,argc,argv)
leda_panel p;
char* s;
char* x;
int   argc;
char** argv;
{ x_draw_panel_string_item(p,s,x); }


void x_draw_panel_int_item(p,s,x)
leda_panel p;
char* s;
int* x;
{ p->int_label[p->int_count] = s;
  p->int_ref[p->int_count] = x; 
  p->int_count++;
 }

void  x_draw_panel_slider_item(p,s,x,Min,Max)
leda_panel p;
char* s;
int* x;
int Min;
int Max;
{ x_draw_panel_int_item(p,s,x); }

void x_draw_panel_float_item(p,s,x) 
leda_panel p;
char* s;
double* x;
{ p->float_label[p->float_count] = s;
  p->float_ref[p->float_count] = x; 
  p->float_count++;
 }

void x_draw_panel_choice_item(p,text,address,argc,argv,step,offset)
leda_panel p;
char* text;
int* address;
int argc;
char** argv;
int step;
int offset;
{ int i;
  p->choice_label[p->choice_count] = text;
  p->choice_ref[p->choice_count] = address;
  p->choice_step[p->choice_count] = step;
  p->choice_offset[p->choice_count] = offset;
  for(i = 0; i < argc; i++) p->choices[p->choice_count][i] = argv[i];
  p->choice_size[p->choice_count] = argc;
  p->choice_count++;
 }


void x_draw_panel_button(p,s) 
leda_panel p;
char* s; 
{ p->buttons[p->but_count++] = s; }


void  x_draw_panel_button_line(p,n,b)
leda_panel p;
int n;
char** b; 
{ int i;
  for(i=0; i<n; i++) x_draw_panel_button(p,b[i]); 
 }


int  x_draw_panel_open(p) 
leda_panel p;
{ int i,j,x,y,ymax;
  int n=0;
  int xoff = 100;
  int yoff = 10;
  int but;
  float f;
  double xc,yc;
  char  text[80];
  int save_mode = x_draw_set_mode(0);
  int save_lw = x_draw_set_line_width(1);
  int save_col = get_color();

  set_color(FG_COLOR);
  save_screen();
  clear_screen();

  y = yoff;
  put_text(xoff,y,p->header,1);

  for(i=0;i<p->text_count; i++) put_text(xoff,y+=20,p->text[i],1);
  y+=20;

  for(i=0;i<p->int_count; i++)
  { sprintf(text,"%-15s = %8d",p->int_label[i],*p->int_ref[i]);
    y+=20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,text,1);
   }
  
  for(i=0;i<p->float_count; i++)
  { sprintf(text,"%-15s = %8.2f",p->float_label[i],*p->float_ref[i]);
    y+=20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,text,1);
   }
   
  for(i=0;i<p->string_count; i++)
  { sprintf(text,"%-15s = %8s",p->string_label[i],p->string_ref[i]);
    y+=20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,text,1);
   }
     
  for(i=0;i<p->choice_count; i++)
  { int x = (*p->choice_ref[i]-p->choice_offset[i])/p->choice_step[i];
    sprintf(text,"%-15s = %8s",p->choice_label[i], p->choices[i][x]);
    y+=20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,text,1);
   }

  n = p->int_count   + 
      p->float_count + 
      p->string_count+ 
      p->choice_count;

  ymax = y + 25;
  
  if (n>0 || p->but_count==0)
  { y += 20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,"OK",1);
    y += 20;
    rectangle(xoff,y+1,xoff+20,y+19);
    put_text(xoff+30,y+4,"QUIT",1);

    ymax = y + 25;
  
    for(;;)
    { i = -1;
      while (i < 0 || i > n+1)
      { but = x_read_mouse(0,0.0,0.0,&xc,&yc);
        x = XPIX(xc);
        y = YPIX(yc);
        if (xoff <= x && x <= xoff+20 )
             i = (y-yoff)/20 - p->text_count - 2;
       }
      y = 20*(p->text_count+i+2)+yoff;
      set_color(FG_COLOR);
      box(xoff+1,y+2,xoff+19,y+18);
  
      if (i == n) break;    /* OK    */

      if (i == n+1)         /* QUIT  */
      { exit_graphics();
        exit(0);
       }
  
      j = i;
  
      if (i < p->int_count)
      { if (but==3)
           *p->int_ref[i] = atoi(read_text_panel(p->int_label[i],xoff,ymax));
        if (but==1) (*p->int_ref[i])++;
        if (but==2) (*p->int_ref[i])--;
        sprintf(text,"%-15s = %8d",p->int_label[i],*p->int_ref[i]);
        i = n;
       }
      else i -= p->int_count;
  
      if (i < p->float_count)
      { f = atof(read_text_panel(p->float_label[i],xoff,ymax));
        *p->float_ref[i] = (double)f;
        sprintf(text,"%-15s = %8.2f",p->float_label[i],f);
        i = n;
       }
      else i -= p->float_count;
  
     if (i < p->string_count)
     { strcpy(p->string_ref[i],read_text_panel(p->string_label[i],xoff,ymax));
       sprintf(text,"%-15s = %8s",p->string_label[i],p->string_ref[i]);
       i = n;
      }
     else i -= p->string_count;
  
     if (i < p->choice_count)
     { /*
       int c = read_panel(p->choice_label[i],p->choice_size[i],
                                                      p->choices[i],xoff,ymax);
       */
       int c = 1 + (*(p->choice_ref[i])-p->choice_offset[i])/p->choice_step[i];
       if (c >= p->choice_size[i]) c=0;
       *(p->choice_ref[i]) = p->choice_offset[i] + c * p->choice_step[i];
       sprintf(text,"%-15s = %8s",p->choice_label[i], p->choices[i][c]);
      }

     set_color(BG_COLOR);
     box(xoff+1,y+2,xoff+19,y+18);
     set_color(FG_COLOR);
     put_text(xoff+30,20*(p->text_count+j+2)+yoff+4,text,1);
    }
  }

  if (p->but_count!=0)
    i = read_panel(p->header,p->but_count,p->buttons,xoff,ymax);

  x_draw_set_mode(save_mode);
  x_draw_set_line_width(save_lw);
  set_color(save_col);
  restore_screen();
  return i;
}


#ifdef MAIN

void main()
{ double x,y;
  double x1,y1;
  double px[20], py[20];
  char s[256];
  int i;
  char* p;

  x_draw_init_window(0,0,0,0,"LEDA und der Schwan"); 

  x_draw_init(0.0,100.0,0.0,0);

  for(i= 0; i< 16; i++) x_draw_line(0.0,0.0,95.0,20.0*i,i);

  while(x_read_mouse(0,0.0,0.0,&x,&y) != 3)
  { x_read_mouse(3,x,y,&x1,&y1);
    x_draw_filled_circle(x,y,hypot(x1-x,y1-y),1);
   // x_draw_arc(x,y,hypot(x1-x,y1-y),0.0,1.6,1);
   }

  x_draw_set_mode(1);

  for(;;)
  { i = 0;
    if (x_read_mouse(0,0.0,0.0,&px[0],&py[0])==3) break;
    while (x_read_mouse(1,px[i],py[i],&(px[i+1]),&(py[i+1])) !=3)
    { x_draw_line(px[i],py[i],px[i+1],py[i+1],1);
      i++;
     }
    x_draw_filled_polygon(i+1,px,py,1);
   }

  x_draw_set_mode(0);

  for(;;)
  { i = 0;
    if (x_read_mouse(0,0.0,0.0,&px[0],&py[0])==3) break;
    while (x_read_mouse(1,px[i],py[i],&(px[i+1]),&(py[i+1])) !=3)
    { x_draw_line(px[i],py[i],px[i+1],py[i+1],1);
      i++;
     }
    x_draw_filled_polygon(i+1,px,py,0);
   }

  x_draw_read_text_panel("string = ",0,0,0);

  x_draw_end();

 }
#endif
