/* 
 * Tubing and Extrusion header file.
 * This file provides protypes and defines for the extrusion 
 * and tubing primitives.
 *
 * Linas Vepstas 1991
 */

#ifndef __TUBE_H__
#define __TUBE_H__

/* some types */
#define gleDouble double
typedef gleDouble gleAffine[2][3];

/* defines for tubing join styles */
#define TUBE_JN_RAW          0x1
#define TUBE_JN_ANGLE        0x2
#define TUBE_JN_CUT          0x3
#define TUBE_JN_ROUND        0x4
#define TUBE_JN_MASK         0xf    /* mask bits */
#define TUBE_JN_CAP          0x10

/* determine how normal vectors are to be handled */
#define TUBE_NORM_FACET      0x100
#define TUBE_NORM_EDGE       0x200
#define TUBE_NORM_PATH_EDGE  0x400 /* for spiral, lathe, helix primitives */
#define TUBE_NORM_MASK       0xf00    /* mask bits */

/* closed or open countours */
#define TUBE_CONTOUR_CLOSED	0x1000


#ifdef GL_32
/* HACK for GL 3.2 -- needed because no way to tell if lighting is on.  */
#define TUBE_LIGHTING_ON	0x80000000
#endif /* GL_32 */

/* append identifying prefix for OpenGL version */
#if (defined OPENGL_10 || defined DEBUG_OPENGL_10)

#define extrusion	gleExtrusion
#define setjoinstyle	gleSetJoinStyle
#define getjoinstyle	gleGetJoinStyle
#define polycone	glePolyCone
#define polycylinder	glePolyCylinder
#define	super_extrusion	gleSuperExtrusion
#define	twist_extrusion	gleTwistExtrusion
#define	spiral		gleSpiral
#define	lathe		gleLathe
#define	helicoid	gleHelicoid

#endif /* OPENGL_10 */


#ifdef _NO_PROTO		/* NO ANSI C PROTOTYPING */

extern int getjoinstyle ();
extern void setjoinstyle ();
extern void polycone ();
extern void polycylinder ();
extern void extrusion ();
extern void super_extrusion ();
extern void twist_extrusion ();
extern void spiral ();
extern void lathe ();
extern void helicoid ();

#else /* _NO_PROTO */		/* ANSI C PROTOTYPING */

extern int getjoinstyle (void);
extern void setjoinstyle (int style);	/* bitwise OR of flags */

/* draw polyclinder, specified as a polyline */
extern void polycylinder (int npoints,		/* num points in polyline */
                   gleDouble point_array[][3],	/* polyline vertces */
                   float color_array[][3],	/* colors at polyline verts */
                   gleDouble radius);		/* radius of polycylinder */

/* draw polycone, specified as a polyline with radii */
extern void polycone (int npoints,	 /* numpoints in poly-line */
                   gleDouble point_array[][3],	/* polyline vertices */
                   float color_array[][3],	/* colors at polyline verts */
                   gleDouble radius_array[]); /* cone radii at polyline verts */

/* extrude arbitrary 2D contour along arbitrary 3D path */
extern void extrusion (int ncp,         /* number of contour points */
                gleDouble contour[][2],     /* 2D contour */
                gleDouble cont_normal[][2], /* 2D contour normals */
                gleDouble up[3],            /* up vector for contour */
                int npoints,            /* numpoints in poly-line */
                gleDouble point_array[][3], /* polyline vertices */
                float color_array[][3]); /* colors at polyline verts */

/* extrude 2D contour, specifying local rotations (twists) */
extern void twist_extrusion (int ncp,         /* number of contour points */
                gleDouble contour[][2],    /* 2D contour */
                gleDouble cont_normal[][2], /* 2D contour normals */
                gleDouble up[3],           /* up vector for contour */
                int npoints,           /* numpoints in poly-line */
                gleDouble point_array[][3],        /* polyline vertices */
                float color_array[][3],        /* color at polyline verts */
                gleDouble twist_array[]);   /* countour twists (in degrees) */

/* extrude 2D contour, specifying local affine tranformations */
extern void super_extrusion (int ncp,  /* number of contour points */
                gleDouble contour[][2],    /* 2D contour */
                gleDouble cont_normal[][2], /* 2D contour normals */
                gleDouble up[3],           /* up vector for contour */
                int npoints,           /* numpoints in poly-line */
                gleDouble point_array[][3],        /* polyline vertices */
                float color_array[][3],        /* color at polyline verts */
                gleDouble xform_array[][2][3]);   /* 2D contour xforms */

/* spiral moves contour along helical path by parallel transport */
extern void spiral (int ncp,        /* number of contour points */
             gleDouble contour[][2],    /* 2D contour */
             gleDouble cont_normal[][2], /* 2D contour normals */
             gleDouble up[3],           /* up vector for contour */
             gleDouble startRadius,	/* spiral starts in x-y plane */
             gleDouble drdTheta,        /* change in radius per revolution */
             gleDouble startZ,		/* starting z value */
             gleDouble dzdTheta,        /* change in Z per revolution */
             gleDouble startXform[2][3], /* starting contour affine xform */
             gleDouble dXformdTheta[2][3], /* tangent change xform per revoln */
             gleDouble startTheta,	/* start angle in x-y plane */
             gleDouble sweepTheta);	/* degrees to spiral around */

/* lathe moves contour along helical path by helically shearing 3D space */
extern void lathe (int ncp,        /* number of contour points */
             gleDouble contour[][2],    /* 2D contour */
             gleDouble cont_normal[][2], /* 2D contour normals */
             gleDouble up[3],           /* up vector for contour */
             gleDouble startRadius,	/* spiral starts in x-y plane */
             gleDouble drdTheta,        /* change in radius per revolution */
             gleDouble startZ,		/* starting z value */
             gleDouble dzdTheta,        /* change in Z per revolution */
             gleDouble startXform[2][3], /* starting contour affine xform */
             gleDouble dXformdTheta[2][3], /* tangent change xform per revoln */
             gleDouble startTheta,	/* start angle in x-y plane */
             gleDouble sweepTheta);	/* degrees to spiral around */

/* similar to spiral, except contour is a circle */
extern void helicoid (gleDouble rToroid, /* circle contour (torus) radius */
             gleDouble startRadius,	/* spiral starts in x-y plane */
             gleDouble drdTheta,        /* change in radius per revolution */
             gleDouble startZ,		/* starting z value */
             gleDouble dzdTheta,        /* change in Z per revolution */
             gleDouble startXform[2][3], /* starting contour affine xform */
             gleDouble dXformdTheta[2][3], /* tangent change xform per revoln */
             gleDouble startTheta,	/* start angle in x-y plane */
             gleDouble sweepTheta);	/* degrees to spiral around */

#endif /*_NO_PROTO*/

#endif /*__TUBE_H__*/
/* ================== END OF FILE ======================= */
