#include <stdio.h>
#include <math.h>

#define MAX_PIECES 36
#define AMB 0.3
#define IOR 0.0
#define RFL 0.6
#define RFR 0.0
#define DIF 0.0

struct vector
  {
  float x, y, z;
  };

FILE *output_file;

main()
{
  float start_x, start_y, start_z, radius;
  int number_pieces;
  void build_primary_hull(), build_propulsion_units(), build_secondary_hull();
    
  printf("enter start_x --> ");
  scanf("%f", &start_x);
  printf("enter start_y --> ");
  scanf("%f", &start_y);
  printf("enter start_z --> ");
  scanf("%f", &start_z);
  printf("enter number of sections for each cylinder--> ");
  scanf("%d", &number_pieces);
  printf("enter radius of primary hull --> ");
  scanf("%f", &radius);
  output_file = fopen("enterprisea.dat", "w");
  printf("building primary hull\n");
  build_primary_hull(start_x, start_y, start_z, number_pieces, radius);
  fprintf(output_file, "\* finished building primary hull\n");
  build_propulsion_units(start_x, start_y, start_z, number_pieces, radius);
  fprintf(output_file, "\* finished building propulsion units \n");
  build_secondary_hull(start_x, start_y, start_z, number_pieces, radius);
  fprintf(output_file, "\* finished building secondary hull \n");
/*
  build_deflector(start_x, start_y, start_z, number_pieces, radius);
*/
  fclose(output_file);
} /* end of build enterprise */

void build_arc(start_angle, end_angle, center_pt1, center_pt2, radius,
               pt1, pt2, count)
float start_angle, end_angle, center_pt1, center_pt2, radius, pt1[], pt2[];
int count;

{
float increment, angle, step;

  step = MAX_PIECES - count;
  increment = (end_angle - start_angle) / step;
  angle = start_angle;
printf("inside build_arc\n");
  while (count <= step - 1)
    {
    pt1[count] = center_pt1 + (sin ( (double) ((angle * 6.2874) / 360.0)) 
                   * radius);
    pt2[count] = center_pt2 + (cos ( (double) ((angle * 6.2874) / 360.0))
                   * radius);
    angle += increment;
    count++;
    } /* end of while */
printf("leaving build arc\n");
} /* end of build_arc */

void build_primary_hull(start_x, start_y, start_z, number_pieces, radius)
float start_x, start_y, start_z, radius;
int number_pieces;
{
struct vector upper_dish[MAX_PIECES], lower_dish[MAX_PIECES], side[MAX_PIECES];
float x[MAX_PIECES], y[MAX_PIECES], z[MAX_PIECES], degrees;
int i;
void build_arc();

printf("first step\n");
  if (number_pieces > MAX_PIECES)
    number_pieces = MAX_PIECES;
printf("inside build_primary_hull\n");
                                     /* build upper protion of disk */
  build_arc(0.0, 360.0, start_x, start_z, radius, x, z, 0);
printf("returned from build arc\n");
  for (i = 0; i < MAX_PIECES; i++)
    {
    upper_dish[i].x = x[i];
    upper_dish[i].y = start_y;
    upper_dish[i].z = z[i];
    lower_dish[i].x = x[i];
    lower_dish[i].y = start_y - (radius / 8);
    lower_dish[i].z = z[i];
    } /* end of for */
  for (i = 0; i < MAX_PIECES - 1; i++)
    {
                /* upper section of hull */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       start_x, start_y, start_z,
       upper_dish[i].x, upper_dish[i].y, upper_dish[i].z,
       upper_dish[i + 1].x, upper_dish[i + 1].y, upper_dish[i + 1].z);  
    }

  for (i = 0; i < MAX_PIECES - 1; i++)
    {
               /* lower section */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       start_x, start_y, start_z,
       lower_dish[i + 1].x, lower_dish[i + 1].y, lower_dish[i + 1].z,
       lower_dish[i].x, lower_dish[i].y, lower_dish[i].z);
    }

  for (i = 0; i < MAX_PIECES - 1; i++)
    {
               /* side section 1st triangle */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       upper_dish[i + 1].x, upper_dish[i + 1].y, upper_dish[i + 1].z,
       upper_dish[i].x, upper_dish[i].y, upper_dish[i].z,
       lower_dish[i + 1].x, lower_dish[i + 1].y, lower_dish[i + 1].z);  
               /* side section 2nd triangle */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       upper_dish[i].x, upper_dish[i].y, upper_dish[i].z,
       lower_dish[i].x, lower_dish[i].y, lower_dish[i].z,
       lower_dish[i + 1].x, lower_dish[i + 1].y, lower_dish[i + 1].z);  
    } /* end of for */
                /* upper section of hull */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       start_x, start_y, start_z,
       upper_dish[MAX_PIECES - 1].x, upper_dish[MAX_PIECES - 1].y, upper_dish[MAX_PIECES - 1].z,
       upper_dish[0].x, upper_dish[0].y, upper_dish[0].z);  

               /* lower section */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       start_x, start_y, start_z,
       lower_dish[0].x, lower_dish[0].y, lower_dish[0].z,  
       lower_dish[MAX_PIECES - 1].x, lower_dish[MAX_PIECES - 1].y, lower_dish[MAX_PIECES - 1].z);

               /* side section 1st triangle */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       upper_dish[0].x, upper_dish[0].y, upper_dish[0].z,
       upper_dish[MAX_PIECES - 1].x, upper_dish[MAX_PIECES - 1].y, upper_dish[MAX_PIECES - 1].z,
       lower_dish[0].x, lower_dish[0].y, lower_dish[0].z);  

               /* side section 2nd triangle */
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       upper_dish[MAX_PIECES - 1].x, upper_dish[MAX_PIECES - 1].y, upper_dish[MAX_PIECES - 1].z,
       lower_dish[MAX_PIECES - 1].x, lower_dish[MAX_PIECES - 1].y, lower_dish[MAX_PIECES - 1].z,
       lower_dish[0].x, lower_dish[0].y, lower_dish[0].z);  
}  /* end of build_pimary_hull */

void build_propulsion_units(start_x, start_y, start_z, number_pieces, radius)
float start_x, start_y, start_z, radius;
int number_pieces;
{
float x1, y1, z1, x2, eng_rad, x[MAX_PIECES], y[MAX_PIECES], z[MAX_PIECES];
struct vector front[MAX_PIECES], back[MAX_PIECES];
void build_arc();
int i;

  x1 = start_x + radius * 1.03125;
  y1 = start_y + radius * 1.125;
  z1 = start_z + radius * 0.9;
  x2 = x1 + (radius * 2.25);
  eng_rad = radius * 0.25;
  build_arc(0.0, 360.0, y1, z1, eng_rad, y, z, 0);
  for (i = 0; i < MAX_PIECES; i++)
    {
    front[i].x = x1;
    back[i].x = x2;
    front[i].y = back[i].y = y[i];
    front[i].z = back[i].z = z[i];
    }
  for (i = 0; i < MAX_PIECES - 1; i++)
    {
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[i+1].x, back[i+1].y, back[i+1].z,
       back[i].x, back[i].y, back[i].z,
       front[i].x, front[i].y, front[i].z);
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[i+1].x, back[i+1].y, back[i+1].z,
       front[i].x, front[i].y, front[i].z,
       front[i + 1].x, front[i + 1].y, front[i + 1].z);
    } 
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[0].x, back[0].y, back[0].z,
       back[MAX_PIECES - 1].x, back[MAX_PIECES - 1].y, back[MAX_PIECES - 1].z,
       front[MAX_PIECES - 1].x, front[MAX_PIECES - 1].y, front[MAX_PIECES - 1].z);
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[0].x, back[0].y, back[0].z,
       front[MAX_PIECES - 1].x, front[MAX_PIECES - 1].y, front[MAX_PIECES - 1].z,
       front[0].x, front[0].y, front[0].z);
}  /* build_propulsion_units */

void build_secondary_hull(start_x, start_y, start_z, number_pieces, radius)
float start_x, start_y, start_z, radius;
int number_pieces;
{
float x1, y1, z1, x2, x[MAX_PIECES], y[MAX_PIECES], z[MAX_PIECES];
struct vector front[MAX_PIECES], back[MAX_PIECES];
int i;
void build_arc();

  x1 = start_x + (radius / 3) * 1.25;
  y1 = start_y - (radius / 8) - (radius * 0.375);
  z1 = start_z;
  build_arc(0.0, 360.0, y1, z1, (radius * 0.21875), y, z, 0);
  for (i = 0; i < MAX_PIECES; i++)
    {
    front[i].x = x1;
    front[i].y = y[i];
    front[i].z = z[i];
    }
  x2 = x1 + (radius * 0.59375);
  build_arc(0.0, 360.0, y1, z1, (radius * 0.15625), y, z, 0);
  for (i = 0; i < MAX_PIECES; i++)
    {
    back[i].x = x2;
    back[i].y = y[i];
    back[i].z = z[i];
    }
  for (i = 0; i < MAX_PIECES - 1; i++)
    {
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[i+1].x, back[i+1].y, back[i+1].z,
       back[i].x, back[i].y, back[i].z,
       front[i].x, front[i].y, front[i].z);
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[i+1].x, back[i+1].y, back[i+1].z,
       front[i].x, front[i].y, front[i].z,
       front[i + 1].x, front[i + 1].y, front[i + 1].z);
    } 
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[0].x, back[0].y, back[0].z,
       back[MAX_PIECES - 1].x, back[MAX_PIECES - 1].y, back[MAX_PIECES - 1].z,
       front[MAX_PIECES - 1].x, front[MAX_PIECES - 1].y, front[MAX_PIECES - 1].z);
    fprintf(output_file, "F%3.1f %3.1f %3.1f %3.1f %3.1f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f\n",
       IOR, RFR, RFL, DIF, AMB, 
       back[0].x, back[0].y, back[0].z,
       front[MAX_PIECES - 1].x, front[MAX_PIECES - 1].y, front[MAX_PIECES - 1].z,
       front[0].x, front[0].y, front[0].z);
}
build_deflector(start_x, start_y, start_z, number_pieces, radius)
float start_x, start_y, start_z, radius;
int number_pieces;
{

}

