/*
 * color.h
 * $Log:	color.h,v $
 * Revision 4.0  91/07/17  14:30:08  kolb
 * Initial version.
 */
#ifndef COLOR_H
#define COLOR_H
/*
 * Color
 */
typedef struct Color {
	Float r, g, b;			/* Red, green, blue. */
} Color;
 
#define ColorScale(s,c,a)		(a)->r = (s)*(c).r, \
					(a)->g = (s)*(c).g, \
					(a)->b = (s)*(c).b
 
#define ColorAddScaled(x, s, y, c)	(c)->r = (x).r + (s)*(y).r, \
					(c)->g = (x).g + (s)*(y).g, \
					(c)->b = (x).b + (s)*(y).b
 
#define ColorMultiply(x,y,a)		(a)->r = (x).r*(y).r, \
					(a)->g = (x).g*(y).g, \
					(a)->b = (x).b*(y).b
 
#define ColorAdd(x,y,a)			(a)->r = (x).r+(y).r, \
					(a)->g = (x).g+(y).g, \
					(a)->b = (x).b+(y).b
#endif
