/*
 * Copyright (C) 1992 WIlfried Koch, Palanterstr. 46, D-5000 Koeln 41 (Germany)
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 * Initial version.
 */
#ifndef NETSPEC_H
#define NETSPEC_H

#ifdef _BSD
#include <sys/param.h>
#include <errno.h>
#define CALLBACK_VAR                                     \
        fd_set readfds;                                  \
        int    dtblsize = _rpc_dtablesize();             \
        extern int errno;                                \
        readfds=svc_fdset;
 
#define LISTEN_TO_NETWORK                                \
        select(dtblsize,&readfds,NULL,NULL,& LISTENTIMEOUT )
 
#define ERROR_LISTEN case -1
#define NO_MESSAGE   case  0
#define GOT_CALLBACK  default
 
#define ACTION_ON_ERROR_LISTEN {                        \
        if(errno != EBADF )                             \
                break;                                  \
        perror (" svc_run : - select failed \n");        \
        }
 
#define ACTION_ON_NO_MESSAGE  break
#endif /** BSD **/

#endif /**NETSPEC_H **/

