#include "config.h"
#ifdef RPC_HDR
%#ifndef RRPROG_H
%#define RRPROG_H
%#include "config.h"
%#include "progspec.h"
%#include <librr/rrpc.h>
#endif

#ifdef RAYSHADE40
/*********************** common rpc_headers **********************************/
#define Float double

typedef Float rpc_RTable[267];
struct rpc_ExprAssoc {
        u_long     lhs;                     /* left-hand side */
        rpc_Expr *expr;                    /* right-hand side */
        rpc_ExprAssoc *next;                /* Next in list */
};
struct rpc_Vec2d{
        Float u;                     /* 2D point */
        Float v;                     /* 2D point */
} ;
struct rpc_Vector {
        Float x;
        Float y;
        Float z;                        /* 3D point */
};

struct rpc_RSMatrix {
       Float matrix[9];                 /* Rotation matrix */
       rpc_Vector translate;                /* Translation */
};
struct rpc_Color {
          Float r;
          Float g;
          Float b;
        };

typedef rpc_Color rpc_ColorMap[256];

struct rpc_GeomList {
        struct rpc_Geom *obj;
        struct rpc_GeomList *next;
};
struct rpc_Instance{
        rpc_Geom *obj;       /* Geom being instantiated */
        Float bounds[6];
};
struct rpc_uInstance{
        long obj;       /* Geom being instantiated */
        Float bounds[6];
};
struct rpc_List{
        rpc_Geom *list;              /* List of prims/objs. in object */
        rpc_Geom *unbounded;         /* List of unbounded prims. */
        Float bounds[6];          /* Bounding box of object */
};
struct rpc_Rotate{
        Float x;
        Float y;
        Float z;
        Float theta;
};
/*********************** Blob rpc_headers **********************************/
struct rpc_MetaVector{
        Float rs;       /* radius */
        Float c4;       /* coeefficient */
        Float c2;       /* coeefficient */
        Float c0;       /* coeefficient */
        Float x;        /* x position */
        Float y;        /* y position */
        Float z;        /* z position */
};

/*********************** Box rpc_headers **********************************/
struct rpc_Box{
        Float bounds[6];
};
/*********************** Cone rpc_headers **********************************/
struct rpc_Cone {
        Float start_dist;
        rpc_Trans trans;
};
/*********************** csg rpc_headers **********************************/
#define CSG_UNION       0
#define CSG_INTERSECT   1
#define CSG_DIFFERENCE  2

/*********************** cylinder rpc_headers **********************************/
struct rpc_Cylinder {
        rpc_Trans trans;
};
/*********************** disc rpc_headers **********************************/
struct rpc_Disc {
        Float radius;                /* Radius squared, plane constant */
        Float d;                /* Radius squared, plane constant */
        rpc_Vector norm;                       /* Normal, center */
        rpc_Vector pos;
};
/*********************** plane rpc_headers **********************************/
struct rpc_Plane{
        rpc_Vector norm;        /* Plane normal, point on plane */
        rpc_Vector pos;
        Float d;                /* Plane constant. */
};
/*********************** sphere rpc_headers **********************************/
struct rpc_Sphere{
        Float r;           /* radius, radius squared */
        Float rsq;           /* radius, radius squared */
        Float x ;          /* position */
        Float y;          /* position */
        Float z;          /* position */
};
/*********************** torus rpc_headers **********************************/
struct  rpc_Torus{
        Float a;                /* tube radius */
        Float b;                /* swept radius */
        Float aa;                /* squares of the above */
        Float bb;
        rpc_Trans trans;            /* general<-->canonical transform */
};
/*********************** triangle rpc_headers **********************************/
struct rpc_Triangle{
        rpc_Vector  nrm;            /* triangle normal */
        rpc_Vector  p[3];           /* vertices */
        rpc_Vector  e[3];           /* "edge" vectors (scaled) */
        rpc_Vector  *vnorm;         /* Array of vertex normals */
        rpc_Vector  *dpdu;
        rpc_Vector  *dpdv;          /* U and V direction vectors */
        Float   d;              /* plane constant  */
        Float   b[3];           /* Array of barycentric coordinates */
        rpc_Vec2d   *uv;            /* Array of UV coordinates of vertices */
        char    index;         /* Flag used for shading/intersection test. */
        char    type;           /* type (to detect if phong or flat) */
};
struct  rpc_ShadowCache{
        struct rpc_Geom *obj;       /* Pointer to cached object */
        rpc_RSMatrix trans;     /* World-to-object transformation */
        char dotrans;           /* TRUE if above trans is non-identity */
};

struct rpc_Pointlight{
        rpc_Vector pos;
};
struct rpc_Spotlight {
        rpc_Vector pos;
        rpc_Vector dir;
        Float coef;
        Float radius;
        Float falloff;
};
struct rpc_Extended{
        rpc_Vector pos;
        Float radius;
};
struct rpc_Jittered{
        rpc_Vector pos;
        rpc_Vector curpos;
        rpc_Vector e1;
        rpc_Vector e2;
};
struct rpc_Infinite {
        rpc_Vector dir;
};
struct rpc_Surface {
        nm      name;                   /* Name */
        rpc_Color       amb;            /* Ambient 'curve' */
        rpc_Color       diff;           /* Diffuse reflection 'curve' */
        rpc_Color       spec;           /* Specular reflection 'curve' */
        rpc_Color       translu;        /* Diffuse transmission 'curve' */
        rpc_Color       body;           /* Specular transmission 'curve' */
        Float   srexp;                  /* Specular reflection exponent */
        Float   stexp;                  /* Specular transmission exponent */
        Float   statten;                /* Specular transmission attenuation */
        Float   index;                  /* Index of refraction */
        Float   reflect;                /* Specular reflectivity */
        Float   transp;                 /* Specular transmittance */
        Float   translucency;           /* Diffuse transmittance */
        char    noshadow;               /* No shadowing? */
        rpc_Surface *next;              /* Next surface in list (if any) */
} ;
struct rpc_Fog {
        rpc_Color   color;          /* Fog color */
        rpc_Color   trans;          /* Fog transmissivity */
};
struct rpc_Fogdeck {
        Float   alt;    /* Z value below which fogdeck deck exists. */
        Float   offset;
        Float   chaoscale;
        rpc_Vector  scale;
        rpc_Color   color;          /* Fogdeck color */
        rpc_Color   trans;          /* Fogdeck transmissivity */
        int     octaves;
};
struct rpc_Mist {
        rpc_Color color;            /* Mist color */
        rpc_Color trans;            /* R, G, B transmissivity */
        Float scale;
        Float zero;      /* Height scale, start Z */
};
struct rpc_Blotch {
        Float mix;
        rpc_uSurface_Ptr surf;
} ;
struct rpc_Bump {
        Float size;
};
struct rpc_Checker{
        rpc_Surface *surf;          /* Alternate surface */
};
struct rpc_CloudText{
        Float   beta;
        Float   omega;
        Float   lambda;
        Float   scale;
        Float   cthresh;
        Float   range;
        Float   transcale;
        Float   maxval;
        int     octaves;
};
struct rpc_FBm{
        Float   beta;
        Float   omega;
        Float   lambda;
        Float   scale;
        Float   offset;
        Float   thresh;
        int     octaves;
        rpc_ColorMap   *colormap;
};
struct rpc_Gloss{
        Float glossy;           /* glossiness */
};
struct rpc_ImageText{
        u_long  image;         /* image to use */
        rpc_Surface *surf;          /* Alternative surface */
        int     component;      /* component to texture */
        int      smooth;         /* interpolate pixel values? */
        Float   lo;         /* high and low values in image */
        Float   hi;         /* high and low values in image */
        Float   tileu;   /* tiling control */
        Float   tilev;   /* tiling control */
        rpc_Mapping *mapping;
};
struct rpc_Marble{
        rpc_ColorMap *colormap;        /* colormap */
};
struct rpc_Mount{
        Float turb;
        Float slope;
        rpc_ColorMap *cmap;
};
struct rpc_Sky{
        Float   beta;
        Float   omega;
        Float   lambda;
        Float   scale;
        Float   cthresh;
        Float   lthresh;
        int     octaves;
};
struct rpc_Stripe{
        rpc_uSurface_Ptr surf;
        rpc_Mapping *mapping;
        Float   width;
        Float   bump;
};

struct rpc_WindyText{
        Float   scale;
        Float   windscale;
        Float   chaoscale;
        Float   bumpscale;
        Float   tscale;
        Float   hscale;
        Float   offset;
        int     octaves;
};

struct  rpc_Medium {
        Float   index;                  /* Index of refraction */
        Float   statten;                /* specular transmission attenuation */
        struct rpc_Medium *next;
};
struct rpc_RSOptions {
        int     stereo;                 /* Stereo mode? */
        int     verbose;                /* Babbling mode? */
        int     quiet;                  /* Don't complain? */
        int     jitter;                 /* use jittered sampling? */
        int     samples;                /* Sqrt of # of samples */
        int     maxdepth;               /* Maximum ray tree depth */
        int     report_freq;            /* Frequency; in lines; of report */
        int     no_shadows;             /* Trace shadow rays? */
        int     shadowtransp;           /* ... through transparent objects? */
        int     cache;                  /* Cache shadowing info? */
        int     appending;              /* Append to image file? */
        int     resolution_set;         /* resolution set on command line */
        int     contrast_set;           /* contrast overridden ... */
        int     samples_set;            /* samples overridden ... */
        int     cutoff_set;             /* cutoff ... */
        int     maxdepth_set;           /* adaptive depth ... */
        int     window_set;             /* window ... */
        int     freq_set;               /* report frequency ... */
        int     jitter_set;             /* use jittering */
        int     eyesep_set;             /* eye separation ... */
        int     csg;                    /* CSG object someplace in world */
        int     flipnorm;               /* flip normals of polygonal objs */
        int     samplemap;              /* output sample map? */
        int     gaussian;               /* Use gaussian pixel filter? */
        int     framenum;               /* current frame number */
        int     startframe;             /* Starting frame number. */
        int     endframe;               /* ending frame number */
        int     totalframes;            /* total # of frames */
        int     totalframes_set;        /* set on command line? */
#ifdef URT
        int     alpha;                  /* Write alpha channel? */
        int     exp_output;             /* Write exponential RLE file? */
#endif
        Float   eyesep;                 /* Eye separation (for Stereo mode) */
        Float   gamma;                  /* Gamma value (0 == no correction) */
        Float   xmin;                    /* Window range */
        Float   xmax;
        Float   ymin;
        Float   ymax;
        Float   starttime;              /* Think about it ... */
        Float   shutterspeed;           /* time shutter is open */
        Float   framestart;             /* start time of the current frame */
        Float   framelength;            /* length of the current frame */
        Float   filterwidth;            /* Pixel filter width. */
        rpc_Color       contrast;       /* Max. allowable contrast */
        rpc_Color       cutoff;         /* Ray tree depth control */
        rpc_Color       ambient;        /* Ambient light multiplier */
        nm      progname;               /* argv[0] */
        nm      statsname;              /* Name of stats file. */
        nm      imgname;
        nm      inputname;      /* Name of input file, NULL == stdin */
        nm      cppargs;                /* arguments to pass to cpp */
#ifdef LINDA
        int     workers;                /* # of worker processes */
        int     workernum;              /* worker #, 0 == supervisor */
        int     verbose_worker;         /* Babble while you work? */
#endif

#ifdef  RPC
        int     is_rpc_client;              /* is a RPC CLIENT */
        int     is_rpc_server;              /* is a RPC SERVER */
        int     squaresize;
	int 	display;
        nm      serverfilename;
	nm      serverexestring;
#endif

        long    pictfile;               /*FILE    pictfile;  output file pointer */
};  
struct rpc_RSScreen {
        int     xres;                   /* Resolution of entire screen */
        int     yres;                   /* Resolution of entire screen */
        int     xsize;                  /* Resolution of window */
        int     ysize;                  /* Resolution of window */
        int     minx;                   /* Window to be rendered */
        int     miny;                   /* Window to be rendered */
        int     maxx;                   /* Window to be rendered */
        int     maxy;                   /* Window to be rendered */
        rpc_Vector  scrnx;              /* Horizontal & vertical screen axes */
        rpc_Vector  scrny;              /* Horizontal & vertical screen axes */
        rpc_Vector  scrni;              /* Normalized versions of the above */
        rpc_Vector  scrnj;              /* Normalized versions of the above */
        rpc_Vector  firstray;           /* Direction from eye to screen UL  */
        rpc_Color   background;         /* Background color */
};
struct rpc_RSCamera{
        rpc_Vector  pos;                    /* Eye position */
        rpc_Vector  lookp;                  /* Look position */
        rpc_Vector  dir;                   /* Look direction */
        rpc_Vector  up;                     /* 'Up' vector */
        Float   hfov;             /* Horizontal/vertical field of view */
        Float   vfov;             /* Horizontal/vertical field of view */
        Float   lookdist;               /* Eye pos/look pos distance */
        Float   aperture;               /* Aperture width (0 == pinhole) */
        Float   focaldist;              /* Distance from eye to focal plane */
};
#endif /**  RAYSHADE40 **/

#ifdef RPC_HDR
%#endif
#endif

