#import "GeneratorOverlay.h"
#import "aGroup-inter.h"
#import "Underlay.h"
#define  BX  bounds.origin.x
#define  BY  bounds.origin.y
#define  BW  bounds.size.width
#define  BH  bounds.size.height
#define RESIZE 0
#define ROTL 1
#define ROTR 2
#define DEFSIZ 200.0

@implementation GeneratorOverlay
+ new
{
  self = [super new];
  bframe.origin.x = bframe.origin.y = 0.0;
  bframe.size.width = bframe.size.height = GENOFFT;
  rebut = [[Button new]
	   initFrame: &bframe icon: "sizer" tag: RESIZE target: self 
	   action: @selector(resizeAction:) key: 0 enabled: YES];
  [[rebut cell] sendActionOn: NX_MOUSEDOWNMASK];
  [self addSubview: rebut];
  [self setAutoresizeSubviews: YES];
  group = nil;
  return self;
}

- setupGenerator: (id) agroup
{
  float x,y;
  
  x = y = DEFSIZ;
  resizing = NO;
  if (group != nil)
    [group removeFromSuperview];
  group = agroup;
  [self addSubview: group : NX_BELOW relativeTo: rebut]; // install new group as subview
  [group sizeKludge: &x : &y];
  [self sizeTo: x + 2* GENOFFT : y + 2 * GENOFFT];
  [group setGenovly: self];
  [group setupControls];
  [group defaultConfig];
  [group moveTo: GENOFFT : GENOFFT];
  [group sizeTo: x : y];
  [self moveTo: 0.0 : 0.0 ];
  [self placeResizer];
  return self;
}

- generatorDidResize
{
  NXSize *si;

  [group getGeneratorSize: si];
#ifdef DEBUG
  fprintf(stderr,"Generator size is: %f %f\n",si->width,si->height);
#endif
  [self sizeTo: si->width + 2.0* GENOFFT : si->height + 2.0 * GENOFFT ];
  [self placeResizer];
  return self;
}

- erase
{
  scratch = [under getImage];
  if([self lockFocus])
    [scratch composite: NX_COPY fromRect: &frame toPoint: &(bounds.origin)];
  else {
    [scratch composite: NX_COPY fromRect: &frame toPoint: &(bounds.origin)];
    [self unlockFocus];
  }
  return self;
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
  // draw transparent rect filling view
  PSsetrgbcolor(0.0,1.0,1.0);
  PSsetalpha(0.5);
  PScompositerect(BX,BY,BW,BH,NX_SOVER);
  // group object draws seethrough part
  return self;
}

- getImage
{
  return [under getImage];
}

- setUnderlay: (id) pad
{
  under = pad;
  return self;
}

- getGeneratorOffset: (NXPoint *) pt
{
  pt->x = frame.origin.x + GENOFFT;
  pt->y = frame.origin.y + GENOFFT;
  return self;
}

- mouseDownAction:(NXPoint *)pt
{
  dx = pt->x;
  dy = pt->y; 
  return self;
}

- mouseUpAction:(NXPoint *)pt
{
  resizing=NO;
  return self;
}

- mouseDraggedAction:(NXPoint *)pt
//move view under mouse
{
    [self convertPointToSuperview: pt];
    [self erase];
    if(resizing)
      [self resize: pt];
    else {
      pt->x -= dx;
      pt->y -= dy;
      [self moveTo: pt->x : pt->y];
    }
    [self display];
    return self;
}

- resize: (NXPoint *) pt
{
  float newh,neww;
  
  [self convertPointFromSuperview: pt];
  neww = pt->x + buttonclickofft.x;
  newh = pt->y + buttonclickofft.y;
  if(neww <= GENOFFT * 3) neww = GENOFFT * 3;
  if(newh <= GENOFFT * 3) newh = GENOFFT * 3;
  if([group isRigidLattice]){
    neww -= 2 * GENOFFT;
    newh -= 2 * GENOFFT;
    [group sizeKludge: &neww : &newh];
    neww += 2 * GENOFFT;
    newh += 2 * GENOFFT;
  }
  [self sizeTo: neww : newh];
  [self placeResizer];
  return self;
}

- resizeAction: sender
{
  NXEvent *ev;
  
#ifdef DEBUG
  fprintf(stderr,"ResizeAction\n");
#endif
  ev = [NXApp currentEvent];
  buttonclickofft.x = ev->location.x;
  buttonclickofft.y = ev->location.y;
  [self convertPoint: &buttonclickofft fromView: nil]; // window coords to my coords
  buttonclickofft.x = BW - buttonclickofft.x; // distance from button to edge of self
  buttonclickofft.y = BH - buttonclickofft.y;
  resizing = YES;
  [self becomeFirstResponder];
  [self mouseDown: ev];
  return self;
}

- placeResizer 
{
  float x,y;
  NXRect fr;

  [rebut getFrame: &fr];
  x = fr.size.width;
  y = fr.size.height;
  [rebut moveTo: BW - x : BH - y];
  return self;
}

- rotate: sender 
{
  return self;
}
@end
