/*
 *	MouseTracker -- Randy Nelson
 *	An abstract class that manages a modal loop for tracking the mouse
 *
 *	You may freely copy, distribute and reuse the code in this example.
 *	NeXT disclaims any warranty of any kind, expressed or implied, as to
 *	its fitness for any particular use.
 */

#import <appkit/View.h>

@interface MouseTracker:View
{
    float frameGray, backgroundGray;
}
- (float)frameGray;
- setFrameGray:(float)newGray;
- newFrameGray:sender;

- (float)backgroundGray;
- setBackgroundGray:(float)newGray;
- newBackgroundGray:sender;

- setTrackingRect:sender;
- mouseEntered:(NXEvent *)e;
- mouseExited:(NXEvent *)e;

- mouseDownAction:(NXPoint *)currentLocation;
- mouseDraggedAction:(NXPoint *)currentLocation;
- mouseUpAction:(NXPoint *)currentLocation;

@end
