/*
 *	MouseTracker -- Randy Nelson
 *	An abstract class that manages a modal loop for tracking the mouse
 *
 *	You may freely copy, distribute and reuse the code in this example.
 *	NeXT disclaims any warranty of any kind, expressed or implied, as to
 *	its fitness for any particular use.
 */

#import "MouseTracker.h"
#import <appkit/Window.h>
#import <appkit/Application.h>
#import <appkit/Control.h>
#import <dpsclient/psops.h>
#import <dpsclient/wraps.h>

#define FRAMECLR NX_BLACK
#define BCKGRNDCLR NX_WHITE

@implementation MouseTracker


- initFrame:(const NXRect *)theFrame
{
    [super initFrame:theFrame];
    return self;
}

- setTrackingRect:sender
{
    NXRect myFrame = frame;
    [[self superview] convertRect:&myFrame toView:nil];
    [window setTrackingRect:&myFrame
	    inside:NO
	    owner:self
	    tag:23
	    left:NO
	    right:NO];
    return self;
}

- (float)backgroundGray
{
    return backgroundGray;
}

- setBackgroundGray:(float)newGray
{
    backgroundGray = newGray;
    [self display];
    return self;
}

- setFrameGray:(float)newGray
{
    frameGray = newGray;
    [self display];
    return self;
}

- (float)frameGray
{
    return frameGray;
}

- newBackgroundGray:sender
{
    backgroundGray = [sender floatValue];
    [self display];
    return self;
}

- newFrameGray:sender
{
    frameGray = [sender floatValue];
    [self display];
    return self;
}

- mouseDown:(NXEvent *)e
 {
    NXPoint startPoint = e->location, nextPoint;
    int looping = YES;
    int oldMask = [window addToEventMask:NX_MOUSEDRAGGEDMASK];
    
    /* do first mouse down action */
    [self convertPoint:&startPoint fromView:nil];
    [self mouseDownAction:&startPoint];
    
    while (looping){
	e = [NXApp getNextEvent:NX_MOUSEUPMASK|NX_MOUSEDRAGGEDMASK];
	nextPoint = e->location;
	[self convertPoint:&nextPoint fromView:nil];
	if(e->type == NX_MOUSEDRAGGED){
	    [superview autoscroll:e];

	    /* do continuing mouse dragged action */
	    [self mouseDraggedAction:&nextPoint];
	}
	else{
	    looping = NO;

	    /* do mouse up action */
	    [self mouseUpAction:&nextPoint];
	}	
    }
    [window setEventMask:oldMask];
    return self;
 }
 
- mouseEntered:(NXEvent *)e
{
    return [super mouseEntered:e];
}

- mouseExited:(NXEvent *)e
{
    return [super mouseExited:e];
}

- drawSelf:(const NXRect *)r :(int)c
{
    return self;
}

- mouseDownAction:(NXPoint *)currentLocation
{	
    return self;
}

- mouseDraggedAction:(NXPoint *)currentLocation
{
    return self;
}

- mouseUpAction:(NXPoint *)currentLocation
{
    return self;
}

@end
