// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name:       adjvalue.h
//
// Purpose:    Interface to adjustabe value
//
// Created:     6 Apr 93    Michael Pichler
//
// Modified:   12 Apr 94    Bernhard Marschall
//
// Modified:   18 May 94    Michael Pichler
//
//
//</file>



#ifndef harmony_widgets_adjvalue_h
#define harmony_widgets_adjvalue_h


#include <InterViews/adjust.h>



//<class>
//
//
// Name: AdjValue
//
// Purpose: simple adjustable to "scroll" one value
//
// The value is given a lower and upper bound, an initial value,
//
//
//</class>




class AdjValue: public Adjustable
{
  public:
    AdjValue (                          // constructor
      float lower,                      //   lower bound
      float upper,                      //   upper bound
      float initial,                    //   initial value
      float small = 0.05,               //   small (line) scroll
      float large = 0.25                //   large (page) scroll
    );

    virtual ~AdjValue ();

    // shorthands (changing scroll increments)
    void smallScroll (Coord f)  { small_scroll (Dimension_X, f);  small_scroll (Dimension_Y, f); }
    void largeScroll (Coord f)  { large_scroll (Dimension_X, f);  large_scroll (Dimension_Y, f); }

    // Adjustable
    virtual Coord lower (DimensionName) const;
    virtual Coord upper (DimensionName) const;
    virtual Coord length (DimensionName) const;
    virtual Coord cur_lower (DimensionName) const;
    virtual Coord cur_upper (DimensionName) const;
    virtual Coord cur_length (DimensionName) const;

    virtual void scroll_to (DimensionName, Coord);

  protected:
    float lower_;
    float upper_;
    float curvalue_;
};



#endif
