// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        hg3dopt.h
//
// Purpose:     Scene viewer options and their default values
//
// Created:      7 Jun 93   Michael Pichler
//
// Changed:     30 Oct 95   Michael Pichler
//
//
// Description
// -----------
//
// Commandline options description and
// default properties (X attributes)
// for the Hyper-G 3D scene viewer
//
// should only be included into one file to avoid multiple string definitions
// (otherwhise have to split into .h and .C)
// 
// $Id: hg3dopt.h,v 1.7 1996/02/01 10:04:42 mpichler Exp $
//
//</file>


#ifndef hg_viewer_hg3d_hg3dopt_h
#define hg_viewer_hg3d_hg3dopt_h

#include <InterViews/session.h>



// command line options

OptionDesc hg3d_options [] =
{
  { "-demos",       "*DemoMenuItems",     OptionValueImplicit, "on" },
  { "-draw",        "*drawmode",          OptionValueNext },
  { "-drawmode",    "*drawmode",          OptionValueNext },
  { "-indirect",    "*indirectRendering", OptionValueImplicit, "on" },
  { "-singlebuf",   "*single_buffered",   OptionValueImplicit, "on" },
  { "-mesabackbuf", "*mesabackbuf",       OptionValueNext },
  { "-alphaplanes", "*alphaBitplanes",    OptionValueImplicit, "on" },
  { "-intdraw",     "*intdrawmode",       OptionValueNext },
  { "-intdrawmode", "*intdrawmode",       OptionValueNext },
  { "-speed",       "*speedFactor",       OptionValueNext },
  { "-lang",        "*language",          OptionValueNext },
  { "-language",    "*language",          OptionValueNext },
  { "-URL",         "*URL",               OptionValueNext },
  { "-remote",      "*remote",            OptionValueNext },
  { "-helpDir",     "*helpDir",           OptionValueNext },
  { "-mosaic",      "*mosaic",            OptionValueImplicit, "on" },
  { "-special",     "*SpecialMenuItems",  OptionValueImplicit, "on" },
  { "-verbose",     "*verbose",           OptionValueImplicit, "on" },
  { "-h",           "*commandlinehelp",   OptionValueImplicit, "on" },
  { "-help",        "*commandlinehelp",   OptionValueImplicit, "on" },
  { nil }
};



// explanation of command line options common to standalone and integrated viewer

const char* const commonViewerOptions =
  "  -verbose       verbose output (incl. IPC communication)\n"
  "  -lang[uage] lg [english|german|french|spanish|styrian]\n"
  "  -URL url       base url for relative references\n"
  "  -helpDir dir   directory where to find on-line help files\n"
  "  -draw[mode]    drawing mode: [wireframe|hiddenline|flat|smooth|texturing]\n"
  "  -intdraw[mode] interactive: one of the above or \"same\"\n"
  "  -speed         (overall) speed factor for navigation\n"
  "  -alphaplanes   inquire visual with alpha-bitplanes\n"
  "  -mesabackbuf   backbuffer for Mesa: [pixmap|image|auto]\n"
  "  -singlebuf     turn off double buffering for 3D renderings\n"
  "  -indirect      render OpenGL through X-server (slower)\n"
  "  -mosaic        use mosaic for anchor requests (else netscape)\n"
  "\n"
  "  -bg background, -fg foreground, -flat col, -font fn,\n"
  "  -display dis, -visual vClass, -visual_id 0xID, -dbuf, -nodbuf,\n"
  "  -sgimotif, -motif, -openlook, -xrm '*attribute:value'\n";



// default properties (X attributes)

// X attributes have the following priority order:
// 1. command line arguments
// 2. user defaults, loaded with xrdb (usually .Xdefaults)
// 3. application defaults (usually in /usr/lib/X11/app-defaults)
// 4. the values set below


PropertyData hg3d_props [] =
{
  // global Harmony resources (same for all viewers)
  { "*gui",                       "SGIMotif" },
  { "*double_buffered",           "on" },
  { "*PopupWindow*overlay",       "false" },
  { "*PopupWindow*saveUnder",     "on" },
  { "*TransientWindow*saveUnder", "on" },
  { "*foreground",                "black" },
  { "*background",                "#EEEEEE" },
  { "*flat",                      "#BBBBBB" },
  { "*font",                      "-*-new century schoolbook-medium-r-*-*-17-*-*-*-*-*-*-*" },
  { "*FieldEditor.flat",          "#FFB6B7" },
  { "*FieldEditor.background",    "#FFB6B7" },
  { "*FieldEditor.modifiedColour","#FFCEFF" },
  { "*Progress.foreground",       "#001B48" },
  { "*Progress.background",       "#888888" },
  { "*ProgressLabel.foreground",  "white" },
  { "*sliderSize",                "18" },
  { "*moverSize",                 "18" },
  { "*clickDelay",                "500" },

  // Scene Viewer specific resources
  { "*3D.background",             "#CCCCCC" },
  // TrueColor only set when required by implementation (see gecontext.h)
  { "*collisionDetection",        "on" },
  { "*pointerColor",              "red" },
  { "*demoPath",                  "./data" },
//{ "*initialDemo",               "test.wrl" },
#ifdef HARMONY3DSCENE
/* integrated harmony 3D scene viewer only */
  { "*DocumentMenuItems",         "on" },
#else
/* standalone 3D scene viewer only */
//{ "*DemoMenuItems",             "on" },
#endif
  { nil }
};


#endif
