/* labels.c */

extern int verbose;
#include <stdio.h>

#include <math.h>  /* fabs,log10,... */
#include "xyplot.h"

extern struct xy xd;
extern struct xy yd;
extern char xformat[];
extern char yformat[];
extern float numlblsize;
extern float overallsize;
extern int leftx;
extern int tickSize;

#define  TickSize  tickSize
 
 
axlab(c, p )
char c;
struct xy *p;
{
    int             mark;
    int             width, digits;
    char            buf[128];
	char            *format_s;
    float           x, xl, xu, delx;

	format_s = ((c=='x'||c=='X') ? xformat : yformat );
 
    if (p->xlogf) {
        for (x = p->xllb; x <= p->xub; x *= p->xquant) {
            if (p->xlb <= x && p->xub >= x) {
                sprintf(buf,format_s, x / p->xmult);
                mark = log10(x) * p->xa + p->xb;
                num_lbl(c, buf, mark);
            }
            if (p->xub / p->xlb <= SHORTLOGRANGE) {
                if (p->xlb <= 2 * x && p->xub >= 2 * x) {
                    sprintf(buf,format_s, 2 * x / p->xmult);
                    mark = log10(2 * x) * p->xa + p->xb;
                    num_lbl(c, buf, mark);
                }
                if (p->xlb <= 5 * x && p->xub >= 5 * x) {
                    sprintf(buf,format_s, 5 * x / p->xmult);
                    mark = log10(5 * x) * p->xa + p->xb;
                    num_lbl(c, buf, mark);
                }
            }
        }
    } else {                    /* its linear */
		outer_range(&xl,&xu,p);
		delx = fabs(p->xquant);
		
        digit(xl / p->xmult, xu / p->xmult, (int) ((xu - xl) / delx + 1.5),
              &width, &digits);
 
        for (x = xl; x <= xu; x += delx) {
			if ( !in_range(x,p,EPS) )
				continue;
            sprintf(buf,format_s, x / p->xmult);
            mark = (*p->xf) (x) * p->xa + p->xb;
            num_lbl(c, buf, mark);
        }
    }
}
 
 
num_lbl(c, buf, mark)
    int                mark;
    char            c, *buf;
{
    char            pri[BSIZ];
    int             i,dtik;
 
    gtou(buf, pri);
    switch (c) {
    case 'x':
		dtik = 2*neg(TickSize + 0.8*SSize);
        cascii(pri, mark, yd.xbot - (int) (2.5 * NumlblSize) - dtik,
               numlblSize);
        break;
    case 'X':
		dtik = 2*neg(TickSize + 0.8*SSize);
        cascii(pri, mark, yd.xtop + (int) (2.5 * NumlblSize) + dtik,
               numlblSize);
        break;
    case 'y':
		dtik = 2*neg(TickSize + 0.2*SSize);
		/* the 1.5 specifies how close y-axis label is to numbers */
        i = xd.xbot - (1.5 + 1.0*strlen(pri)) * NumlblSize - dtik;
        if (i<leftx) {
			if (verbose) fprintf(stderr,"leftx = %d\n",i);
			leftx = i;
		}
        rascii(pri, xd.xbot - (int) (NumlblSize) - dtik,
               mark, numlblSize);
        break;
    case 'Y':
		dtik = 2*neg(TickSize + 0.2*SSize);
        ascii(pri, xd.xtop + (int) (NumlblSize) + dtik,
               mark, numlblSize);
        break;
    }
}
 
 
digit(xlo,xhi,nlab,width,digits) 
float xlo,xhi;int nlab,*width,*digits;
{
	double delta,x,y;
	int p,q;
	double r1,r2,r3;
	delta=(xhi-xlo)/(nlab-1);
	x=log10(delta);
	if(x>=0)  p= (int) x;
	else p= (int)( x-.9);
	y=pow((double)10,(double)(-p));
	r1=fabs((double)(xlo*y)); r2=fabs((double)(xhi*y));
	r3=max(r1,r2);
	q=(int)(1+log10(r3));
	/*	q=(int)(1+log10(max(fabs((double)(xlo*y)),fabs((double)(xhi*y))))); */
	if( p >=0 )  {*digits =0;
				  *width =p+q;}
	else {*digits= -p;
		  *width= 1+q+((-p)>q)*(1+(-p)-q);
	  }
	if( xlo<0 || xhi < 0 ) (*width) ++;
	if( q==(-p) ) (*width) ++;
}
