/* ugparse.c */
/*
  routines for making viewproc compatible with UNIX plot
*/

#include <stdio.h>
#include "xyview.h"

static void	   get_scaled_xy(/* int *, int *, FILE * */);
static void	get_un_scaled_xy(/* int *, int *, FILE * */);
static void swap_bytes(/* char *, char */);
static void fread_swap_bytes(/* short *, int, int, FILE * */);
static void rescale(/* int, int, int, int */);
static char *getstil(/* char *, int, char, FILE * */);

int
ug_parse(fp)
FILE	*fp;
{
	char c;
    c = getc(fp);

    switch(c)
    {
    case 'p':
    case 'l':
    case 'm':
    case 'n':
    case 't':
    case 'a':
    case 'c':
    case 'e':
    case 'f':
    case 's':
	unix_plot_command(c,fp);
	break;

    default:
	break;
    }

    return(c);
}

int
unix_plot_command(c,fp)
int	c;
FILE	*fp;
{
    char	buf[80];
    char	*word;
    static	int		x,y,z,w;

    switch(c)
    {
    case 'p':
		get_scaled_xy(&x,&y,fp);
		move_abs(x,y);
		point();
		DBPRINTF("P %d %d\n",x,y);
		break;

    case 'l':
		get_scaled_xy(&x,&y,fp);
		move_abs(x,y);
		get_scaled_xy(&z,&w,fp);
		cont(z,w);
		DBPRINTF("L %d %d %d %d\n",x,y,z,w);
		break;

    case 'm':
		get_scaled_xy(&x,&y,fp);
		move_abs( x,y );
		break;
    case 'n':
		get_scaled_xy(&x,&y,fp);
		cont( x,y );
		DBPRINTF("S %d %d %d %d\n", x,y);
		break;

    case 't':
		word = getstil(buf,80,'\n',fp);
		move_rel(0,CHAR_HEIGHT-1);
		label(word);
		move_rel(0,1-CHAR_HEIGHT);
		DBPRINTF("T %d %d %s\n", x,y,word);
		if(DEBUG) move_rel( CHAR_WIDTH*strlen(word), 0 );
		break;

    case 'a':
		get_scaled_xy(&x,&y,fp);
		get_scaled_xy(&x,&y,fp);
		get_scaled_xy(&x,&y,fp);
		move_abs( x,y );
		/* -- no arc is drawn -- */
		break;

    case 'c':
		get_scaled_xy(&x,&y,fp);
		fread(&z,sizeof(short),1,fp);	/* swallow two bytes */
		move_abs( x,y );
		/* -- no circle is drawn -- */
		break;

    case 'e':
		erase();
		break;

    case 'f':
		word = getstil(buf,80,'\n',fp);
		linemod(buf);
		/* -- all linestyles treated as "solid" -- */
		break;

    case 's':
		get_un_scaled_xy(&x,&y,fp);
		get_un_scaled_xy(&z,&w,fp);
		rescale(x,y,z,w);
		DBPRINTF("SCALE: %d %d %d %d\n",x,y,z,w);
		break;
    default:
		break;
    }
}


static	int	Xo=0,Yo=0;			/* origin */
static	int	Xs=500,Ys=500;		/* size   */

static	int	Xdevice=500;		/* device size */
static	int	Ydevice=500;

static	double	Xscale=1.0;
static	double	Yscale=1.0;

#define UNIXPLOTPAD	30	/* pixels to pad so that unix-plot fits in window */
/*********************************************
 *	set_unixplot_window:
 *		called from other routines, to tell
 *		this routine how big the window is
 */
void
set_unixplot_window(Wxs,Wys)
int Wxs,Wys;
{
    Xdevice = Wxs-UNIXPLOTPAD;
    Ydevice = Wys-UNIXPLOTPAD;
}

static void
rescale(xo,yo,xs,ys)
int	xo,yo,xs,ys;
{
    Xo = xo;
    Yo = yo;
    Xs = xs;
    Ys = ys;
    Xscale = (double)Xdevice/Xs;
    Yscale = (double)Ydevice/Ys;
}

static void
get_scaled_xy(px,py,fp)
int	*px,*py;
FILE	*fp;
{
    get_un_scaled_xy(px,py,fp);
    *px =           Xscale*((*px)-Xo);
    *py = Ydevice - Yscale*((*py)-Yo);
}
static void
get_un_scaled_xy(px,py,fp)
int	*px,*py;
FILE	*fp;
{
    short	shxy[2];

    fread_swap_bytes(shxy,sizeof(short),2,fp);
    *px = shxy[0];
    *py = shxy[1];
}

/* routines for reading and swapping bytes */
/* --------------------------------------- */

static void
fread_swap_bytes(c,sz,n,fp)
short	*c;
int	sz,n;
FILE	*fp;
{
    fread((char *)c,sz,n,fp);
    swap_bytes((char *)c,n);
}

static void
swap_bytes(c,n)
char	*c;
char	n;
{
    int		i;
    char	tswap;
    for(i=0; i<n; ++i, ++c,++c)
    {	
	tswap = *c;
	*c = *(c+1);
	*(c+1) = tswap;
    }
}

/* getstil() reads the stream fp until it encounters character c */
/* it replaces c with '\0' and returns the string in buf[] */

static char	*
getstil(buf,n,c,fp)
char	*buf;
int	n;
char	c;
FILE	*fp;
{
    int	i;
    for(i=0; i<n-1; ++i)
    {
	buf[i] = getc(fp);
	if(buf[i]==c || buf[i]=='\0')
	    break;
	}
    buf[i]='\0';
    return(buf);
}
