#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Ticks (NumTic, term)


******************************************************************
*                                                                *
*   User_Define_Tick_Marks                                       *
*                                                                *
*      This subroutine allows the user to specify the number     *
*      of tick marks for both the x and y axis.                  *
*      It also gives the user the chance to define a grid        *
*      instead of discrete tic marks.                            *
*                                                                *
******************************************************************

        Logical        Gridon
        Integer                GType
        Common /grids/ Gridon, GType
        Save   /grids/

        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Integer NumTic(2), term, I
        Character ans*1
        Character *10 num1, num2, num3, num4

    1   Call Clear(term)
        Call number (WXmin, .TRUE., num1)
        Call number (WXmax, .TRUE., num2)
        Call number (WYmin, .TRUE., num3)
        Call number (WYmax, .TRUE., num4)
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
   10   Format (/,15x,'Select Tic Marks',//
     +            ,5x,'Current window settings:',//
     +          ,12x,'X-min',10x,'X-max',/,10x,10('-'),5x,10('-')/
     +          ,10x,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>'//
     +          ,12x,'Y-min',10x,'Y-max',/,10x,10('-'),5x,10('-'),/10x
     +          ,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>',/5x,/)

        Write (*,20)
   20   Format (5x,'Please enter the number of tic marks desired',/
     +          5x,'for the X axis (0 - 25) ...')
        Read (*,'(i2)',err=1) NumTic(1)

    2   Call Clear(term)
        Write (*,10) num1, num2, lowx, hix, num3, num4, lowy, hiy
        Write (*,30)
   30   Format (5x,'Please enter the number of tic marks desired',/
     +          5x,'for the Y axis (0 - 25) ...')
        Read (*,'(i2)',err=2) NumTic(2)

*       (* Set to defaults if necessary *)
        DO 100 I = 1,2
          IF (NumTic(I) .LT. 0) THEN
            NumTic(I) = 0
          ELSEIF (NumTic(I) .GT. 25) THEN
            NumTic(I) = 25
          ENDIF
  100   CONTINUE

    3   Call Clear(term)
        Write (*,40)
   40   Format (5x,'Would you like a grid to be drawn over the window?'
     +          ' (y,n)',/)
        Read (*,'(a1)',err=3) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
          Gridon = .TRUE.

*
*       Select type of grid.
*
  490     Call clear(term)
          Write (*,500) 
  500     Format(/,15x,'Specify Line Type For Grid',///
     +             , 5x,'The following line types are available:',//
     +             ,10x,'1.  Solid              ',//
     +             ,10x,'2.  Dot                ',//
     +             ,10x,'3.  Dot - Dash         ',//
     +             ,10x,'4.  Short - Dash       ',//
     +             ,10x,'5.  Long - Dash        ',//
     +             , 5x,'Enter option (1 - 5) for the grid ...')
          Read(*,'(i3)',err=490) GType

  600     IF (GType .LT. 1 .OR. GType .GT. 5) THEN
  610       Call clear(term)
            Write (*,'(a1)') Char(7)
            Write (*,500)   
            Read(*,'(i3)',err=610) GType    
            GOTO 600
          ENDIF
        ELSE
          Gridon = .FALSE.
        ENDIF

        RETURN
        END
